/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.legacy.mongo;

import com.mongodb.MongoNamespace;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.operation.BatchCursor;
import kamon.Kamon;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.context.HasContext;
import kamon.instrumentation.legacy.mongo.MongoClientInstrumentation;
import kamon.trace.Span;
import kanela.agent.libs.net.bytebuddy.asm.Advice;

public class ExecuteOperationAdvice {
    @Advice.OnMethodEnter
    public static <T> Storage.Scope enter(@Advice.This Object object, @Advice.FieldValue(value="namespace") MongoNamespace mongoNamespace, @Advice.Origin(value="#t") String string) {
        String string2 = object instanceof MongoClientInstrumentation.HasOperationName ? ((MongoClientInstrumentation.HasOperationName)object).name() : string;
        Span span = MongoClientInstrumentation.clientSpanBuilder(mongoNamespace, string2).start();
        return Kamon.storeContext((Context)Kamon.currentContext().withEntry(Span.Key(), (Object)span));
    }

    @Advice.OnMethodExit
    public static void exit(@Advice.Enter Storage.Scope scope, @Advice.Return Object object) {
        Span span = (Span)scope.context().get(Span.Key());
        if (object instanceof BatchCursor && object instanceof HasContext) {
            ((HasContext)object).setContext(Context.of((Context.Key)Span.Key(), (Object)span));
        }
        if (object instanceof BulkWriteResult) {
            BulkWriteResult bulkWriteResult = (BulkWriteResult)object;
            span.tag("mongo.bulk.ack", bulkWriteResult.wasAcknowledged()).tag("mongo.bulk.inserted", (long)bulkWriteResult.getInsertedCount()).tag("mongo.bulk.modified", (long)bulkWriteResult.getModifiedCount()).tag("mongo.bulk.matched", (long)bulkWriteResult.getMatchedCount()).tag("mongo.bulk.deleted", (long)bulkWriteResult.getDeletedCount());
        }
        span.finish();
        scope.close();
    }
}

