/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.kafka.client;

import com.typesafe.config.Config;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.kafka.client.ConsumedRecordData;
import kamon.instrumentation.kafka.client.KafkaInstrumentation;
import kamon.instrumentation.kafka.client.KafkaInstrumentation$Syntax$;
import kamon.instrumentation.kafka.client.KafkaPropagator;
import kamon.instrumentation.kafka.client.SpanPropagation$KCtxHeader$;
import kamon.instrumentation.kafka.client.SpanPropagation$W3CTraceContext$;
import kamon.trace.Span;
import kamon.trace.Span$;
import kamon.trace.SpanBuilder;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import scala.util.control.NonFatal$;

public final class KafkaInstrumentation$ {
    public static final KafkaInstrumentation$ MODULE$ = new KafkaInstrumentation$();
    private static volatile KafkaInstrumentation.Settings _settings = MODULE$.readSettings(Kamon$.MODULE$.config());
    private static final Logger log;

    static {
        Kamon$.MODULE$.onReconfigure((Function1 & Serializable)newConfig -> {
            KafkaInstrumentation$.MODULE$._settings_$eq(KafkaInstrumentation$.MODULE$.readSettings(newConfig));
            return BoxedUnit.UNIT;
        });
        log = LoggerFactory.getLogger(KafkaInstrumentation.Settings.class);
    }

    private KafkaInstrumentation.Settings _settings() {
        return _settings;
    }

    private void _settings_$eq(KafkaInstrumentation.Settings x$1) {
        _settings = x$1;
    }

    private Logger log() {
        return log;
    }

    public KafkaInstrumentation.Settings settings() {
        return this._settings();
    }

    private KafkaInstrumentation.Settings readSettings(Config config) {
        KafkaPropagator kafkaPropagator;
        boolean bl;
        boolean bl2;
        boolean bl3;
        block5: {
            Config kafkaConfig = config.getConfig("kamon.instrumentation.kafka.client");
            String identifierScheme = config.getString("kamon.trace.identifier-scheme");
            bl3 = kafkaConfig.getBoolean("tracing.start-trace-on-producer");
            bl2 = kafkaConfig.getBoolean("tracing.continue-trace-on-consumer");
            bl = kafkaConfig.getBoolean("tracing.use-delayed-spans");
            String string = kafkaConfig.getString("tracing.propagator");
            switch (string == null ? 0 : string.hashCode()) {
                case 116039: {
                    if (!"w3c".equals(string)) break;
                    String string2 = identifierScheme;
                    String string3 = "double";
                    if (string2 == null ? string3 != null : !string2.equals(string3)) {
                        this.log().warn("W3C TraceContext propagation should be used only with identifier-scheme = double");
                    }
                    kafkaPropagator = SpanPropagation$W3CTraceContext$.MODULE$.apply();
                    break block5;
                }
                case 3286492: {
                    if (!"kctx".equals(string)) break;
                    kafkaPropagator = SpanPropagation$KCtxHeader$.MODULE$.apply();
                    break block5;
                }
            }
            throw package$.MODULE$.error(new StringBuilder(92).append("Unrecognized option [").append(string).append("] for the kamon.instrumentation.kafka.client.tracing.propagator config.").toString());
        }
        return new KafkaInstrumentation.Settings(bl3, bl2, bl, kafkaPropagator);
    }

    public <K, V> Context extractContext(ConsumerRecord<K, V> consumerRecord) {
        return KafkaInstrumentation$Syntax$.MODULE$.context$extension(this.Syntax(consumerRecord));
    }

    public ConsumerRecord<?, ?> Syntax(ConsumerRecord<?, ?> cr) {
        return cr;
    }

    public <T> T runWithConsumerSpan(ConsumerRecord<?, ?> record, Function0<T> f) {
        return this.runWithConsumerSpan(record, "consumer.process", true, f);
    }

    public <T> T runWithConsumerSpan(ConsumerRecord<?, ?> record, String operationName, Function0<T> f) {
        return this.runWithConsumerSpan(record, operationName, true, f);
    }

    public <T> T runWithConsumerSpan(ConsumerRecord<?, ?> record, String operationName, boolean finishSpan, Function0<T> f) {
        Object object;
        Context incomingContext = KafkaInstrumentation$Syntax$.MODULE$.context$extension(this.Syntax(record));
        Context operationContext = incomingContext.nonEmpty() ? incomingContext : Kamon$.MODULE$.currentContext();
        Span span = this.consumerSpan(record, operationName);
        Storage.Scope scope = Kamon$.MODULE$.storeContext(operationContext.withEntry(Span$.MODULE$.Key(), (Object)span));
        try {
            try {
                object = f.apply();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    span.fail(t.getMessage(), t);
                    throw t;
                }
                throw throwable;
            }
        }
        finally {
            if (finishSpan) {
                span.finish();
            }
            scope.close();
        }
        return (T)object;
    }

    public Span consumerSpan(ConsumerRecord<?, ?> record) {
        return this.consumerSpan(record, "consumer.process");
    }

    public Span consumerSpan(ConsumerRecord<?, ?> record, String operationName) {
        Object object;
        SpanBuilder consumerSpan = Kamon$.MODULE$.consumerSpanBuilder(operationName, "kafka.consumer").tag("kafka.topic", record.topic()).tag("kafka.partition", (long)record.partition()).tag("kafka.offset", record.offset()).tag("kafka.timestamp", record.timestamp()).tag("kafka.timestamp-type", record.timestampType().name);
        Option$.MODULE$.apply(record.key()).foreach((Function1 & Serializable)k -> consumerSpan.tag("kafka.key", k.toString()));
        if (record instanceof ConsumedRecordData) {
            ConsumedRecordData consumerRecordData = (ConsumedRecordData)record;
            Context incomingContext = consumerRecordData.incomingContext();
            Span incomingSpan = (Span)incomingContext.get(Span$.MODULE$.Key());
            consumerSpan.tag("kafka.group-id", (String)consumerRecordData.consumerInfo().groupId().getOrElse((Function0 & Serializable)() -> "unknown")).tag("kafka.client-id", consumerRecordData.consumerInfo().clientId()).tag("kafka.poll-time", consumerRecordData.nanosSincePollStart());
            object = !incomingSpan.isEmpty() ? (this.settings().continueTraceOnConsumer() ? consumerSpan.asChildOf(incomingSpan) : consumerSpan.link(incomingSpan, (Span.Link$.Kind)Span.Link$.Kind$.FollowsFrom$.MODULE$)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return this.settings().useDelayedSpans() ? consumerSpan.delay(Kamon$.MODULE$.clock().toInstant(record.timestamp() * 1000000L)).start() : consumerSpan.start();
    }

    private KafkaInstrumentation$() {
    }
}

