/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.jdbc;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Instant;
import kamon.Kamon$;
import kamon.instrumentation.jdbc.ConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.DatabaseTags;
import kamon.instrumentation.jdbc.HasConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.HasDatabaseTags;
import kamon.instrumentation.jdbc.JdbcMetrics$;
import kamon.instrumentation.jdbc.StatementMonitor;
import kamon.instrumentation.jdbc.utils.LoggingSupport;
import kamon.instrumentation.jdbc.utils.SqlVisitor;
import kamon.metric.RangeSampler;
import kamon.tag.Lookups$;
import kamon.tag.TagSet$;
import kamon.trace.SpanBuilder;
import kanela.agent.bootstrap.stack.CallStackDepth;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

public final class StatementMonitor$
implements LoggingSupport {
    public static final StatementMonitor$ MODULE$ = new StatementMonitor$();
    private static volatile boolean parseSqlOperationName;
    private static Logger logger;

    static {
        LoggingSupport.$init$(MODULE$);
        parseSqlOperationName = MODULE$.loadSqlParsingConfig(Kamon$.MODULE$.config());
        Kamon$.MODULE$.onReconfigure((Function1 & Serializable)config -> {
            StatementMonitor$.MODULE$.parseSqlOperationName_$eq(StatementMonitor$.MODULE$.loadSqlParsingConfig(config));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void logInfo(Function0<String> msg) {
        LoggingSupport.logInfo$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        LoggingSupport.logWarn$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        LoggingSupport.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Function0<Throwable> exc) {
        LoggingSupport.logError$(this, msg, exc);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        LoggingSupport.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        LoggingSupport.logTrace$(this, msg);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void kamon$instrumentation$jdbc$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private boolean parseSqlOperationName() {
        return parseSqlOperationName;
    }

    private void parseSqlOperationName_$eq(boolean x$1) {
        parseSqlOperationName = x$1;
    }

    private boolean loadSqlParsingConfig(Config config) {
        return config.getBoolean("kamon.instrumentation.jdbc.parse-sql-for-operation-name");
    }

    public Option<StatementMonitor.Invocation> start(Object statement, String sql, String statementType) {
        None$ none$;
        block13: {
            block10: {
                String string;
                RangeSampler rangeSampler;
                DatabaseTags databaseTags;
                Instant startTimestamp;
                block12: {
                    Tuple2 tuple2;
                    block11: {
                        Tuple2 tuple22;
                        HasConnectionPoolTelemetry hasConnectionPoolTelemetry;
                        if (CallStackDepth.incrementFor((Object)statement) != 0) break block10;
                        startTimestamp = Kamon$.MODULE$.clock().instant();
                        Object object = statement;
                        if (object instanceof HasConnectionPoolTelemetry && (hasConnectionPoolTelemetry = (HasConnectionPoolTelemetry)object).connectionPoolTelemetry() != null && hasConnectionPoolTelemetry.connectionPoolTelemetry().get() != null) {
                            ConnectionPoolTelemetry poolTelemetry = hasConnectionPoolTelemetry.connectionPoolTelemetry().get();
                            tuple22 = new Tuple2((Object)poolTelemetry.instruments().inFlightStatements(), (Object)poolTelemetry.databaseTags());
                        } else {
                            HasDatabaseTags hasDatabaseTags;
                            tuple22 = object instanceof HasDatabaseTags && (hasDatabaseTags = (HasDatabaseTags)object).databaseTags() != null ? new Tuple2(JdbcMetrics$.MODULE$.InFlightStatements().withTags(hasDatabaseTags.databaseTags().metricTags()), (Object)hasDatabaseTags.databaseTags()) : new Tuple2((Object)JdbcMetrics$.MODULE$.InFlightStatements().withoutTags(), (Object)new DatabaseTags(TagSet$.MODULE$.Empty(), TagSet$.MODULE$.Empty()));
                        }
                        tuple2 = tuple22;
                        if (tuple2 == null) break block11;
                        RangeSampler inFlightRangeSampler = (RangeSampler)tuple2._1();
                        databaseTags = (DatabaseTags)tuple2._2();
                        if (inFlightRangeSampler == null) break block11;
                        rangeSampler = inFlightRangeSampler;
                        if (databaseTags != null) break block12;
                    }
                    throw new MatchError((Object)tuple2);
                }
                DatabaseTags databaseTags2 = databaseTags;
                Tuple2 tuple2 = new Tuple2((Object)rangeSampler, (Object)databaseTags2);
                Tuple2 tuple23 = tuple2;
                RangeSampler inFlightRangeSampler = (RangeSampler)tuple23._1();
                DatabaseTags databaseTags3 = (DatabaseTags)tuple23._2();
                if (this.parseSqlOperationName()) {
                    try {
                        Statement statement2 = CCJSqlParserUtil.parse(sql);
                        SqlVisitor statementVisitor = new SqlVisitor(statementType);
                        statement2.accept(statementVisitor);
                        string = statementVisitor.operation();
                    }
                    catch (Exception e) {
                        if (this.logger().isInfoEnabled()) {
                            this.logger().info(new StringBuilder(43).append("Could not parse sql to get operation name: ").append(sql).toString(), (Throwable)e);
                        }
                        string = statementType;
                    }
                } else {
                    string = statementType;
                }
                String spanName = string;
                SpanBuilder clientSpan = Kamon$.MODULE$.clientSpanBuilder(spanName, "jdbc").tag("db.statement", sql);
                databaseTags3.spanTags().iterator().foreach((Function1 & Serializable)t -> clientSpan.tag(t.key(), (String)databaseTags3.spanTags().get(Lookups$.MODULE$.coerce(t.key()))));
                databaseTags3.metricTags().iterator().foreach((Function1 & Serializable)t -> clientSpan.tagMetrics(t.key(), (String)databaseTags3.metricTags().get(Lookups$.MODULE$.coerce(t.key()))));
                inFlightRangeSampler.increment();
                none$ = new Some((Object)new StatementMonitor.Invocation(statement, clientSpan.start(startTimestamp), sql, startTimestamp, inFlightRangeSampler));
                break block13;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private StatementMonitor$() {
    }
}

