/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.host;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kamon.Kamon$;
import kamon.instrumentation.system.host.HostMetrics;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kamon.util.Filter;
import kamon.util.Filter$;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.OperatingSystem;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011-a\u0001B3g\u0001=D\u0001\u0002 \u0001\u0003\u0002\u0003\u0006I! \u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u000b\u0011%\t9\u0003\u0001a\u0001\n\u0013\tI\u0003C\u0005\u0003L\u0001\u0001\r\u0011\"\u0003\u0003N!A!q\u000b\u0001!B\u0013\tY\u0003C\u0005\u0003b\u0001\u0011\r\u0011\"\u0003\u0003d!A1Q\u0004\u0001!\u0002\u0013\u0011)\u0007C\u0005\u0004 \u0001\u0011\r\u0011\"\u0003\u0004\"!A11\u0015\u0001!\u0002\u0013\u0019\u0019\u0003C\u0005\u0004&\u0002\u0011\r\u0011\"\u0003\u0004(\"A1q\u0018\u0001!\u0002\u0013\u0019I\u000bC\u0005\u0004L\u0002\u0011\r\u0011\"\u0003\u0004N\"A1q\u001b\u0001!\u0002\u0013\u0019y\rC\u0004\u0004Z\u0002!\tEa\u001f\t\u000f\rm\u0007\u0001\"\u0011\u0004^\"91q\u001f\u0001\u0005\n\re\bbBB\u007f\u0001\u0011%1q \u0004\n\u0005_\u0002\u0001\u0013aI\u0001\u0005cBqAa\u001d\u0015\r\u0003\u0011)\bC\u0004\u0003zQ1\tAa\u001f\u0007\r\t%\u0004\u0001\u0002B6\u0011\u001d\t9a\u0006C\u0001\u0005{B\u0011Ba \u0018\u0005\u0004%IA!!\t\u0011\t=u\u0003)A\u0005\u0005\u0007C\u0011B!%\u0018\u0005\u0004%IAa%\t\u0011\t\u0005v\u0003)A\u0005\u0005+C\u0011Ba)\u0018\u0005\u0004%IA!*\t\u0011\tMv\u0003)A\u0005\u0005OC\u0011B!.\u0018\u0005\u0004%IAa.\t\u0011\t]w\u0003)A\u0005\u0005sC\u0011B!7\u0018\u0001\u0004%IAa7\t\u0013\t%x\u00031A\u0005\n\t-\b\u0002\u0003Bx/\u0001\u0006KA!8\t\u000f\tMt\u0003\"\u0001\u0003r\"9!\u0011P\f\u0005\u0002\tm\u0004b\u0002B{/\u0011%!1\u0010\u0005\b\u0005o<B\u0011\u0002B}\r\u0019\u0019)\u0003\u0001\u0003\u0004(!9\u0011q\u0001\u0015\u0005\u0002\r%\u0002\"\u0003B@Q\t\u0007I\u0011\u0002BA\u0011!\u0011y\t\u000bQ\u0001\n\t\r\u0005\"\u0003BIQ\t\u0007I\u0011\u0002BJ\u0011!\u0011\t\u000b\u000bQ\u0001\n\tU\u0005\"\u0003BRQ\t\u0007I\u0011\u0002BS\u0011!\u0011\u0019\f\u000bQ\u0001\n\t\u001d\u0006\"CB\u0016Q\t\u0007I\u0011BB\u0017\u0011!\u0019y\u0004\u000bQ\u0001\n\r=\u0002\"CB!Q\t\u0007I\u0011BB\"\u0011!\u0019Y\u0005\u000bQ\u0001\n\r\u0015\u0003\"CB'Q\t\u0007I\u0011BB(\u0011!\u00199\u0006\u000bQ\u0001\n\rE\u0003\"CB-Q\t\u0007I\u0011BB.\u0011!\u0019\u0019\u0007\u000bQ\u0001\n\ru\u0003\"CB3Q\t\u0007I\u0011BB4\u0011!\u0019y\u0007\u000bQ\u0001\n\r%\u0004\"CB9Q\t\u0007I\u0011BB:\u0011!\u0019Y\b\u000bQ\u0001\n\rU\u0004\"CB?Q\t\u0007I\u0011BB@\u0011!\u00199\t\u000bQ\u0001\n\r\u0005\u0005b\u0002B:Q\u0011\u00051\u0011\u0012\u0005\b\u0005sBC\u0011\u0001B>\u0011\u001d\u0019i\t\u000bC\u0005\u0005wBqaa$)\t\u0013\u0011Y\bC\u0004\u0004\u0012\"\"IAa\u001f\t\u000f\rM\u0005\u0006\"\u0003\u0004\u0016\"91q\u0014\u0015\u0005\n\tm\u0004bBBQQ\u0011%!1P\u0004\b\u0003_1\u0007\u0012AA\u0019\r\u0019)g\r#\u0001\u00024!9\u0011qA$\u0005\u0002\u0005UbABA\u001c\u000f\u0002\tI\u0004C\u0004\u0002\b%#\t!!\u0011\t\u000f\u0005\u001d\u0013\n\"\u0011\u0002J\u00191\u0011\u0011L$A\u0003;B!\"! M\u0005+\u0007I\u0011AA@\u0011)\ti\t\u0014B\tB\u0003%\u0011\u0011\u0011\u0005\u000b\u0003\u001fc%Q3A\u0005\u0002\u0005}\u0004BCAI\u0019\nE\t\u0015!\u0003\u0002\u0002\"9\u0011q\u0001'\u0005\u0002\u0005M\u0005\"CAN\u0019\u0006\u0005I\u0011AAO\u0011%\t\u0019\u000bTI\u0001\n\u0003\t)\u000bC\u0005\u0002<2\u000b\n\u0011\"\u0001\u0002&\"I\u0011Q\u0018'\u0002\u0002\u0013\u0005\u00131\u0003\u0005\n\u0003\u007fc\u0015\u0011!C\u0001\u0003\u0003D\u0011\"!3M\u0003\u0003%\t!a3\t\u0013\u0005]G*!A\u0005B\u0005e\u0007\"CAt\u0019\u0006\u0005I\u0011AAu\u0011%\t\u0019\u0010TA\u0001\n\u0003\n)\u0010C\u0005\u0002z2\u000b\t\u0011\"\u0011\u0002|\"I\u0011Q '\u0002\u0002\u0013\u0005\u0013q \u0005\n\u0005\u0003a\u0015\u0011!C!\u0005\u00079\u0011Ba\u0002H\u0003\u0003E\tA!\u0003\u0007\u0013\u0005es)!A\t\u0002\t-\u0001bBA\u0004?\u0012\u0005!1\u0005\u0005\n\u0003{|\u0016\u0011!C#\u0003\u007fD\u0011B!\n`\u0003\u0003%\tIa\n\t\u0013\t5r,!A\u0005\u0002\n=\u0002\"\u0003B!?\u0006\u0005I\u0011\u0002B\"\u0005QAun\u001d;NKR\u0014\u0018nY:D_2dWm\u0019;pe*\u0011q\r[\u0001\u0005Q>\u001cHO\u0003\u0002jU\u000611/_:uK6T!a\u001b7\u0002\u001f%t7\u000f\u001e:v[\u0016tG/\u0019;j_:T\u0011!\\\u0001\u0006W\u0006lwN\\\u0002\u0001'\r\u0001\u0001O\u001e\t\u0003cRl\u0011A\u001d\u0006\u0002g\u0006)1oY1mC&\u0011QO\u001d\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]TX\"\u0001=\u000b\u0005ed\u0017AB7pIVdW-\u0003\u0002|q\n1Qj\u001c3vY\u0016\f!!Z2\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\tA]\u0001\u000bG>t7-\u001e:sK:$\u0018bAA\u0003\u007f\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0005-\u0011q\u0002\t\u0004\u0003\u001b\u0001Q\"\u00014\t\u000bq\u0014\u0001\u0019A?\u0002\u0017}\u001bwN\u001c4jOB\u000bG\u000f[\u000b\u0003\u0003+\u0001B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"\u0001\u0003mC:<'BAA\u0010\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0012\u0011\u0004\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019}\u001bwN\u001c4jOB\u000bG\u000f\u001b\u0011\u0002\u0013}\u001bX\r\u001e;j]\u001e\u001cXCAA\u0016!\r\ti\u0003\u0014\b\u0004\u0003\u001b1\u0015\u0001\u0006%pgRlU\r\u001e:jGN\u001cu\u000e\u001c7fGR|'\u000fE\u0002\u0002\u000e\u001d\u001b\"a\u00129\u0015\u0005\u0005E\"a\u0002$bGR|'/_\n\u0005\u0013B\fY\u0004E\u0002x\u0003{I1!a\u0010y\u00055iu\u000eZ;mK\u001a\u000b7\r^8ssR\u0011\u00111\t\t\u0004\u0003\u000bJU\"A$\u0002\r\r\u0014X-\u0019;f)\r1\u00181\n\u0005\b\u0003\u001bZ\u0005\u0019AA(\u0003!\u0019X\r\u001e;j]\u001e\u001c\b\u0003BA)\u0003/r1a^A*\u0013\r\t)\u0006_\u0001\u000e\u001b>$W\u000f\\3GC\u000e$xN]=\n\t\u0005e\u00131\f\u0002\t'\u0016$H/\u001b8hg*\u0019\u0011Q\u000b=\u0014\r1\u0003\u0018qLA3!\r\t\u0018\u0011M\u0005\u0004\u0003G\u0012(a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003O\n9H\u0004\u0003\u0002j\u0005Md\u0002BA6\u0003cj!!!\u001c\u000b\u0007\u0005=d.\u0001\u0004=e>|GOP\u0005\u0002g&\u0019\u0011Q\u000f:\u0002\u000fA\f7m[1hK&!\u0011\u0011PA>\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t)H]\u0001\u0012iJ\f7m[3e\u0013:$XM\u001d4bG\u0016\u001cXCAAA!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAADY\u0006!Q\u000f^5m\u0013\u0011\tY)!\"\u0003\r\u0019KG\u000e^3s\u0003I!(/Y2lK\u0012Le\u000e^3sM\u0006\u001cWm\u001d\u0011\u0002\u001bQ\u0014\u0018mY6fI6{WO\u001c;t\u00039!(/Y2lK\u0012lu.\u001e8ug\u0002\"b!!&\u0002\u0018\u0006e\u0005cAA#\u0019\"9\u0011QP)A\u0002\u0005\u0005\u0005bBAH#\u0002\u0007\u0011\u0011Q\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002\u0016\u0006}\u0015\u0011\u0015\u0005\n\u0003{\u0012\u0006\u0013!a\u0001\u0003\u0003C\u0011\"a$S!\u0003\u0005\r!!!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0015\u0016\u0005\u0003\u0003\u000bIk\u000b\u0002\u0002,B!\u0011QVA\\\u001b\t\tyK\u0003\u0003\u00022\u0006M\u0016!C;oG\",7m[3e\u0015\r\t)L]\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA]\u0003_\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAAb!\r\t\u0018QY\u0005\u0004\u0003\u000f\u0014(aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAg\u0003'\u00042!]Ah\u0013\r\t\tN\u001d\u0002\u0004\u0003:L\b\"CAk/\u0006\u0005\t\u0019AAb\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u001c\t\u0007\u0003;\f\u0019/!4\u000e\u0005\u0005}'bAAqe\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u0018q\u001c\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002l\u0006E\bcA9\u0002n&\u0019\u0011q\u001e:\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q[-\u0002\u0002\u0003\u0007\u0011QZ\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0016\u0005]\b\"CAk5\u0006\u0005\t\u0019AAb\u0003!A\u0017m\u001d5D_\u0012,GCAAb\u0003!!xn\u0015;sS:<GCAA\u000b\u0003\u0019)\u0017/^1mgR!\u00111\u001eB\u0003\u0011%\t).XA\u0001\u0002\u0004\ti-\u0001\u0005TKR$\u0018N\\4t!\r\t)eX\n\u0006?\n5!\u0011\u0004\t\u000b\u0005\u001f\u0011)\"!!\u0002\u0002\u0006UUB\u0001B\t\u0015\r\u0011\u0019B]\u0001\beVtG/[7f\u0013\u0011\u00119B!\u0005\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0003\u001c\t\u0005RB\u0001B\u000f\u0015\u0011\u0011y\"!\b\u0002\u0005%|\u0017\u0002BA=\u0005;!\"A!\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005U%\u0011\u0006B\u0016\u0011\u001d\tiH\u0019a\u0001\u0003\u0003Cq!a$c\u0001\u0004\t\t)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tE\"Q\b\t\u0006c\nM\"qG\u0005\u0004\u0005k\u0011(AB(qi&|g\u000eE\u0004r\u0005s\t\t)!!\n\u0007\tm\"O\u0001\u0004UkBdWM\r\u0005\n\u0005\u007f\u0019\u0017\u0011!a\u0001\u0003+\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011)\u0005\u0005\u0003\u0002\u0018\t\u001d\u0013\u0002\u0002B%\u00033\u0011aa\u00142kK\u000e$\u0018!D0tKR$\u0018N\\4t?\u0012*\u0017\u000f\u0006\u0003\u0003P\tU\u0003cA9\u0003R%\u0019!1\u000b:\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003+4\u0011\u0011!a\u0001\u0003W\t!bX:fiRLgnZ:!Q\r9!1\f\t\u0004c\nu\u0013b\u0001B0e\nAao\u001c7bi&dW-\u0001\n`MJ,\u0017/^3oi\u000e{G\u000e\\3di>\u0014XC\u0001B3!\r\u00119gF\u0007\u0002\u0001\t1bI]3rk\u0016tGoQ8mY\u0016\u001cG/[8o)\u0006\u001c8n\u0005\u0003\u0018a\n5\u0004c\u0001B4)\tq1i\u001c7mK\u000e$\u0018n\u001c8UCN\\7C\u0001\u000bq\u0003!\u00198\r[3ek2,G\u0003\u0002B(\u0005oBQ\u0001`\u000bA\u0002u\fqa\u00197fC:,\b\u000f\u0006\u0002\u0003PQ\u0011!QM\u0001\r?\u0012,g-Y;miR\u000bwm]\u000b\u0003\u0005\u0007\u0003BA!\"\u0003\f6\u0011!q\u0011\u0006\u0004\u0005\u0013c\u0017a\u0001;bO&!!Q\u0012BD\u0005\u0019!\u0016mZ*fi\u0006iq\fZ3gCVdG\u000fV1hg\u0002\n1bX:zgR,W.\u00138g_V\u0011!Q\u0013\t\u0005\u0005/\u0013i*\u0004\u0002\u0003\u001a*\u0011!1T\u0001\u0005_ND\u0017.\u0003\u0003\u0003 \ne%AC*zgR,W.\u00138g_\u0006aql]=ti\u0016l\u0017J\u001c4pA\u0005!q\f[1m+\t\u00119\u000b\u0005\u0003\u0003*\n=VB\u0001BV\u0015\u0011\u0011iK!'\u0002\u0011!\f'\u000fZ<be\u0016LAA!-\u0003,\nA\u0002*\u0019:eo\u0006\u0014X-\u00112tiJ\f7\r^5p]2\u000b\u00170\u001a:\u0002\u000b}C\u0017\r\u001c\u0011\u0002\u001f}\u001b\u0007/^%ogR\u0014X/\\3oiN,\"A!/\u0011\t\tm&\u0011\u001b\b\u0005\u0005{\u0013iM\u0004\u0003\u0003@\n-g\u0002\u0002Ba\u0005\u0013tAAa1\u0003H:!\u00111\u000eBc\u0013\u0005i\u0017BA6m\u0013\tI'.\u0003\u0002hQ&\u0019!q\u001a4\u0002\u0017!{7\u000f^'fiJL7m]\u0005\u0005\u0005'\u0014)N\u0001\bDaVLen\u001d;sk6,g\u000e^:\u000b\u0007\t=g-\u0001\t`GB,\u0018J\\:ueVlWM\u001c;tA\u0005\tr\f\u001d:fm\u000e\u0003X\u000fT8bIRK7m[:\u0016\u0005\tu\u0007#B9\u0003`\n\r\u0018b\u0001Bqe\n)\u0011I\u001d:bsB\u0019\u0011O!:\n\u0007\t\u001d(O\u0001\u0003M_:<\u0017!F0qe\u001648\t];M_\u0006$G+[2lg~#S-\u001d\u000b\u0005\u0005\u001f\u0012i\u000fC\u0005\u0002V\n\n\t\u00111\u0001\u0003^\u0006\u0011r\f\u001d:fm\u000e\u0003X\u000fT8bIRK7m[:!)\u0011\u0011yEa=\t\u000bq$\u0003\u0019A?\u0002\u001dI,7m\u001c:e\u0007B,Xk]1hK\u0006IA/[2lg\u0012KgM\u001a\u000b\t\u0005G\u0014YPa@\u0004\u0004!9!Q`\u0014A\u0002\tu\u0017\u0001\u00039sKZLw.^:\t\u000f\r\u0005q\u00051\u0001\u0003^\u000691-\u001e:sK:$\bbBB\u0003O\u0001\u00071qA\u0001\ti&\u001c7\u000eV=qKB!1\u0011BB\f\u001d\u0011\u0019Yaa\u0005\u000f\t\r51\u0011\u0003\b\u0005\u0003W\u001ay!\u0003\u0002\u0003\u001c&!!Q\u0016BM\u0013\u0011\u0019)Ba+\u0002!\r+g\u000e\u001e:bYB\u0013xnY3tg>\u0014\u0018\u0002BB\r\u00077\u0011\u0001\u0002V5dWRK\b/\u001a\u0006\u0005\u0007+\u0011Y+A\n`MJ,\u0017/^3oi\u000e{G\u000e\\3di>\u0014\b%\u0001\u000b`S:4'/Z9vK:$8i\u001c7mK\u000e$xN]\u000b\u0003\u0007G\u00012Aa\u001a)\u0005aIeN\u001a:fcV,g\u000e^\"pY2,7\r^5p]R\u000b7o[\n\u0005QA\u0014i\u0007\u0006\u0002\u0004$\u0005\u0019ql\\:\u0016\u0005\r=\u0002\u0003BB\u0019\u0007wi!aa\r\u000b\t\rU2qG\u0001\u0003_NTAa!\u000f\u0003\u001a\u0006A1o\u001c4uo\u0006\u0014X-\u0003\u0003\u0004>\rM\"aD(qKJ\fG/\u001b8h'f\u001cH/Z7\u0002\t}{7\u000fI\u0001\u0013?6,Wn\u001c:z\u0013:\u001cHO];nK:$8/\u0006\u0002\u0004FA!!1XB$\u0013\u0011\u0019IE!6\u0003#5+Wn\u001c:z\u0013:\u001cHO];nK:$8/A\n`[\u0016lwN]=J]N$(/^7f]R\u001c\b%\u0001\t`g^\f\u0007/\u00138tiJ,X.\u001a8ugV\u00111\u0011\u000b\t\u0005\u0005w\u001b\u0019&\u0003\u0003\u0004V\tU'aD*xCBLen\u001d;sk6,g\u000e^:\u0002#}\u001bx/\u00199J]N$(/^7f]R\u001c\b%A\f`Y>\fG-\u0011<fe\u0006<W-\u00138tiJ,X.\u001a8ugV\u00111Q\f\t\u0005\u0005w\u001by&\u0003\u0003\u0004b\tU'A\u0006'pC\u0012\fe/\u001a:bO\u0016Len\u001d;sk6,g\u000e^:\u00021}cw.\u00193Bm\u0016\u0014\u0018mZ3J]N$(/^7f]R\u001c\b%A\u000e`M&dWmU=ti\u0016lWk]1hK&s7\u000f\u001e:v[\u0016tGo]\u000b\u0003\u0007S\u0002BAa/\u0004l%!1Q\u000eBk\u0005]\u0019Fo\u001c:bO\u0016lu.\u001e8u\u0013:\u001cHO];nK:$8/\u0001\u000f`M&dWmU=ti\u0016lWk]1hK&s7\u000f\u001e:v[\u0016tGo\u001d\u0011\u0002=}3\u0017\u000e\\3TsN$X-\\!di&4\u0018\u000e^=J]N$(/^7f]R\u001cXCAB;!\u0011\u0011Yla\u001e\n\t\re$Q\u001b\u0002\u0019'R|'/Y4f\t\u00164\u0018nY3J]N$(/^7f]R\u001c\u0018aH0gS2,7+_:uK6\f5\r^5wSRL\u0018J\\:ueVlWM\u001c;tA\u0005YrL\\3uo>\u00148.Q2uSZLG/_%ogR\u0014X/\\3oiN,\"a!!\u0011\t\tm61Q\u0005\u0005\u0007\u000b\u0013)N\u0001\u000eOKR<xN]6BGRLg/\u001b;z\u0013:\u001cHO];nK:$8/\u0001\u000f`]\u0016$xo\u001c:l\u0003\u000e$\u0018N^5us&s7\u000f\u001e:v[\u0016tGo\u001d\u0011\u0015\t\t=31\u0012\u0005\u0006yz\u0002\r!`\u0001\u0012e\u0016\u001cwN\u001d3NK6|'/_+tC\u001e,\u0017!\u0005:fG>\u0014H\rT8bI\u00063XM]1hK\u0006\u0011\"/Z2pe\u0012\u001cFo\u001c:bO\u0016,6/Y4f\u0003%!x\u000eU3sG\u0016tG\u000f\u0006\u0004\u0003d\u000e]51\u0014\u0005\b\u00073\u001b\u0005\u0019\u0001Br\u0003\u00151\u0018\r\\;f\u0011\u001d\u0019ij\u0011a\u0001\u0005G\fQ\u0001^8uC2\fQC]3d_J$7\u000b^8sC\u001e,\u0017i\u0019;jm&$\u00180A\u000bsK\u000e|'\u000f\u001a(fi^|'o[!di&4\u0018\u000e^=\u0002+}KgN\u001a:fcV,g\u000e^\"pY2,7\r^8sA\u0005YqLZ2TG\",G-\u001e7f+\t\u0019I\u000b\r\u0003\u0004,\u000em\u0006CBBW\u0007g\u001b9,\u0004\u0002\u00040*!\u0011\u0011ABY\u0015\u0011\t9)!\b\n\t\rU6q\u0016\u0002\u0010'\u000eDW\rZ;mK\u00124U\u000f^;sKB!1\u0011XB^\u0019\u0001!1b!0\u000e\u0003\u0003\u0005\tQ!\u0001\u0004B\n\u0011q\bM\u0001\r?\u001a\u001c7k\u00195fIVdW\rI\t\u0005\u0007\u0007\u001cI\rE\u0002r\u0007\u000bL1aa2s\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u0006\u0003H\u0005aq,\u001b4d'\u000eDW\rZ;mKV\u00111q\u001a\u0019\u0005\u0007#\u001c)\u000e\u0005\u0004\u0004.\u000eM61\u001b\t\u0005\u0007s\u001b)\u000eB\u0006\u0004>>\t\t\u0011!A\u0003\u0002\r\u0005\u0017!D0jM\u000e\u001c6\r[3ek2,\u0007%\u0001\u0003ti>\u0004\u0018a\u0003:fG>tg-[4ve\u0016$BAa\u0014\u0004`\"91\u0011]\tA\u0002\r\r\u0018!\u00038fo\u000e{gNZ5h!\u0011\u0019)oa=\u000e\u0005\r\u001d(\u0002BBu\u0007W\faaY8oM&<'\u0002BBw\u0007_\f\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0007c\f1aY8n\u0013\u0011\u0019)pa:\u0003\r\r{gNZ5h\u00031\u0011X-\u00193TKR$\u0018N\\4t)\u0011\tYca?\t\u000f\r%(\u00031\u0001\u0004d\u0006\u00112o\u00195fIVdWm\u00148N_\u0012,H.Z#D)\u0011!\t\u0001b\u0002\u0011\t\u0005]A1A\u0005\u0005\t\u000b\tIB\u0001\u0005Sk:t\u0017M\u00197f\u0011\u001d!Ia\u0005a\u0001\u0005[\nA\u0001^1tW\u0002")
public class HostMetricsCollector
implements Module {
    public final ExecutionContext kamon$instrumentation$system$host$HostMetricsCollector$$ec;
    private final String _configPath;
    private volatile Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings;
    private final FrequentCollectionTask _frequentCollector;
    private final InfrequentCollectionTask _infrequentCollector;
    private final ScheduledFuture<?> _fcSchedule;
    private final ScheduledFuture<?> _ifcSchedule;

    private String _configPath() {
        return this._configPath;
    }

    public Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings() {
        return this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings;
    }

    private void kamon$instrumentation$system$host$HostMetricsCollector$$_settings_$eq(Settings x$1) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings = x$1;
    }

    private FrequentCollectionTask _frequentCollector() {
        return this._frequentCollector;
    }

    private InfrequentCollectionTask _infrequentCollector() {
        return this._infrequentCollector;
    }

    private ScheduledFuture<?> _fcSchedule() {
        return this._fcSchedule;
    }

    private ScheduledFuture<?> _ifcSchedule() {
        return this._ifcSchedule;
    }

    public void stop() {
        this._fcSchedule().cancel(false);
        this._ifcSchedule().cancel(false);
        this._frequentCollector().cleanup();
        this._infrequentCollector().cleanup();
    }

    public void reconfigure(Config newConfig) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings_$eq(this.readSettings(newConfig));
    }

    private Settings readSettings(Config config) {
        Config hostConfig = config.getConfig(this._configPath());
        return new Settings(Filter$.MODULE$.from(hostConfig.getConfig("network.tracked-interfaces")), Filter$.MODULE$.from(hostConfig.getConfig("storage.tracked-mount-types")));
    }

    private Runnable scheduleOnModuleEC(CollectionTask task) {
        return new Runnable(this, task){
            private final /* synthetic */ HostMetricsCollector $outer;
            private final CollectionTask task$1;

            public void run() {
                this.task$1.schedule(this.$outer.kamon$instrumentation$system$host$HostMetricsCollector$$ec);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.task$1 = task$1;
            }
        };
    }

    public HostMetricsCollector(ExecutionContext ec) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$ec = ec;
        this._configPath = "kamon.instrumentation.system.host";
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings = this.readSettings(Kamon$.MODULE$.config());
        this._frequentCollector = new FrequentCollectionTask();
        this._infrequentCollector = new InfrequentCollectionTask();
        this._fcSchedule = Kamon$.MODULE$.scheduler().scheduleAtFixedRate(this.scheduleOnModuleEC(this._frequentCollector()), 1L, 1L, TimeUnit.SECONDS);
        this._ifcSchedule = Kamon$.MODULE$.scheduler().scheduleAtFixedRate(this.scheduleOnModuleEC(this._infrequentCollector()), 1L, 10L, TimeUnit.SECONDS);
    }

    public interface CollectionTask {
        public void schedule(ExecutionContext var1);

        public void cleanup();
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new HostMetricsCollector(settings.executionContext());
        }
    }

    public class FrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final HostMetrics.CpuInstruments _cpuInstruments;
        private long[] _prevCpuLoadTicks;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private HostMetrics.CpuInstruments _cpuInstruments() {
            return this._cpuInstruments;
        }

        private long[] _prevCpuLoadTicks() {
            return this._prevCpuLoadTicks;
        }

        private void _prevCpuLoadTicks_$eq(long[] x$1) {
            this._prevCpuLoadTicks = x$1;
        }

        @Override
        public void schedule(ExecutionContext ec) {
            Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.recordCpuUsage(), ec);
        }

        @Override
        public void cleanup() {
            this._cpuInstruments().remove();
        }

        private void recordCpuUsage() {
            if (this._prevCpuLoadTicks().length > 0) {
                long[] previousTicks = this._prevCpuLoadTicks();
                long[] currentTicks = this._hal().getProcessor().getSystemCpuLoadTicks();
                long user = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.USER);
                long nice = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.NICE);
                long system = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SYSTEM);
                long idle = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IDLE);
                long iowait = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IOWAIT);
                long irq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IRQ);
                long softirq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SOFTIRQ);
                long steal = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.STEAL);
                long total = user + nice + system + idle + iowait + irq + softirq + steal;
                this._cpuInstruments().user().record(FrequentCollectionTask.toPercent$1(user, total));
                this._cpuInstruments().system().record(FrequentCollectionTask.toPercent$1(system, total));
                this._cpuInstruments().iowait().record(FrequentCollectionTask.toPercent$1(iowait, total));
                this._cpuInstruments().idle().record(FrequentCollectionTask.toPercent$1(idle, total));
                this._cpuInstruments().stolen().record(FrequentCollectionTask.toPercent$1(steal, total));
                this._cpuInstruments().combined().record(FrequentCollectionTask.toPercent$1(user + system + nice + iowait, total));
                this._prevCpuLoadTicks_$eq(currentTicks);
            } else {
                this._prevCpuLoadTicks_$eq(this._hal().getProcessor().getSystemCpuLoadTicks());
            }
        }

        private long ticksDiff(long[] previous, long[] current, CentralProcessor.TickType tickType) {
            return package$.MODULE$.max(current[tickType.getIndex()] - previous[tickType.getIndex()], 0L);
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        private static final long toPercent$1(long value, long total$1) {
            return (long)(100.0 * (double)value / (double)total$1);
        }

        public FrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._cpuInstruments = new HostMetrics.CpuInstruments(this._defaultTags());
            this._prevCpuLoadTicks = (long[])Array$.MODULE$.ofDim(0, (ClassTag)ClassTag$.MODULE$.Long());
        }
    }

    public class InfrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final OperatingSystem _os;
        private final HostMetrics.MemoryInstruments _memoryInstruments;
        private final HostMetrics.SwapInstruments _swapInstruments;
        private final HostMetrics.LoadAverageInstruments _loadAverageInstruments;
        private final HostMetrics.StorageMountInstruments _fileSystemUsageInstruments;
        private final HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments;
        private final HostMetrics.NetworkActivityInstruments _networkActivityInstruments;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private OperatingSystem _os() {
            return this._os;
        }

        private HostMetrics.MemoryInstruments _memoryInstruments() {
            return this._memoryInstruments;
        }

        private HostMetrics.SwapInstruments _swapInstruments() {
            return this._swapInstruments;
        }

        private HostMetrics.LoadAverageInstruments _loadAverageInstruments() {
            return this._loadAverageInstruments;
        }

        private HostMetrics.StorageMountInstruments _fileSystemUsageInstruments() {
            return this._fileSystemUsageInstruments;
        }

        private HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments() {
            return this._fileSystemActivityInstruments;
        }

        private HostMetrics.NetworkActivityInstruments _networkActivityInstruments() {
            return this._networkActivityInstruments;
        }

        @Override
        public void schedule(ExecutionContext ec) {
            Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.recordMemoryUsage();
                this.recordLoadAverage();
                this.recordStorageUsage();
                this.recordStorageActivity();
                this.recordNetworkActivity();
            }, ec);
        }

        @Override
        public void cleanup() {
            this._memoryInstruments().remove();
            this._swapInstruments().remove();
            this._loadAverageInstruments().remove();
            this._fileSystemUsageInstruments().remove();
            this._fileSystemActivityInstruments().remove();
            this._networkActivityInstruments().remove();
        }

        private void recordMemoryUsage() {
            GlobalMemory memory = this._hal().getMemory();
            long totalMemory = memory.getTotal();
            long availableMemory = memory.getAvailable();
            long usedMemory = totalMemory - availableMemory;
            this._memoryInstruments().total().update((double)totalMemory);
            this._memoryInstruments().free().update((double)availableMemory);
            this._memoryInstruments().used().update((double)usedMemory);
            this._memoryInstruments().usage().update((double)this.toPercent(usedMemory, totalMemory));
            long usedSwap = memory.getVirtualMemory().getSwapUsed();
            long totalSwap = memory.getVirtualMemory().getSwapTotal();
            this._swapInstruments().total().update((double)totalSwap);
            this._swapInstruments().used().update((double)usedSwap);
            this._swapInstruments().usage().update((double)this.toPercent(usedSwap, totalSwap));
            this._swapInstruments().free().update((double)(totalSwap - usedSwap));
        }

        private void recordLoadAverage() {
            block0: {
                double[] loadAverage = this._hal().getProcessor().getSystemLoadAverage(3);
                Object object = loadAverage[0] >= 0.0 ? this._loadAverageInstruments().oneMinute().update(loadAverage[0]) : BoxedUnit.UNIT;
                Object object2 = loadAverage[1] >= 0.0 ? this._loadAverageInstruments().fiveMinutes().update(loadAverage[1]) : BoxedUnit.UNIT;
                if (!(loadAverage[2] >= 0.0)) break block0;
                this._loadAverageInstruments().fifteenMinutes().update(loadAverage[2]);
            }
        }

        private void recordStorageUsage() {
            List fileStores = this._os().getFileSystem().getFileStores();
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(fileStores).asScala()).foreach((Function1 & Serializable)fs -> {
                BoxedUnit boxedUnit;
                if (this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedMounts().accept(fs.getType())) {
                    HostMetrics.StorageMountInstruments.MountInstruments mountInstruments = this._fileSystemUsageInstruments().mountInstruments(fs.getMount());
                    long totalSpace = fs.getTotalSpace();
                    long usedSpace = totalSpace - fs.getUsableSpace();
                    mountInstruments.free().update((double)fs.getUsableSpace());
                    mountInstruments.total().update((double)totalSpace);
                    mountInstruments.used().update((double)usedSpace);
                    boxedUnit = mountInstruments.usage().update((double)this.toPercent(usedSpace, totalSpace));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        }

        private long toPercent(long value, long total) {
            return (long)(100.0 * (double)value / (double)total);
        }

        private void recordStorageActivity() {
            List devices = this._hal().getDiskStores();
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(devices).asScala()).foreach((Function1 & Serializable)device -> {
                InfrequentCollectionTask.$anonfun$recordStorageActivity$1(this, device);
                return BoxedUnit.UNIT;
            });
        }

        private void recordNetworkActivity() {
            List interfaces = this._hal().getNetworkIFs();
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(interfaces).asScala()).foreach((Function1 & Serializable)networkIF -> {
                InfrequentCollectionTask.$anonfun$recordNetworkActivity$1(this, networkIF);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        public static final /* synthetic */ void $anonfun$recordStorageActivity$1(InfrequentCollectionTask $this, HWDiskStore device) {
            block0: {
                if (device.getPartitions().isEmpty()) break block0;
                HostMetrics.StorageDeviceInstruments.DeviceInstruments deviceInstruments = $this._fileSystemActivityInstruments().deviceInstruments(device.getName());
                deviceInstruments.reads().diff(device.getReads());
                deviceInstruments.writes().diff(device.getWrites());
                deviceInstruments.readBytes().diff(device.getReadBytes());
                deviceInstruments.writeBytes().diff(device.getWriteBytes());
            }
        }

        public static final /* synthetic */ void $anonfun$recordNetworkActivity$1(InfrequentCollectionTask $this, NetworkIF networkIF) {
            block0: {
                if (!$this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedInterfaces().accept(networkIF.getName())) break block0;
                HostMetrics.NetworkActivityInstruments.InterfaceInstruments interfaceInstruments = $this._networkActivityInstruments().interfaceInstruments(networkIF.getName());
                interfaceInstruments.receivedBytes().diff(networkIF.getBytesRecv());
                interfaceInstruments.sentBytes().diff(networkIF.getBytesSent());
                interfaceInstruments.sentPackets().diff(networkIF.getPacketsSent());
                interfaceInstruments.receivedPackets().diff(networkIF.getPacketsRecv());
                interfaceInstruments.sendErrorPackets().diff(networkIF.getOutErrors());
                interfaceInstruments.receiveErrorPackets().diff(networkIF.getInErrors());
            }
        }

        public InfrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._os = this._systemInfo().getOperatingSystem();
            this._memoryInstruments = new HostMetrics.MemoryInstruments(this._defaultTags());
            this._swapInstruments = new HostMetrics.SwapInstruments(this._defaultTags());
            this._loadAverageInstruments = new HostMetrics.LoadAverageInstruments(this._defaultTags());
            this._fileSystemUsageInstruments = new HostMetrics.StorageMountInstruments(this._defaultTags());
            this._fileSystemActivityInstruments = new HostMetrics.StorageDeviceInstruments(this._defaultTags());
            this._networkActivityInstruments = new HostMetrics.NetworkActivityInstruments(this._defaultTags());
        }
    }

    public static class Settings
    implements Product,
    Serializable {
        private final Filter trackedInterfaces;
        private final Filter trackedMounts;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Filter trackedInterfaces() {
            return this.trackedInterfaces;
        }

        public Filter trackedMounts() {
            return this.trackedMounts;
        }

        public Settings copy(Filter trackedInterfaces, Filter trackedMounts) {
            return new Settings(trackedInterfaces, trackedMounts);
        }

        public Filter copy$default$1() {
            return this.trackedInterfaces();
        }

        public Filter copy$default$2() {
            return this.trackedMounts();
        }

        public String productPrefix() {
            return "Settings";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.trackedInterfaces();
                    break;
                }
                case 1: {
                    object = this.trackedMounts();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Settings;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "trackedInterfaces";
                    break;
                }
                case 1: {
                    string = "trackedMounts";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Settings)) return false;
            boolean bl = true;
            if (!bl) return false;
            Settings settings = (Settings)x$1;
            Filter filter = this.trackedInterfaces();
            Filter filter2 = settings.trackedInterfaces();
            if (filter == null) {
                if (filter2 != null) {
                    return false;
                }
            } else if (!filter.equals(filter2)) return false;
            Filter filter3 = this.trackedMounts();
            Filter filter4 = settings.trackedMounts();
            if (filter3 == null) {
                if (filter4 != null) {
                    return false;
                }
            } else if (!filter3.equals(filter4)) return false;
            if (!settings.canEqual(this)) return false;
            return true;
        }

        public Settings(Filter trackedInterfaces, Filter trackedMounts) {
            this.trackedInterfaces = trackedInterfaces;
            this.trackedMounts = trackedMounts;
            Product.$init$((Product)this);
        }
    }
}

