/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.jdbc;

import java.sql.Connection;
import kamon.instrumentation.jdbc.ConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.HasConnectionPoolTelemetry;
import kanela.agent.libs.net.bytebuddy.asm.Advice;

public final class HikariPoolGetConnectionAdvice$ {
    public static HikariPoolGetConnectionAdvice$ MODULE$;

    static {
        new HikariPoolGetConnectionAdvice$();
    }

    @Advice.OnMethodEnter
    public long executeStart() {
        return System.nanoTime();
    }

    @Advice.OnMethodExit(onThrowable=Exception.class)
    public void executeEnd(@Advice.Enter long startTime, @Advice.Return Connection connection, @Advice.This HasConnectionPoolTelemetry pool, @Advice.Thrown Throwable throwable) {
        long borrowTime = System.nanoTime() - startTime;
        ConnectionPoolTelemetry poolMetrics = pool.connectionPoolTelemetry().get();
        poolMetrics.instruments().borrowTime().record(borrowTime);
        if (throwable == null && connection != null) {
            poolMetrics.instruments().borrowedConnections().increment();
            ((HasConnectionPoolTelemetry)((Object)connection)).setConnectionPoolTelemetry(pool.connectionPoolTelemetry());
        }
    }

    private HikariPoolGetConnectionAdvice$() {
        MODULE$ = this;
    }
}

