/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.http;

import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import kamon.Kamon;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.akka.http.AkkaHttpClientInstrumentation;
import kamon.instrumentation.akka.http.AkkaHttpInstrumentation;
import kamon.instrumentation.http.HttpClientInstrumentation;
import kamon.instrumentation.http.HttpMessage;
import kamon.trace.Span;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import scala.concurrent.Future;

public class PoolMasterDispatchRequestAdvice {
    @Advice.OnMethodEnter
    public static void onEnter(@Advice.Argument(value=1, readOnly=false) HttpRequest httpRequest, @Advice.Local(value="handler") HttpClientInstrumentation.RequestHandler<HttpRequest> requestHandler, @Advice.Local(value="scope") Storage.Scope scope) {
        HttpMessage.RequestBuilder<HttpRequest> requestBuilder = AkkaHttpInstrumentation.toRequestBuilder(httpRequest);
        requestHandler = AkkaHttpClientInstrumentation.httpClientInstrumentation().createHandler(requestBuilder, Kamon.currentContext());
        httpRequest = requestHandler.request();
        scope = Kamon.storeContext((Context)Kamon.currentContext().withEntry(Span.Key(), (Object)requestHandler.span()));
    }

    @Advice.OnMethodExit
    public static void onExit(@Advice.Return Future<HttpResponse> future, @Advice.Local(value="handler") HttpClientInstrumentation.RequestHandler<HttpRequest> requestHandler, @Advice.Local(value="scope") Storage.Scope scope) {
        AkkaHttpClientInstrumentation.handleResponse(future, requestHandler);
        scope.close();
    }
}

