/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.http;

import akka.NotUsed;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.FlowOps;
import kamon.instrumentation.akka.http.ServerFlowWrapper;
import kanela.agent.libs.net.bytebuddy.asm.Advice;

public class FlowOpsMapAsyncAdvice {
    public static ThreadLocal<EndpointInfo> currentEndpoint = new ThreadLocal();

    @Advice.OnMethodExit
    public static void onExit(@Advice.Return(readOnly=false) FlowOps flow) {
        EndpointInfo endpointInfo = currentEndpoint.get();
        if (endpointInfo != null) {
            flow = ServerFlowWrapper.apply((Flow<HttpRequest, HttpResponse, NotUsed>)((Flow)flow), endpointInfo.listenInterface, endpointInfo.listenPort);
        }
    }

    public static class EndpointInfo {
        public final String listenInterface;
        public final int listenPort;

        public EndpointInfo(String string, int n) {
            this.listenInterface = string;
            this.listenPort = n;
        }
    }
}

