/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.host;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kamon.Kamon$;
import kamon.instrumentation.system.host.HostMetrics;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kamon.util.Filter;
import kamon.util.Filter$;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.OperatingSystem;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r-h\u0001\u00023f\u00019D\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\u0002\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\n\u0011%\t)\u0003\u0001a\u0001\n\u0013\t9\u0003C\u0005\u0003(\u0001\u0001\r\u0011\"\u0003\u0003*!A!1\u0007\u0001!B\u0013\tI\u0003C\u0005\u0003>\u0001\u0011\r\u0011\"\u0003\u0003@!A!q \u0001!\u0002\u0013\u0011\t\u0005C\u0005\u0004\u0002\u0001\u0011\r\u0011\"\u0003\u0004\u0004!A1Q\u0011\u0001!\u0002\u0013\u0019)\u0001C\u0005\u0004\b\u0002\u0011\r\u0011\"\u0003\u0004\n\"A1\u0011\u0015\u0001!\u0002\u0013\u0019Y\tC\u0005\u0004,\u0002\u0011\r\u0011\"\u0003\u0004.\"A1q\u0017\u0001!\u0002\u0013\u0019y\u000bC\u0004\u0004:\u0002!\tEa\u0016\t\u000f\rm\u0006\u0001\"\u0011\u0004>\"91q\u001b\u0001\u0005\n\re\u0007bBBo\u0001\u0011%1q\u001c\u0004\n\u0005\u0017\u0002\u0001\u0013aI\u0001\u0005\u001bBqAa\u0014\u0015\r\u0003\u0011\t\u0006C\u0004\u0003VQ1\tAa\u0016\u0007\r\t\u0015\u0003\u0001\u0002B$\u0011\u001d\t)a\u0006C\u0001\u00053B\u0011Ba\u0017\u0018\u0005\u0004%IA!\u0018\t\u0011\t-t\u0003)A\u0005\u0005?B\u0011B!\u001c\u0018\u0005\u0004%IAa\u001c\t\u0011\tut\u0003)A\u0005\u0005cB\u0011Ba \u0018\u0005\u0004%IA!!\t\u0011\t=u\u0003)A\u0005\u0005\u0007C\u0011B!%\u0018\u0005\u0004%IAa%\t\u0011\tev\u0003)A\u0005\u0005+C\u0011Ba/\u0018\u0001\u0004%IA!0\t\u0013\t-w\u00031A\u0005\n\t5\u0007\u0002\u0003Bi/\u0001\u0006KAa0\t\u000f\t=s\u0003\"\u0001\u0003T\"9!QK\f\u0005\u0002\t]\u0003b\u0002Bl/\u0011%!q\u000b\u0005\b\u00053<B\u0011\u0002Bn\r\u0019\u00199\u0001\u0001\u0003\u0004\n!9\u0011Q\u0001\u0015\u0005\u0002\r-\u0001\"\u0003B.Q\t\u0007I\u0011\u0002B/\u0011!\u0011Y\u0007\u000bQ\u0001\n\t}\u0003\"\u0003B7Q\t\u0007I\u0011\u0002B8\u0011!\u0011i\b\u000bQ\u0001\n\tE\u0004\"\u0003B@Q\t\u0007I\u0011\u0002BA\u0011!\u0011y\t\u000bQ\u0001\n\t\r\u0005\"CB\u0007Q\t\u0007I\u0011BB\b\u0011!\u0019\t\u0003\u000bQ\u0001\n\rE\u0001\"CB\u0012Q\t\u0007I\u0011BB\u0013\u0011!\u0019i\u0003\u000bQ\u0001\n\r\u001d\u0002\"CB\u0018Q\t\u0007I\u0011BB\u0019\u0011!\u0019I\u0004\u000bQ\u0001\n\rM\u0002\"CB\u001eQ\t\u0007I\u0011BB\u001f\u0011!\u0019)\u0005\u000bQ\u0001\n\r}\u0002\"CB$Q\t\u0007I\u0011BB%\u0011!\u0019\t\u0006\u000bQ\u0001\n\r-\u0003\"CB*Q\t\u0007I\u0011BB+\u0011!\u0019i\u0006\u000bQ\u0001\n\r]\u0003\"CB0Q\t\u0007I\u0011BB1\u0011!\u0019I\u0007\u000bQ\u0001\n\r\r\u0004b\u0002B(Q\u0011\u000511\u000e\u0005\b\u0005+BC\u0011\u0001B,\u0011\u001d\u0019y\u0007\u000bC\u0005\u0005/Bqa!\u001d)\t\u0013\u00119\u0006C\u0004\u0004t!\"IAa\u0016\t\u000f\rU\u0004\u0006\"\u0003\u0004x!91\u0011\u0011\u0015\u0005\n\t]\u0003bBBBQ\u0011%!qK\u0004\b\u0003[)\u0007\u0012AA\u0018\r\u0019!W\r#\u0001\u00022!9\u0011QA$\u0005\u0002\u0005MbABA\u001b\u000f\u0002\t9\u0004C\u0004\u0002\u0006%#\t!a\u0010\t\u000f\u0005\u0015\u0013\n\"\u0011\u0002H\u00191\u0011qK$A\u00037B!\"!\u001bM\u0005+\u0007I\u0011AA6\u0011)\tI\b\u0014B\tB\u0003%\u0011Q\u000e\u0005\u000b\u0003wb%Q3A\u0005\u0002\u0005-\u0004BCA?\u0019\nE\t\u0015!\u0003\u0002n!9\u0011Q\u0001'\u0005\u0002\u0005}\u0004\"CAD\u0019\u0006\u0005I\u0011AAE\u0011%\ty\tTI\u0001\n\u0003\t\t\nC\u0005\u0002(2\u000b\n\u0011\"\u0001\u0002\u0012\"I\u0011\u0011\u0016'\u0002\u0002\u0013\u0005\u0013\u0011\u0003\u0005\n\u0003Wc\u0015\u0011!C\u0001\u0003[C\u0011\"!.M\u0003\u0003%\t!a.\t\u0013\u0005\rG*!A\u0005B\u0005\u0015\u0007\"CAj\u0019\u0006\u0005I\u0011AAk\u0011%\ty\u000eTA\u0001\n\u0003\n\t\u000fC\u0005\u0002d2\u000b\t\u0011\"\u0011\u0002f\"I\u0011q\u001d'\u0002\u0002\u0013\u0005\u0013\u0011^\u0004\n\u0003[<\u0015\u0011!E\u0001\u0003_4\u0011\"a\u0016H\u0003\u0003E\t!!=\t\u000f\u0005\u0015a\f\"\u0001\u0002\u0000\"I\u00111\u001d0\u0002\u0002\u0013\u0015\u0013Q\u001d\u0005\n\u0005\u0003q\u0016\u0011!CA\u0005\u0007A\u0011B!\u0003_\u0003\u0003%\tIa\u0003\t\u0013\tua,!A\u0005\n\t}!\u0001\u0006%pgRlU\r\u001e:jGN\u001cu\u000e\u001c7fGR|'O\u0003\u0002gO\u0006!\u0001n\\:u\u0015\tA\u0017.\u0001\u0004tsN$X-\u001c\u0006\u0003U.\fq\"\u001b8tiJ,X.\u001a8uCRLwN\u001c\u0006\u0002Y\u0006)1.Y7p]\u000e\u00011c\u0001\u0001pkB\u0011\u0001o]\u0007\u0002c*\t!/A\u0003tG\u0006d\u0017-\u0003\u0002uc\n1\u0011I\\=SK\u001a\u0004\"A^=\u000e\u0003]T!\u0001_6\u0002\r5|G-\u001e7f\u0013\tQxO\u0001\u0004N_\u0012,H.Z\u0001\u0003K\u000e\u00042!`A\u0001\u001b\u0005q(BA@r\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0004\u0003\u0007q(\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q!\u0011\u0011BA\u0007!\r\tY\u0001A\u0007\u0002K\")1P\u0001a\u0001y\u0006YqlY8oM&<\u0007+\u0019;i+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\t1\fgn\u001a\u0006\u0003\u0003;\tAA[1wC&!\u0011\u0011EA\f\u0005\u0019\u0019FO]5oO\u0006aqlY8oM&<\u0007+\u0019;iA\u0005Iql]3ui&twm]\u000b\u0003\u0003S\u00012!a\u000bM\u001d\r\tYAR\u0001\u0015\u0011>\u001cH/T3ue&\u001c7oQ8mY\u0016\u001cGo\u001c:\u0011\u0007\u0005-qi\u0005\u0002H_R\u0011\u0011q\u0006\u0002\b\r\u0006\u001cGo\u001c:z'\u0011Iu.!\u000f\u0011\u0007Y\fY$C\u0002\u0002>]\u0014Q\"T8ek2,g)Y2u_JLHCAA!!\r\t\u0019%S\u0007\u0002\u000f\u000611M]3bi\u0016$2!^A%\u0011\u001d\tYe\u0013a\u0001\u0003\u001b\n\u0001b]3ui&twm\u001d\t\u0005\u0003\u001f\n)FD\u0002w\u0003#J1!a\u0015x\u00035iu\u000eZ;mK\u001a\u000b7\r^8ss&!\u0011qKA-\u0005!\u0019V\r\u001e;j]\u001e\u001c(bAA*oN1Aj\\A/\u0003G\u00022\u0001]A0\u0013\r\t\t'\u001d\u0002\b!J|G-^2u!\r\u0001\u0018QM\u0005\u0004\u0003O\n(\u0001D*fe&\fG.\u001b>bE2,\u0017!\u0005;sC\u000e\\W\rZ%oi\u0016\u0014h-Y2fgV\u0011\u0011Q\u000e\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111O6\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003o\n\tH\u0001\u0004GS2$XM]\u0001\u0013iJ\f7m[3e\u0013:$XM\u001d4bG\u0016\u001c\b%A\u0007ue\u0006\u001c7.\u001a3N_VtGo]\u0001\u000fiJ\f7m[3e\u001b>,h\u000e^:!)\u0019\t\t)a!\u0002\u0006B\u0019\u00111\t'\t\u000f\u0005%\u0014\u000b1\u0001\u0002n!9\u00111P)A\u0002\u00055\u0014\u0001B2paf$b!!!\u0002\f\u00065\u0005\"CA5%B\u0005\t\u0019AA7\u0011%\tYH\u0015I\u0001\u0002\u0004\ti'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M%\u0006BA7\u0003+[#!a&\u0011\t\u0005e\u00151U\u0007\u0003\u00037SA!!(\u0002 \u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003C\u000b\u0018AC1o]>$\u0018\r^5p]&!\u0011QUAN\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0016\t\u0004a\u0006E\u0016bAAZc\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011XA`!\r\u0001\u00181X\u0005\u0004\u0003{\u000b(aA!os\"I\u0011\u0011Y,\u0002\u0002\u0003\u0007\u0011qV\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0007CBAe\u0003\u001f\fI,\u0004\u0002\u0002L*\u0019\u0011QZ9\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002R\u0006-'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a6\u0002^B\u0019\u0001/!7\n\u0007\u0005m\u0017OA\u0004C_>dW-\u00198\t\u0013\u0005\u0005\u0017,!AA\u0002\u0005e\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005=\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002X\u0006-\b\"CAa9\u0006\u0005\t\u0019AA]\u0003!\u0019V\r\u001e;j]\u001e\u001c\bcAA\"=N)a,a=\u0002dAQ\u0011Q_A~\u0003[\ni'!!\u000e\u0005\u0005](bAA}c\u00069!/\u001e8uS6,\u0017\u0002BA\u007f\u0003o\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\ty/A\u0003baBd\u0017\u0010\u0006\u0004\u0002\u0002\n\u0015!q\u0001\u0005\b\u0003S\n\u0007\u0019AA7\u0011\u001d\tY(\u0019a\u0001\u0003[\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u000e\te\u0001#\u00029\u0003\u0010\tM\u0011b\u0001B\tc\n1q\n\u001d;j_:\u0004r\u0001\u001dB\u000b\u0003[\ni'C\u0002\u0003\u0018E\u0014a\u0001V;qY\u0016\u0014\u0004\"\u0003B\u000eE\u0006\u0005\t\u0019AAA\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\"A!\u0011Q\u0003B\u0012\u0013\u0011\u0011)#a\u0006\u0003\r=\u0013'.Z2u\u00035y6/\u001a;uS:<7o\u0018\u0013fcR!!1\u0006B\u0019!\r\u0001(QF\u0005\u0004\u0005_\t(\u0001B+oSRD\u0011\"!1\u0007\u0003\u0003\u0005\r!!\u000b\u0002\u0015}\u001bX\r\u001e;j]\u001e\u001c\b\u0005K\u0002\b\u0005o\u00012\u0001\u001dB\u001d\u0013\r\u0011Y$\u001d\u0002\tm>d\u0017\r^5mK\u0006\u0011rL\u001a:fcV,g\u000e^\"pY2,7\r^8s+\t\u0011\t\u0005E\u0002\u0003D]i\u0011\u0001\u0001\u0002\u0017\rJ,\u0017/^3oi\u000e{G\u000e\\3di&|g\u000eV1tWN!qc\u001cB%!\r\u0011\u0019\u0005\u0006\u0002\u000f\u0007>dG.Z2uS>tG+Y:l'\t!r.\u0001\u0005tG\",G-\u001e7f)\u0011\u0011YCa\u0015\t\u000bm,\u0002\u0019\u0001?\u0002\u000f\rdW-\u00198vaR\u0011!1\u0006\u000b\u0003\u0005\u0003\nAb\u00183fM\u0006,H\u000e\u001e+bON,\"Aa\u0018\u0011\t\t\u0005$qM\u0007\u0003\u0005GR1A!\u001al\u0003\r!\u0018mZ\u0005\u0005\u0005S\u0012\u0019G\u0001\u0004UC\u001e\u001cV\r^\u0001\u000e?\u0012,g-Y;miR\u000bwm\u001d\u0011\u0002\u0017}\u001b\u0018p\u001d;f[&sgm\\\u000b\u0003\u0005c\u0002BAa\u001d\u0003z5\u0011!Q\u000f\u0006\u0003\u0005o\nAa\\:iS&!!1\u0010B;\u0005)\u0019\u0016p\u001d;f[&sgm\\\u0001\r?NL8\u000f^3n\u0013:4w\u000eI\u0001\u0005?\"\fG.\u0006\u0002\u0003\u0004B!!Q\u0011BF\u001b\t\u00119I\u0003\u0003\u0003\n\nU\u0014\u0001\u00035be\u0012<\u0018M]3\n\t\t5%q\u0011\u0002\u0019\u0011\u0006\u0014Hm^1sK\u0006\u00137\u000f\u001e:bGRLwN\u001c'bs\u0016\u0014\u0018!B0iC2\u0004\u0013aD0daVLen\u001d;sk6,g\u000e^:\u0016\u0005\tU\u0005\u0003\u0002BL\u0005gsAA!'\u00030:!!1\u0014BW\u001d\u0011\u0011iJa+\u000f\t\t}%\u0011\u0016\b\u0005\u0005C\u00139+\u0004\u0002\u0003$*\u0019!QU7\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0017B\u00016l\u0013\tA\u0017.\u0003\u0002gO&\u0019!\u0011W3\u0002\u0017!{7\u000f^'fiJL7m]\u0005\u0005\u0005k\u00139L\u0001\bDaVLen\u001d;sk6,g\u000e^:\u000b\u0007\tEV-\u0001\t`GB,\u0018J\\:ueVlWM\u001c;tA\u0005\tr\f\u001d:fm\u000e\u0003X\u000fT8bIRK7m[:\u0016\u0005\t}\u0006#\u00029\u0003B\n\u0015\u0017b\u0001Bbc\n)\u0011I\u001d:bsB\u0019\u0001Oa2\n\u0007\t%\u0017O\u0001\u0003M_:<\u0017!F0qe\u001648\t];M_\u0006$G+[2lg~#S-\u001d\u000b\u0005\u0005W\u0011y\rC\u0005\u0002B\n\n\t\u00111\u0001\u0003@\u0006\u0011r\f\u001d:fm\u000e\u0003X\u000fT8bIRK7m[:!)\u0011\u0011YC!6\t\u000bm$\u0003\u0019\u0001?\u0002\u001dI,7m\u001c:e\u0007B,Xk]1hK\u0006IA/[2lg\u0012KgM\u001a\u000b\t\u0005\u000b\u0014iN!9\u0003f\"9!q\\\u0014A\u0002\t}\u0016\u0001\u00039sKZLw.^:\t\u000f\t\rx\u00051\u0001\u0003@\u000691-\u001e:sK:$\bb\u0002BtO\u0001\u0007!\u0011^\u0001\ti&\u001c7\u000eV=qKB!!1\u001eB}\u001d\u0011\u0011iO!>\u000f\t\t=(1\u001f\b\u0005\u0005C\u0013\t0\u0003\u0002\u0003x%!!\u0011\u0012B;\u0013\u0011\u00119Pa\"\u0002!\r+g\u000e\u001e:bYB\u0013xnY3tg>\u0014\u0018\u0002\u0002B~\u0005{\u0014\u0001\u0002V5dWRK\b/\u001a\u0006\u0005\u0005o\u00149)A\n`MJ,\u0017/^3oi\u000e{G\u000e\\3di>\u0014\b%\u0001\u000b`S:4'/Z9vK:$8i\u001c7mK\u000e$xN]\u000b\u0003\u0007\u000b\u00012Aa\u0011)\u0005aIeN\u001a:fcV,g\u000e^\"pY2,7\r^5p]R\u000b7o[\n\u0005Q=\u0014I\u0005\u0006\u0002\u0004\u0006\u0005\u0019ql\\:\u0016\u0005\rE\u0001\u0003BB\n\u0007;i!a!\u0006\u000b\t\r]1\u0011D\u0001\u0003_NTAaa\u0007\u0003v\u0005A1o\u001c4uo\u0006\u0014X-\u0003\u0003\u0004 \rU!aD(qKJ\fG/\u001b8h'f\u001cH/Z7\u0002\t}{7\u000fI\u0001\u0013?6,Wn\u001c:z\u0013:\u001cHO];nK:$8/\u0006\u0002\u0004(A!!qSB\u0015\u0013\u0011\u0019YCa.\u0003#5+Wn\u001c:z\u0013:\u001cHO];nK:$8/A\n`[\u0016lwN]=J]N$(/^7f]R\u001c\b%\u0001\t`g^\f\u0007/\u00138tiJ,X.\u001a8ugV\u001111\u0007\t\u0005\u0005/\u001b)$\u0003\u0003\u00048\t]&aD*xCBLen\u001d;sk6,g\u000e^:\u0002#}\u001bx/\u00199J]N$(/^7f]R\u001c\b%A\f`Y>\fG-\u0011<fe\u0006<W-\u00138tiJ,X.\u001a8ugV\u00111q\b\t\u0005\u0005/\u001b\t%\u0003\u0003\u0004D\t]&A\u0006'pC\u0012\fe/\u001a:bO\u0016Len\u001d;sk6,g\u000e^:\u00021}cw.\u00193Bm\u0016\u0014\u0018mZ3J]N$(/^7f]R\u001c\b%A\u000e`M&dWmU=ti\u0016lWk]1hK&s7\u000f\u001e:v[\u0016tGo]\u000b\u0003\u0007\u0017\u0002BAa&\u0004N%!1q\nB\\\u0005]\u0019Fo\u001c:bO\u0016lu.\u001e8u\u0013:\u001cHO];nK:$8/\u0001\u000f`M&dWmU=ti\u0016lWk]1hK&s7\u000f\u001e:v[\u0016tGo\u001d\u0011\u0002=}3\u0017\u000e\\3TsN$X-\\!di&4\u0018\u000e^=J]N$(/^7f]R\u001cXCAB,!\u0011\u00119j!\u0017\n\t\rm#q\u0017\u0002\u0019'R|'/Y4f\t\u00164\u0018nY3J]N$(/^7f]R\u001c\u0018aH0gS2,7+_:uK6\f5\r^5wSRL\u0018J\\:ueVlWM\u001c;tA\u0005YrL\\3uo>\u00148.Q2uSZLG/_%ogR\u0014X/\\3oiN,\"aa\u0019\u0011\t\t]5QM\u0005\u0005\u0007O\u00129L\u0001\u000eOKR<xN]6BGRLg/\u001b;z\u0013:\u001cHO];nK:$8/\u0001\u000f`]\u0016$xo\u001c:l\u0003\u000e$\u0018N^5us&s7\u000f\u001e:v[\u0016tGo\u001d\u0011\u0015\t\t-2Q\u000e\u0005\u0006wz\u0002\r\u0001`\u0001\u0012e\u0016\u001cwN\u001d3NK6|'/_+tC\u001e,\u0017!\u0005:fG>\u0014H\rT8bI\u00063XM]1hK\u0006\u0011\"/Z2pe\u0012\u001cFo\u001c:bO\u0016,6/Y4f\u0003%!x\u000eU3sG\u0016tG\u000f\u0006\u0004\u0003F\u000ee4Q\u0010\u0005\b\u0007w\u001a\u0005\u0019\u0001Bc\u0003\u00151\u0018\r\\;f\u0011\u001d\u0019yh\u0011a\u0001\u0005\u000b\fQ\u0001^8uC2\fQC]3d_J$7\u000b^8sC\u001e,\u0017i\u0019;jm&$\u00180A\u000bsK\u000e|'\u000f\u001a(fi^|'o[!di&4\u0018\u000e^=\u0002+}KgN\u001a:fcV,g\u000e^\"pY2,7\r^8sA\u0005YqLZ2TG\",G-\u001e7f+\t\u0019Y\t\r\u0003\u0004\u000e\u000eu\u0005CBBH\u0007+\u001bI*\u0004\u0002\u0004\u0012*\u0019qpa%\u000b\t\u0005M\u00141D\u0005\u0005\u0007/\u001b\tJA\bTG\",G-\u001e7fI\u001a+H/\u001e:f!\u0011\u0019Yj!(\r\u0001\u0011Y1qT\u0007\u0002\u0002\u0003\u0005)\u0011ABR\u0005\ty\u0004'\u0001\u0007`M\u000e\u001c6\r[3ek2,\u0007%\u0005\u0003\u0004&\u0006e\u0006c\u00019\u0004(&\u00191\u0011V9\u0003\u000f9{G\u000f[5oO\u0006aq,\u001b4d'\u000eDW\rZ;mKV\u00111q\u0016\u0019\u0005\u0007c\u001b)\f\u0005\u0004\u0004\u0010\u000eU51\u0017\t\u0005\u00077\u001b)\fB\u0006\u0004 >\t\t\u0011!A\u0003\u0002\r\r\u0016!D0jM\u000e\u001c6\r[3ek2,\u0007%\u0001\u0003ti>\u0004\u0018a\u0003:fG>tg-[4ve\u0016$BAa\u000b\u0004@\"91\u0011Y\tA\u0002\r\r\u0017!\u00038fo\u000e{gNZ5h!\u0011\u0019)ma5\u000e\u0005\r\u001d'\u0002BBe\u0007\u0017\faaY8oM&<'\u0002BBg\u0007\u001f\f\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0007#\f1aY8n\u0013\u0011\u0019)na2\u0003\r\r{gNZ5h\u00031\u0011X-\u00193TKR$\u0018N\\4t)\u0011\tIca7\t\u000f\r%'\u00031\u0001\u0004D\u0006\u00112o\u00195fIVdWm\u00148N_\u0012,H.Z#D)\u0011\u0019\toa:\u0011\t\u0005U11]\u0005\u0005\u0007K\f9B\u0001\u0005Sk:t\u0017M\u00197f\u0011\u001d\u0019Io\u0005a\u0001\u0005\u0013\nA\u0001^1tW\u0002")
public class HostMetricsCollector
implements Module {
    public final ExecutionContext kamon$instrumentation$system$host$HostMetricsCollector$$ec;
    private final String _configPath;
    private volatile Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings;
    private final FrequentCollectionTask _frequentCollector;
    private final InfrequentCollectionTask _infrequentCollector;
    private final ScheduledFuture<?> _fcSchedule;
    private final ScheduledFuture<?> _ifcSchedule;

    private String _configPath() {
        return this._configPath;
    }

    public Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings() {
        return this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings;
    }

    private void kamon$instrumentation$system$host$HostMetricsCollector$$_settings_$eq(Settings x$1) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings = x$1;
    }

    private FrequentCollectionTask _frequentCollector() {
        return this._frequentCollector;
    }

    private InfrequentCollectionTask _infrequentCollector() {
        return this._infrequentCollector;
    }

    private ScheduledFuture<?> _fcSchedule() {
        return this._fcSchedule;
    }

    private ScheduledFuture<?> _ifcSchedule() {
        return this._ifcSchedule;
    }

    public void stop() {
        this._fcSchedule().cancel(false);
        this._ifcSchedule().cancel(false);
        this._frequentCollector().cleanup();
        this._infrequentCollector().cleanup();
    }

    public void reconfigure(Config newConfig) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings_$eq(this.readSettings(newConfig));
    }

    private Settings readSettings(Config config) {
        Config hostConfig = config.getConfig(this._configPath());
        return new Settings(Filter$.MODULE$.from(hostConfig.getConfig("network.tracked-interfaces")), Filter$.MODULE$.from(hostConfig.getConfig("storage.tracked-mount-types")));
    }

    private Runnable scheduleOnModuleEC(CollectionTask task) {
        return new Runnable(this, task){
            private final /* synthetic */ HostMetricsCollector $outer;
            private final CollectionTask task$1;

            public void run() {
                this.task$1.schedule(this.$outer.kamon$instrumentation$system$host$HostMetricsCollector$$ec);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.task$1 = task$1;
            }
        };
    }

    public HostMetricsCollector(ExecutionContext ec) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$ec = ec;
        this._configPath = "kamon.instrumentation.system.host";
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings = this.readSettings(Kamon$.MODULE$.config());
        this._frequentCollector = new FrequentCollectionTask();
        this._infrequentCollector = new InfrequentCollectionTask();
        this._fcSchedule = Kamon$.MODULE$.scheduler().scheduleAtFixedRate(this.scheduleOnModuleEC(this._frequentCollector()), 1L, 1L, TimeUnit.SECONDS);
        this._ifcSchedule = Kamon$.MODULE$.scheduler().scheduleAtFixedRate(this.scheduleOnModuleEC(this._infrequentCollector()), 1L, 10L, TimeUnit.SECONDS);
    }

    public interface CollectionTask {
        public void schedule(ExecutionContext var1);

        public void cleanup();
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new HostMetricsCollector(settings.executionContext());
        }
    }

    public class FrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final HostMetrics.CpuInstruments _cpuInstruments;
        private long[] _prevCpuLoadTicks;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private HostMetrics.CpuInstruments _cpuInstruments() {
            return this._cpuInstruments;
        }

        private long[] _prevCpuLoadTicks() {
            return this._prevCpuLoadTicks;
        }

        private void _prevCpuLoadTicks_$eq(long[] x$1) {
            this._prevCpuLoadTicks = x$1;
        }

        @Override
        public void schedule(ExecutionContext ec) {
            Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.recordCpuUsage(), ec);
        }

        @Override
        public void cleanup() {
            this._cpuInstruments().remove();
        }

        private void recordCpuUsage() {
            if (this._prevCpuLoadTicks().length > 0) {
                long[] previousTicks = this._prevCpuLoadTicks();
                long[] currentTicks = this._hal().getProcessor().getSystemCpuLoadTicks();
                long user = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.USER);
                long nice = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.NICE);
                long system = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SYSTEM);
                long idle = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IDLE);
                long iowait = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IOWAIT);
                long irq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IRQ);
                long softirq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SOFTIRQ);
                long steal = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.STEAL);
                long total = user + nice + system + idle + iowait + irq + softirq + steal;
                this._cpuInstruments().user().record(FrequentCollectionTask.toPercent$1(user, total));
                this._cpuInstruments().system().record(FrequentCollectionTask.toPercent$1(system, total));
                this._cpuInstruments().iowait().record(FrequentCollectionTask.toPercent$1(iowait, total));
                this._cpuInstruments().idle().record(FrequentCollectionTask.toPercent$1(idle, total));
                this._cpuInstruments().stolen().record(FrequentCollectionTask.toPercent$1(steal, total));
                this._cpuInstruments().combined().record(FrequentCollectionTask.toPercent$1(user + system + nice + iowait, total));
                this._prevCpuLoadTicks_$eq(currentTicks);
                return;
            }
            this._prevCpuLoadTicks_$eq(this._hal().getProcessor().getSystemCpuLoadTicks());
        }

        private long ticksDiff(long[] previous, long[] current, CentralProcessor.TickType tickType) {
            return package$.MODULE$.max(current[tickType.getIndex()] - previous[tickType.getIndex()], 0L);
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        private static final long toPercent$1(long value, long total$1) {
            return (long)(100.0 * (double)value / (double)total$1);
        }

        public FrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._cpuInstruments = new HostMetrics.CpuInstruments(this._defaultTags());
            this._prevCpuLoadTicks = (long[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Long());
        }
    }

    public class InfrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final OperatingSystem _os;
        private final HostMetrics.MemoryInstruments _memoryInstruments;
        private final HostMetrics.SwapInstruments _swapInstruments;
        private final HostMetrics.LoadAverageInstruments _loadAverageInstruments;
        private final HostMetrics.StorageMountInstruments _fileSystemUsageInstruments;
        private final HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments;
        private final HostMetrics.NetworkActivityInstruments _networkActivityInstruments;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private OperatingSystem _os() {
            return this._os;
        }

        private HostMetrics.MemoryInstruments _memoryInstruments() {
            return this._memoryInstruments;
        }

        private HostMetrics.SwapInstruments _swapInstruments() {
            return this._swapInstruments;
        }

        private HostMetrics.LoadAverageInstruments _loadAverageInstruments() {
            return this._loadAverageInstruments;
        }

        private HostMetrics.StorageMountInstruments _fileSystemUsageInstruments() {
            return this._fileSystemUsageInstruments;
        }

        private HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments() {
            return this._fileSystemActivityInstruments;
        }

        private HostMetrics.NetworkActivityInstruments _networkActivityInstruments() {
            return this._networkActivityInstruments;
        }

        @Override
        public void schedule(ExecutionContext ec) {
            Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.recordMemoryUsage();
                this.recordLoadAverage();
                this.recordStorageUsage();
                this.recordStorageActivity();
                this.recordNetworkActivity();
            }, ec);
        }

        @Override
        public void cleanup() {
            this._memoryInstruments().remove();
            this._swapInstruments().remove();
            this._loadAverageInstruments().remove();
            this._fileSystemUsageInstruments().remove();
            this._fileSystemActivityInstruments().remove();
            this._networkActivityInstruments().remove();
        }

        private void recordMemoryUsage() {
            GlobalMemory memory = this._hal().getMemory();
            long totalMemory = memory.getTotal();
            long availableMemory = memory.getAvailable();
            long usedMemory = totalMemory - availableMemory;
            this._memoryInstruments().total().update((double)totalMemory);
            this._memoryInstruments().free().update((double)availableMemory);
            this._memoryInstruments().used().update((double)usedMemory);
            this._memoryInstruments().usage().update((double)this.toPercent(usedMemory, totalMemory));
            long usedSwap = memory.getVirtualMemory().getSwapUsed();
            long totalSwap = memory.getVirtualMemory().getSwapTotal();
            this._swapInstruments().total().update((double)totalSwap);
            this._swapInstruments().used().update((double)usedSwap);
            this._swapInstruments().usage().update((double)this.toPercent(usedSwap, totalSwap));
            this._swapInstruments().free().update((double)(totalSwap - usedSwap));
        }

        private void recordLoadAverage() {
            double[] loadAverage = this._hal().getProcessor().getSystemLoadAverage(3);
            if (loadAverage[0] >= 0.0) {
                this._loadAverageInstruments().oneMinute().update(loadAverage[0]);
            }
            if (loadAverage[1] >= 0.0) {
                this._loadAverageInstruments().fiveMinutes().update(loadAverage[1]);
            }
            if (loadAverage[2] >= 0.0) {
                this._loadAverageInstruments().fifteenMinutes().update(loadAverage[2]);
            }
        }

        private void recordStorageUsage() {
            List fileStores = this._os().getFileSystem().getFileStores();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fileStores).asScala()).foreach((Function1 & Serializable & scala.Serializable)fs -> {
                if (this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedMounts().accept(fs.getType())) {
                    HostMetrics.StorageMountInstruments.MountInstruments mountInstruments = this._fileSystemUsageInstruments().mountInstruments(fs.getMount());
                    long totalSpace = fs.getTotalSpace();
                    long usedSpace = totalSpace - fs.getUsableSpace();
                    mountInstruments.free().update((double)fs.getUsableSpace());
                    mountInstruments.total().update((double)totalSpace);
                    mountInstruments.used().update((double)usedSpace);
                    return mountInstruments.usage().update((double)this.toPercent(usedSpace, totalSpace));
                }
                return BoxedUnit.UNIT;
            });
        }

        private long toPercent(long value, long total) {
            return (long)(100.0 * (double)value / (double)total);
        }

        private void recordStorageActivity() {
            List devices = this._hal().getDiskStores();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(devices).asScala()).foreach((Function1 & Serializable & scala.Serializable)device -> {
                InfrequentCollectionTask.$anonfun$recordStorageActivity$1(this, device);
                return BoxedUnit.UNIT;
            });
        }

        private void recordNetworkActivity() {
            List interfaces = this._hal().getNetworkIFs();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(interfaces).asScala()).foreach((Function1 & Serializable & scala.Serializable)networkIF -> {
                InfrequentCollectionTask.$anonfun$recordNetworkActivity$1(this, networkIF);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        public static final /* synthetic */ void $anonfun$recordStorageActivity$1(InfrequentCollectionTask $this, HWDiskStore device) {
            if (!device.getPartitions().isEmpty()) {
                HostMetrics.StorageDeviceInstruments.DeviceInstruments deviceInstruments = $this._fileSystemActivityInstruments().deviceInstruments(device.getName());
                deviceInstruments.reads().diff(device.getReads());
                deviceInstruments.writes().diff(device.getWrites());
                deviceInstruments.readBytes().diff(device.getReadBytes());
                deviceInstruments.writeBytes().diff(device.getWriteBytes());
            }
        }

        public static final /* synthetic */ void $anonfun$recordNetworkActivity$1(InfrequentCollectionTask $this, NetworkIF networkIF) {
            if ($this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedInterfaces().accept(networkIF.getName())) {
                HostMetrics.NetworkActivityInstruments.InterfaceInstruments interfaceInstruments = $this._networkActivityInstruments().interfaceInstruments(networkIF.getName());
                interfaceInstruments.receivedBytes().diff(networkIF.getBytesRecv());
                interfaceInstruments.sentBytes().diff(networkIF.getBytesSent());
                interfaceInstruments.sentPackets().diff(networkIF.getPacketsSent());
                interfaceInstruments.receivedPackets().diff(networkIF.getPacketsRecv());
                interfaceInstruments.sendErrorPackets().diff(networkIF.getOutErrors());
                interfaceInstruments.receiveErrorPackets().diff(networkIF.getInErrors());
            }
        }

        public InfrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._os = this._systemInfo().getOperatingSystem();
            this._memoryInstruments = new HostMetrics.MemoryInstruments(this._defaultTags());
            this._swapInstruments = new HostMetrics.SwapInstruments(this._defaultTags());
            this._loadAverageInstruments = new HostMetrics.LoadAverageInstruments(this._defaultTags());
            this._fileSystemUsageInstruments = new HostMetrics.StorageMountInstruments(this._defaultTags());
            this._fileSystemActivityInstruments = new HostMetrics.StorageDeviceInstruments(this._defaultTags());
            this._networkActivityInstruments = new HostMetrics.NetworkActivityInstruments(this._defaultTags());
        }
    }

    public static class Settings
    implements Product,
    scala.Serializable {
        private final Filter trackedInterfaces;
        private final Filter trackedMounts;

        public Filter trackedInterfaces() {
            return this.trackedInterfaces;
        }

        public Filter trackedMounts() {
            return this.trackedMounts;
        }

        public Settings copy(Filter trackedInterfaces, Filter trackedMounts) {
            return new Settings(trackedInterfaces, trackedMounts);
        }

        public Filter copy$default$1() {
            return this.trackedInterfaces();
        }

        public Filter copy$default$2() {
            return this.trackedMounts();
        }

        public String productPrefix() {
            return "Settings";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.trackedInterfaces();
                }
                case 1: {
                    return this.trackedMounts();
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Settings;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof Settings)) return false;
            boolean bl = true;
            if (!bl) return false;
            Settings settings = (Settings)x$1;
            Filter filter = this.trackedInterfaces();
            Filter filter2 = settings.trackedInterfaces();
            if (filter == null) {
                if (filter2 != null) {
                    return false;
                }
            } else if (!filter.equals(filter2)) return false;
            Filter filter3 = this.trackedMounts();
            Filter filter4 = settings.trackedMounts();
            if (filter3 == null) {
                if (filter4 != null) {
                    return false;
                }
            } else if (!filter3.equals(filter4)) return false;
            if (!settings.canEqual(this)) return false;
            return true;
        }

        public Settings(Filter trackedInterfaces, Filter trackedMounts) {
            this.trackedInterfaces = trackedInterfaces;
            this.trackedMounts = trackedMounts;
            Product.$init$((Product)this);
        }
    }
}

