/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.http;

import akka.Done;
import akka.NotUsed;
import akka.http.javadsl.model.ResponseEntity;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.stream.Attributes;
import akka.stream.BidiShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import kamon.Kamon$;
import kamon.instrumentation.akka.http.AkkaHttpInstrumentation$;
import kamon.instrumentation.akka.http.LastAutomaticOperationNameEdit$;
import kamon.instrumentation.akka.http.ServerFlowWrapper;
import kamon.instrumentation.akka.http.ServerFlowWrapper$;
import kamon.instrumentation.akka.http.ServerFlowWrapper$$anon$1$;
import kamon.instrumentation.akka.http.ServerFlowWrapper$$anon$1$$anon$2$;
import kamon.instrumentation.http.HttpServerInstrumentation;
import kamon.instrumentation.http.HttpServerInstrumentation$;
import kamon.trace.Span;
import kamon.util.CallingThreadExecutionContext$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ServerFlowWrapper$ {
    public static ServerFlowWrapper$ MODULE$;
    private final TrieMap<Object, HttpServerInstrumentation> _serverInstrumentations;
    private final TrieMap<Object, String> _defaultOperationNames;
    private final ServerFlowWrapper.Settings _defaultSettings;
    private volatile ServerFlowWrapper.Settings _wrapperSettings;

    static {
        new ServerFlowWrapper$();
    }

    private TrieMap<Object, HttpServerInstrumentation> _serverInstrumentations() {
        return this._serverInstrumentations;
    }

    private TrieMap<Object, String> _defaultOperationNames() {
        return this._defaultOperationNames;
    }

    private ServerFlowWrapper.Settings _defaultSettings() {
        return this._defaultSettings;
    }

    private ServerFlowWrapper.Settings _wrapperSettings() {
        return this._wrapperSettings;
    }

    private void _wrapperSettings_$eq(ServerFlowWrapper.Settings x$1) {
        this._wrapperSettings = x$1;
    }

    public Flow<HttpRequest, HttpResponse, NotUsed> apply(Flow<HttpRequest, HttpResponse, NotUsed> flow, String string, int port) {
        return BidiFlow$.MODULE$.fromGraph(this.wrapStage(this._wrapperSettings(), string, port)).join(flow);
    }

    public GraphStage<BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse>> wrapStage(ServerFlowWrapper.Settings settings, String string, int port) {
        return new GraphStage<BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse>>(settings, string, port){
            private final Config httpServerConfig;
            private final HttpServerInstrumentation httpServerInstrumentation;
            private final Inlet<HttpRequest> requestIn;
            private final Outlet<HttpRequest> requestOut;
            private final Inlet<HttpResponse> responseIn;
            private final Outlet<HttpResponse> responseOut;
            private final BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse> shape;

            public Config httpServerConfig() {
                return this.httpServerConfig;
            }

            public HttpServerInstrumentation httpServerInstrumentation() {
                return this.httpServerInstrumentation;
            }

            public Inlet<HttpRequest> requestIn() {
                return this.requestIn;
            }

            public Outlet<HttpRequest> requestOut() {
                return this.requestOut;
            }

            public Inlet<HttpResponse> responseIn() {
                return this.responseIn;
            }

            public Outlet<HttpResponse> responseOut() {
                return this.responseOut;
            }

            public BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse> shape() {
                return this.shape;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new GraphStageLogic(this){
                    private final Queue<HttpServerInstrumentation.RequestHandler> kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests;
                    private final Instant _createdAt;
                    private int kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests;
                    private final /* synthetic */ anon.1 $outer;

                    public Queue<HttpServerInstrumentation.RequestHandler> kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests() {
                        return this.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests;
                    }

                    private Instant _createdAt() {
                        return this._createdAt;
                    }

                    public int kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests() {
                        return this.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests;
                    }

                    public void kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests_$eq(int x$1) {
                        this.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests = x$1;
                    }

                    public void preStart() {
                        this.$outer.httpServerInstrumentation().connectionOpened();
                    }

                    public void postStop() {
                        Duration connectionLifetime = Duration.between(this._createdAt(), Kamon$.MODULE$.clock().instant());
                        this.$outer.httpServerInstrumentation().connectionClosed(connectionLifetime, this.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests());
                    }

                    public /* synthetic */ anon.1 kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        this.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests = (Queue)Queue$.MODULE$.empty();
                        this._createdAt = Kamon$.MODULE$.clock().instant();
                        this.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests = 0;
                        this.setHandler($outer.requestIn(), new InHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onUpstreamFailure(Throwable ex) throws Exception {
                                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                            }

                            public void onPush() {
                                HttpRequest request = (HttpRequest)this.$outer.grab(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().requestIn());
                                HttpServerInstrumentation.RequestHandler requestHandler = this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().httpServerInstrumentation().createHandler(AkkaHttpInstrumentation$.MODULE$.toRequest(request), true).requestReceived();
                                String defaultOperationName = this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().httpServerInstrumentation().settings().defaultOperationName();
                                Span requestSpan = requestHandler.span();
                                String string = requestSpan.operationName();
                                boolean allowAutomaticChanges = !(string != null ? !string.equals(defaultOperationName) : defaultOperationName != null);
                                this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HttpServerInstrumentation.RequestHandler[]{requestHandler}));
                                Kamon$.MODULE$.storeContext(requestHandler.context().withEntry(LastAutomaticOperationNameEdit$.MODULE$.Key(), (Object)Option$.MODULE$.apply((Object)LastAutomaticOperationNameEdit$.MODULE$.apply(requestSpan.operationName(), allowAutomaticChanges))));
                                this.$outer.push(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().requestOut(), request);
                            }

                            public void onUpstreamFinish() {
                                this.$outer.complete(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().requestOut());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                InHandler.$init$((InHandler)this);
                            }
                        });
                        this.setHandler($outer.requestOut(), new OutHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onPull() {
                                this.$outer.pull(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().requestIn());
                            }

                            public void onDownstreamFinish() {
                                this.$outer.cancel(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().requestIn());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                OutHandler.$init$((OutHandler)this);
                            }
                        });
                        this.setHandler($outer.responseIn(), new InHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onUpstreamFailure(Throwable ex) throws Exception {
                                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                            }

                            public void onPush() {
                                akka.http.scaladsl.model.ResponseEntity responseEntity;
                                HttpResponse response = (HttpResponse)this.$outer.grab(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().responseIn());
                                HttpServerInstrumentation.RequestHandler requestHandler = (HttpServerInstrumentation.RequestHandler)this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests().dequeue();
                                Span requestSpan = requestHandler.span();
                                HttpResponse responseWithContext = requestHandler.buildResponse(AkkaHttpInstrumentation$.MODULE$.toResponseBuilder(response), requestHandler.context());
                                if (response.status().intValue() == 404) {
                                    String string = requestSpan.operationName();
                                    String string2 = this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().httpServerInstrumentation().settings().defaultOperationName();
                                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                        requestSpan.name(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().httpServerInstrumentation().settings().unhandledOperationName()).takeSamplingDecision();
                                    }
                                }
                                if (responseWithContext.entity().isKnownEmpty()) {
                                    requestHandler.responseSent(0L);
                                    responseEntity = responseWithContext.entity();
                                } else {
                                    HttpEntity.Strict strict;
                                    requestSpan.mark("http.response.ready");
                                    akka.http.scaladsl.model.ResponseEntity responseEntity2 = responseWithContext.entity();
                                    if (responseEntity2 instanceof HttpEntity.Strict) {
                                        HttpEntity.Strict strict2 = (HttpEntity.Strict)responseEntity2;
                                        ByteString bs2 = strict2.data();
                                        requestHandler.responseSent(bs2.size());
                                        strict = strict2;
                                    } else {
                                        AtomicLong responseSizeCounter = new AtomicLong(0L);
                                        strict = responseWithContext.entity().transformDataBytes(((Flow)Flow$.MODULE$.apply().watchTermination(Keep$.MODULE$.right()).wireTap((Function1 & Serializable & scala.Serializable)bs -> {
                                            anon$1$$anon$2$$anon$5.$anonfun$onPush$1(responseSizeCounter, bs);
                                            return BoxedUnit.UNIT;
                                        })).mapMaterializedValue((Function1 & Serializable & scala.Serializable)f -> f.andThen((PartialFunction)new scala.Serializable(null, requestHandler, responseSizeCounter, requestSpan){
                                            public static final long serialVersionUID = 0L;
                                            private final HttpServerInstrumentation.RequestHandler requestHandler$1;
                                            private final AtomicLong responseSizeCounter$1;
                                            private final Span requestSpan$1;

                                            public final <A1 extends Try<Done>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                                Object object;
                                                if (x1 instanceof Success) {
                                                    this.requestHandler$1.responseSent(this.responseSizeCounter$1.get());
                                                    object = BoxedUnit.UNIT;
                                                } else if (x1 instanceof Failure) {
                                                    Throwable e = ((Failure)x1).exception();
                                                    this.requestSpan$1.fail("Response entity stream failed", e);
                                                    this.requestHandler$1.responseSent(this.responseSizeCounter$1.get());
                                                    object = BoxedUnit.UNIT;
                                                } else {
                                                    object = function1.apply(x1);
                                                }
                                                return (B1)object;
                                            }

                                            public final boolean isDefinedAt(Try<Done> x1) {
                                                boolean bl = x1 instanceof Success ? true : x1 instanceof Failure;
                                                return bl;
                                            }
                                            {
                                                this.requestHandler$1 = requestHandler$1;
                                                this.responseSizeCounter$1 = responseSizeCounter$1;
                                                this.requestSpan$1 = requestSpan$1;
                                            }
                                        }, (ExecutionContext)CallingThreadExecutionContext$.MODULE$)));
                                    }
                                    responseEntity = strict;
                                }
                                akka.http.scaladsl.model.ResponseEntity entity = responseEntity;
                                this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests_$eq(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests() + 1);
                                this.$outer.push(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().responseOut(), responseWithContext.withEntity((ResponseEntity)entity));
                            }

                            public void onUpstreamFinish() {
                                this.$outer.completeStage();
                            }

                            public static final /* synthetic */ void $anonfun$onPush$1(AtomicLong responseSizeCounter$1, ByteString bs) {
                                responseSizeCounter$1.addAndGet(bs.size());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                InHandler.$init$((InHandler)this);
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPush$1$adapted(java.util.concurrent.atomic.AtomicLong akka.util.ByteString ), $anonfun$onPush$2(kamon.instrumentation.http.HttpServerInstrumentation$RequestHandler java.util.concurrent.atomic.AtomicLong kamon.trace.Span scala.concurrent.Future )}, serializedLambda);
                            }
                        });
                        this.setHandler($outer.responseOut(), new OutHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onPull() {
                                this.$outer.pull(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().responseIn());
                            }

                            public void onDownstreamFinish() {
                                this.$outer.cancel(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().responseIn());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                OutHandler.$init$((OutHandler)this);
                            }
                        });
                    }
                };
            }
            {
                this.httpServerConfig = Kamon$.MODULE$.config().getConfig(settings$1.configPath());
                this.httpServerInstrumentation = HttpServerInstrumentation$.MODULE$.from(this.httpServerConfig(), settings$1.component(), interface$1, port$1);
                this.requestIn = Inlet$.MODULE$.create("request.in");
                this.requestOut = Outlet$.MODULE$.create("request.out");
                this.responseIn = Inlet$.MODULE$.create("response.in");
                this.responseOut = Outlet$.MODULE$.create("response.out");
                this.shape = new BidiShape(this.requestIn(), this.requestOut(), this.responseIn(), this.responseOut());
            }
        };
    }

    public void changeSettings(String component, String configPath) {
        this._wrapperSettings_$eq(new ServerFlowWrapper.Settings(component, configPath));
    }

    public void resetSettings() {
        this._wrapperSettings_$eq(this._defaultSettings());
    }

    public String defaultOperationName(int listenPort) {
        return (String)this._defaultOperationNames().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)listenPort), (Function0 & Serializable & scala.Serializable)() -> (String)MODULE$._serverInstrumentations().get((Object)BoxesRunTime.boxToInteger((int)listenPort)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.settings().defaultOperationName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "http.server.request"));
    }

    private ServerFlowWrapper$() {
        MODULE$ = this;
        this._serverInstrumentations = TrieMap$.MODULE$.empty();
        this._defaultOperationNames = TrieMap$.MODULE$.empty();
        this._defaultSettings = new ServerFlowWrapper.Settings("akka.http.server", "kamon.instrumentation.akka.http.server");
        this._wrapperSettings = this._defaultSettings();
    }
}

