/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.executor;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import kamon.Kamon$;
import kamon.instrumentation.executor.ExecutorInstrumentation;
import kamon.instrumentation.executor.ExecutorInstrumentation$ForkJoinPoolTelemetryReader$;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

public final class ExecutorInstrumentation$ {
    public static ExecutorInstrumentation$ MODULE$;
    private final Logger _logger;
    private volatile Duration kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval;
    private final ExecutorInstrumentation.Settings DefaultSettings;
    private final ExecutorInstrumentation.Settings NoExtraSettings;
    private final Class<?> _delegatedExecutorClass;
    private final Class<?> _finalizableDelegatedClass;
    private final Class<?> _delegateScheduledClass;
    private final Field _delegatedExecutorField;
    private final Field _executionContextExecutorField;

    static {
        new ExecutorInstrumentation$();
    }

    private Logger _logger() {
        return this._logger;
    }

    public Duration kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval() {
        return this.kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval;
    }

    private void kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval_$eq(Duration x$1) {
        this.kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval = x$1;
    }

    public ExecutorService instrument(ExecutorService executor, String name) {
        return this.instrument(executor, name, TagSet$.MODULE$.Empty(), this.DefaultSettings());
    }

    public ExecutionContextExecutorService instrumentExecutionContext(ExecutionContext executionContext, String name) {
        return this.instrumentExecutionContext(executionContext, name, TagSet$.MODULE$.Empty(), this.DefaultSettings());
    }

    public ScheduledExecutorService instrumentScheduledExecutor(ScheduledExecutorService executor, String name) {
        return this.instrumentScheduledExecutor(executor, name, TagSet$.MODULE$.Empty());
    }

    public ExecutorService instrument(ExecutorService executor, String name, ExecutorInstrumentation.Settings settings) {
        return this.instrument(executor, name, TagSet$.MODULE$.Empty(), settings);
    }

    public ExecutionContextExecutorService instrumentExecutionContext(ExecutionContext executionContext, String name, ExecutorInstrumentation.Settings settings) {
        return this.instrumentExecutionContext(executionContext, name, TagSet$.MODULE$.Empty(), settings);
    }

    public ExecutorService instrument(ExecutorService executor, String name, TagSet extraTags) {
        return this.instrument(executor, name, extraTags, this.DefaultSettings());
    }

    public ExecutionContextExecutorService instrumentExecutionContext(ExecutionContext executionContext, String name, TagSet extraTags) {
        return this.instrumentExecutionContext(executionContext, name, extraTags, this.DefaultSettings());
    }

    public ExecutorService instrument(ExecutorService executor, String name, TagSet extraTags, ExecutorInstrumentation.Settings settings) {
        ExecutorService executorService;
        ExecutorService executorService2;
        ForkJoinPool forkJoinPool;
        boolean bl;
        while (true) {
            ExecutorService executorService3;
            bl = false;
            forkJoinPool = null;
            executorService2 = executor;
            if (executorService2 == null || !this.isWrapper(executorService3 = executorService2)) break;
            executor = this.unwrap(executorService3);
        }
        if (executorService2 instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService2;
            executorService = new ExecutorInstrumentation.InstrumentedThreadPool(threadPoolExecutor, name, extraTags, settings);
        } else if (executorService2 instanceof ForkJoinPool) {
            bl = true;
            forkJoinPool = (ForkJoinPool)executorService2;
            executorService = new ExecutorInstrumentation.InstrumentedForkJoinPool(forkJoinPool, ExecutorInstrumentation$ForkJoinPoolTelemetryReader$.MODULE$.forJava(forkJoinPool), name, extraTags, settings);
        } else if (bl) {
            executorService = new ExecutorInstrumentation.InstrumentedForkJoinPool(forkJoinPool, ExecutorInstrumentation$ForkJoinPoolTelemetryReader$.MODULE$.forScala(forkJoinPool), name, extraTags, settings);
        } else {
            this._logger().warn("Cannot instrument unknown executor [{}]", new Object[]{executorService2});
            executorService = executor;
        }
        return executorService;
    }

    public ScheduledExecutorService instrumentScheduledExecutor(ScheduledExecutorService executor, String name, TagSet extraTags) {
        ScheduledExecutorService scheduledExecutorService;
        ScheduledExecutorService scheduledExecutorService2;
        ScheduledExecutorService scheduledExecutorService3;
        while ((scheduledExecutorService3 = executor) != null && this.isWrapper(scheduledExecutorService2 = scheduledExecutorService3)) {
            executor = (ScheduledExecutorService)this.unwrap(scheduledExecutorService2);
        }
        if (scheduledExecutorService3 instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService3;
            scheduledExecutorService = new ExecutorInstrumentation.InstrumentedScheduledThreadPoolExecutor(scheduledThreadPoolExecutor, name, extraTags.withTag("scheduled", Predef$.MODULE$.boolean2Boolean(true)));
        } else {
            this._logger().warn("Cannot instrument unknown executor [{}]", new Object[]{scheduledExecutorService3});
            scheduledExecutorService = executor;
        }
        return scheduledExecutorService;
    }

    public ExecutionContextExecutorService instrumentExecutionContext(ExecutionContext executionContext, String name, TagSet extraTags, ExecutorInstrumentation.Settings settings) {
        ExecutorService executor = this.unwrapExecutionContext(executionContext);
        ExecutorService instrumentedExecutor = this.instrument(executor, name, extraTags, settings);
        return ExecutionContext$.MODULE$.fromExecutorService(instrumentedExecutor);
    }

    public ExecutorService instrument(ExecutorService executor, ExecutorInstrumentation.ForkJoinPoolTelemetryReader telemetryReader, String name, TagSet extraTags, ExecutorInstrumentation.Settings settings) {
        return new ExecutorInstrumentation.InstrumentedForkJoinPool(executor, telemetryReader, name, extraTags, settings);
    }

    public ExecutorInstrumentation.Settings DefaultSettings() {
        return this.DefaultSettings;
    }

    public ExecutorInstrumentation.Settings NoExtraSettings() {
        return this.NoExtraSettings;
    }

    private Class<?> _delegatedExecutorClass() {
        return this._delegatedExecutorClass;
    }

    private Class<?> _finalizableDelegatedClass() {
        return this._finalizableDelegatedClass;
    }

    private Class<?> _delegateScheduledClass() {
        return this._delegateScheduledClass;
    }

    private Field _delegatedExecutorField() {
        return this._delegatedExecutorField;
    }

    private Field _executionContextExecutorField() {
        return this._executionContextExecutorField;
    }

    private boolean isAssignableTo(ExecutorService executor, Class<?> expectedClass) {
        return expectedClass.isAssignableFrom(executor.getClass());
    }

    private boolean isWrapper(ExecutorService executor) {
        return this.isAssignableTo(executor, this._delegatedExecutorClass()) || this.isAssignableTo(executor, this._finalizableDelegatedClass()) || this.isAssignableTo(executor, this._delegateScheduledClass());
    }

    private ExecutorService unwrap(ExecutorService delegatedExecutor) {
        return (ExecutorService)this._delegatedExecutorField().get(delegatedExecutor);
    }

    private ExecutorService unwrapExecutionContext(ExecutionContext executionContext) {
        return (ExecutorService)this._executionContextExecutorField().get(executionContext);
    }

    private Duration readSampleInterval(Config config) {
        return (Duration)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Kamon$.MODULE$.config().getDuration("kamon.instrumentation.executor.sample-interval")).getOrElse((Function0 & Serializable & scala.Serializable)() -> Duration.ofSeconds(10L));
    }

    /*
     * WARNING - void declaration
     */
    private ExecutorInstrumentation$() {
        void var2_2;
        void var1_1;
        MODULE$ = this;
        this._logger = LoggerFactory.getLogger((String)"kamon.instrumentation.executors.ExecutorsInstrumentation");
        this.kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval = this.readSampleInterval(Kamon$.MODULE$.config());
        Kamon$.MODULE$.onReconfigure((Function1 & Serializable & scala.Serializable)newConfig -> {
            ExecutorInstrumentation$.MODULE$.kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval_$eq(ExecutorInstrumentation$.MODULE$.readSampleInterval(newConfig));
            return BoxedUnit.UNIT;
        });
        this.DefaultSettings = new ExecutorInstrumentation.Settings(true, false);
        this.NoExtraSettings = new ExecutorInstrumentation.Settings(false, false);
        this._delegatedExecutorClass = Class.forName("java.util.concurrent.Executors$DelegatedExecutorService");
        this._finalizableDelegatedClass = Class.forName("java.util.concurrent.Executors$FinalizableDelegatedExecutorService");
        this._delegateScheduledClass = Class.forName("java.util.concurrent.Executors$DelegatedScheduledExecutorService");
        Field field = this._delegatedExecutorClass().getDeclaredField("e");
        field.setAccessible(true);
        this._delegatedExecutorField = var1_1;
        Field field2 = Class.forName("scala.concurrent.impl.ExecutionContextImpl").getDeclaredField("executor");
        field2.setAccessible(true);
        this._executionContextExecutorField = var2_2;
    }
}

