/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.ClaimsBuilder;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.CompressionCodecResolver;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.impl.DefaultClaims;
import io.jsonwebtoken.impl.DefaultClock;
import io.jsonwebtoken.impl.DefaultJwtParser;
import io.jsonwebtoken.impl.io.DelegateStringDecoder;
import io.jsonwebtoken.impl.lang.DefaultNestedCollection;
import io.jsonwebtoken.impl.lang.IdRegistry;
import io.jsonwebtoken.impl.lang.Services;
import io.jsonwebtoken.impl.security.ConstantKeyLocator;
import io.jsonwebtoken.io.CompressionAlgorithm;
import io.jsonwebtoken.io.Decoder;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.NestedCollection;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.security.AeadAlgorithm;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeyAlgorithm;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;

public class DefaultJwtParserBuilder
implements JwtParserBuilder {
    private static final int MILLISECONDS_PER_SECOND = 1000;
    static final long MAX_CLOCK_SKEW_MILLIS = 9223372036854775L;
    static final String MAX_CLOCK_SKEW_ILLEGAL_MSG = "Illegal allowedClockSkewMillis value: multiplying this value by 1000 to obtain the number of milliseconds would cause a numeric overflow.";
    private Provider provider;
    private boolean unsecured = false;
    private boolean unsecuredDecompression = false;
    private Locator<? extends Key> keyLocator;
    private SigningKeyResolver signingKeyResolver = null;
    private Registry<String, AeadAlgorithm> encAlgs = Jwts.ENC.get();
    private Registry<String, KeyAlgorithm<?, ?>> keyAlgs = Jwts.KEY.get();
    private Registry<String, SecureDigestAlgorithm<?, ?>> sigAlgs = Jwts.SIG.get();
    private Registry<String, CompressionAlgorithm> zipAlgs = Jwts.ZIP.get();
    private CompressionCodecResolver compressionCodecResolver;
    private Decoder<InputStream, InputStream> decoder = new DelegateStringDecoder((Decoder<CharSequence, byte[]>)Decoders.BASE64URL);
    private Deserializer<Map<String, ?>> deserializer;
    private final ClaimsBuilder expectedClaims = Jwts.claims();
    private Clock clock = DefaultClock.INSTANCE;
    private Set<String> critical = Collections.emptySet();
    private long allowedClockSkewMillis = 0L;
    private Key signatureVerificationKey;
    private Key decryptionKey;

    public JwtParserBuilder unsecured() {
        this.unsecured = true;
        return this;
    }

    public JwtParserBuilder unsecuredDecompression() {
        this.unsecuredDecompression = true;
        return this;
    }

    public JwtParserBuilder provider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public JwtParserBuilder deserializeJsonWith(Deserializer<Map<String, ?>> deserializer) {
        return this.json(deserializer);
    }

    public JwtParserBuilder json(Deserializer<Map<String, ?>> reader) {
        this.deserializer = (Deserializer)Assert.notNull(reader, (String)"JSON Deserializer cannot be null.");
        return this;
    }

    public JwtParserBuilder base64UrlDecodeWith(Decoder<CharSequence, byte[]> decoder) {
        Assert.notNull(decoder, (String)"decoder cannot be null.");
        return this.b64Url(new DelegateStringDecoder(decoder));
    }

    public JwtParserBuilder b64Url(Decoder<InputStream, InputStream> decoder) {
        Assert.notNull(decoder, (String)"decoder cannot be null.");
        this.decoder = decoder;
        return this;
    }

    public JwtParserBuilder requireIssuedAt(Date issuedAt) {
        this.expectedClaims.setIssuedAt(issuedAt);
        return this;
    }

    public JwtParserBuilder requireIssuer(String issuer) {
        this.expectedClaims.setIssuer(issuer);
        return this;
    }

    public JwtParserBuilder requireAudience(String audience) {
        ((NestedCollection)this.expectedClaims.audience().add((Object)audience)).and();
        return this;
    }

    public JwtParserBuilder requireSubject(String subject) {
        this.expectedClaims.setSubject(subject);
        return this;
    }

    public JwtParserBuilder requireId(String id) {
        this.expectedClaims.setId(id);
        return this;
    }

    public JwtParserBuilder requireExpiration(Date expiration) {
        this.expectedClaims.setExpiration(expiration);
        return this;
    }

    public JwtParserBuilder requireNotBefore(Date notBefore) {
        this.expectedClaims.setNotBefore(notBefore);
        return this;
    }

    public JwtParserBuilder require(String claimName, Object value) {
        Assert.hasText((CharSequence)claimName, (String)"claim name cannot be null or empty.");
        Assert.notNull((Object)value, (String)("The value cannot be null for claim name: " + claimName));
        this.expectedClaims.add((Object)claimName, value);
        return this;
    }

    public JwtParserBuilder setClock(Clock clock) {
        return this.clock(clock);
    }

    public JwtParserBuilder clock(Clock clock) {
        Assert.notNull((Object)clock, (String)"Clock instance cannot be null.");
        this.clock = clock;
        return this;
    }

    public NestedCollection<String, JwtParserBuilder> critical() {
        return new DefaultNestedCollection<String, JwtParserBuilder>((JwtParserBuilder)this, this.critical){

            @Override
            public JwtParserBuilder and() {
                DefaultJwtParserBuilder.this.critical = Collections.asSet(this.getCollection());
                return (JwtParserBuilder)super.and();
            }
        };
    }

    public JwtParserBuilder setAllowedClockSkewSeconds(long seconds) throws IllegalArgumentException {
        return this.clockSkewSeconds(seconds);
    }

    public JwtParserBuilder clockSkewSeconds(long seconds) throws IllegalArgumentException {
        Assert.isTrue((seconds <= 9223372036854775L ? 1 : 0) != 0, (String)MAX_CLOCK_SKEW_ILLEGAL_MSG);
        this.allowedClockSkewMillis = Math.max(0L, seconds * 1000L);
        return this;
    }

    public JwtParserBuilder setSigningKey(byte[] key) {
        Assert.notEmpty((byte[])key, (String)"signature verification key cannot be null or empty.");
        return this.setSigningKey(Keys.hmacShaKeyFor((byte[])key));
    }

    public JwtParserBuilder setSigningKey(String base64EncodedSecretKey) {
        Assert.hasText((CharSequence)base64EncodedSecretKey, (String)"signature verification key cannot be null or empty.");
        byte[] bytes = (byte[])Decoders.BASE64.decode((Object)base64EncodedSecretKey);
        return this.setSigningKey(bytes);
    }

    public JwtParserBuilder setSigningKey(Key key) {
        if (key instanceof SecretKey) {
            return this.verifyWith((SecretKey)key);
        }
        if (key instanceof PublicKey) {
            return this.verifyWith((PublicKey)key);
        }
        String msg = "JWS verification key must be either a SecretKey (for MAC algorithms) or a PublicKey (for Signature algorithms).";
        throw new InvalidKeyException(msg);
    }

    public JwtParserBuilder verifyWith(SecretKey key) {
        return this.verifyWith((Key)key);
    }

    public JwtParserBuilder verifyWith(PublicKey key) {
        return this.verifyWith((Key)key);
    }

    private JwtParserBuilder verifyWith(Key key) {
        if (key instanceof PrivateKey) {
            throw new IllegalArgumentException("PrivateKeys may not be used to verify digital signatures. PrivateKeys are used to sign, and PublicKeys are used to verify.");
        }
        this.signatureVerificationKey = (Key)Assert.notNull((Object)key, (String)"signature verification key cannot be null.");
        return this;
    }

    public JwtParserBuilder decryptWith(SecretKey key) {
        return this.decryptWith((Key)key);
    }

    public JwtParserBuilder decryptWith(PrivateKey key) {
        return this.decryptWith((Key)key);
    }

    private JwtParserBuilder decryptWith(Key key) {
        if (key instanceof PublicKey) {
            throw new IllegalArgumentException("PublicKeys may not be used to decrypt data. PublicKeys are used to encrypt, and PrivateKeys are used to decrypt.");
        }
        this.decryptionKey = (Key)Assert.notNull((Object)key, (String)"decryption key cannot be null.");
        return this;
    }

    public NestedCollection<CompressionAlgorithm, JwtParserBuilder> zip() {
        return new DefaultNestedCollection<CompressionAlgorithm, JwtParserBuilder>((JwtParserBuilder)this, this.zipAlgs.values()){

            @Override
            public JwtParserBuilder and() {
                DefaultJwtParserBuilder.this.zipAlgs = new IdRegistry("Compression Algorithm", this.getCollection());
                return (JwtParserBuilder)super.and();
            }
        };
    }

    public NestedCollection<AeadAlgorithm, JwtParserBuilder> enc() {
        return new DefaultNestedCollection<AeadAlgorithm, JwtParserBuilder>((JwtParserBuilder)this, this.encAlgs.values()){

            @Override
            public JwtParserBuilder and() {
                DefaultJwtParserBuilder.this.encAlgs = new IdRegistry("JWE Encryption Algorithm", this.getCollection());
                return (JwtParserBuilder)super.and();
            }
        };
    }

    public NestedCollection<SecureDigestAlgorithm<?, ?>, JwtParserBuilder> sig() {
        return new DefaultNestedCollection<SecureDigestAlgorithm<?, ?>, JwtParserBuilder>(this, this.sigAlgs.values()){

            @Override
            public JwtParserBuilder and() {
                DefaultJwtParserBuilder.this.sigAlgs = new IdRegistry("JWS Digital Signature or MAC", this.getCollection());
                return (JwtParserBuilder)super.and();
            }
        };
    }

    public NestedCollection<KeyAlgorithm<?, ?>, JwtParserBuilder> key() {
        return new DefaultNestedCollection<KeyAlgorithm<?, ?>, JwtParserBuilder>(this, this.keyAlgs.values()){

            @Override
            public JwtParserBuilder and() {
                DefaultJwtParserBuilder.this.keyAlgs = new IdRegistry("JWE Key Management Algorithm", this.getCollection());
                return (JwtParserBuilder)super.and();
            }
        };
    }

    public JwtParserBuilder setSigningKeyResolver(SigningKeyResolver signingKeyResolver) {
        Assert.notNull((Object)signingKeyResolver, (String)"SigningKeyResolver cannot be null.");
        this.signingKeyResolver = signingKeyResolver;
        return this;
    }

    public JwtParserBuilder keyLocator(Locator<Key> keyLocator) {
        this.keyLocator = (Locator)Assert.notNull(keyLocator, (String)"Key locator cannot be null.");
        return this;
    }

    public JwtParserBuilder setCompressionCodecResolver(CompressionCodecResolver resolver) {
        this.compressionCodecResolver = (CompressionCodecResolver)Assert.notNull((Object)resolver, (String)"CompressionCodecResolver cannot be null.");
        return this;
    }

    public JwtParser build() {
        Object keyLocator;
        if (this.deserializer == null) {
            this.json(Services.get(Deserializer.class));
        }
        if (this.signingKeyResolver != null && this.signatureVerificationKey != null) {
            String msg = "Both a 'signingKeyResolver and a 'verifyWith' key cannot be configured. Choose either, or prefer `keyLocator` when possible.";
            throw new IllegalStateException(msg);
        }
        if (this.keyLocator != null) {
            if (this.signatureVerificationKey != null) {
                String msg = "Both 'keyLocator' and a 'verifyWith' key cannot be configured. Prefer 'keyLocator' if possible.";
                throw new IllegalStateException(msg);
            }
            if (this.decryptionKey != null) {
                String msg = "Both 'keyLocator' and a 'decryptWith' key cannot be configured. Prefer 'keyLocator' if possible.";
                throw new IllegalStateException(msg);
            }
        }
        if ((keyLocator = this.keyLocator) == null) {
            keyLocator = new ConstantKeyLocator(this.signatureVerificationKey, this.decryptionKey);
        }
        if (!this.unsecured && this.unsecuredDecompression) {
            String msg = "'unsecuredDecompression' is only relevant if 'unsecured' is also configured. Please read the JavaDoc of both features before enabling either due to their security implications.";
            throw new IllegalStateException(msg);
        }
        if (this.compressionCodecResolver != null && !Jwts.ZIP.get().equals(this.zipAlgs)) {
            String msg = "Both 'zip()' and 'compressionCodecResolver' cannot be configured. Choose either.";
            throw new IllegalStateException(msg);
        }
        Assert.stateNotNull(keyLocator, (String)"Key locator should never be null.");
        DefaultClaims expClaims = (DefaultClaims)this.expectedClaims.build();
        return new DefaultJwtParser(this.provider, this.signingKeyResolver, this.unsecured, this.unsecuredDecompression, (Locator<? extends Key>)keyLocator, this.clock, this.critical, this.allowedClockSkewMillis, expClaims, this.decoder, this.deserializer, this.compressionCodecResolver, this.zipAlgs, this.sigAlgs, this.keyAlgs, this.encAlgs);
    }
}

