/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.redis;

import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.Session;
import io.jooby.SessionStore;
import io.jooby.SessionToken;
import io.jooby.SneakyThrows;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisSessionStore
implements SessionStore {
    private static final String LAST_ACCESSED_AT = "__accessed_at";
    private static final String CREATED_AT = "__created_at";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private SessionToken token = SessionToken.cookieId((Cookie)SessionToken.SID);
    private String namespace = "sessions";
    private Duration timeout = Duration.ofMinutes(30L);
    private GenericObjectPool<StatefulRedisConnection<String, String>> pool;

    public RedisSessionStore(@Nonnull GenericObjectPool<StatefulRedisConnection<String, String>> pool) {
        this.pool = pool;
    }

    public RedisSessionStore(@Nonnull RedisClient redis) {
        this((GenericObjectPool<StatefulRedisConnection<String, String>>)ConnectionPoolSupport.createGenericObjectPool(() -> redis.connect(), (GenericObjectPoolConfig)new GenericObjectPoolConfig()));
    }

    @Nonnull
    public String getNamespace() {
        return this.namespace;
    }

    @Nonnull
    public RedisSessionStore setNamespace(@Nonnull String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nonnull
    public Duration getTimeout() {
        return this.timeout;
    }

    @Nonnull
    public RedisSessionStore setTimeout(@Nonnull Duration timeout) {
        this.timeout = Optional.ofNullable(timeout).filter(t -> t.getSeconds() > 0L).orElse(null);
        return this;
    }

    @Nonnull
    public RedisSessionStore noTimeout() {
        this.timeout = null;
        return this;
    }

    @Nonnull
    public SessionToken getToken() {
        return this.token;
    }

    @Nonnull
    public RedisSessionStore setToken(@Nonnull SessionToken token) {
        this.token = token;
        return this;
    }

    @Nonnull
    public Session newSession(@Nonnull Context ctx) {
        String sessionId = this.token.newToken();
        Instant now = Instant.now();
        String isoNow = DateTimeFormatter.ISO_INSTANT.format(now);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(LAST_ACCESSED_AT, isoNow);
        data.put(CREATED_AT, isoNow);
        this.saveSession(sessionId, data);
        this.token.saveToken(ctx, sessionId);
        return Session.create((Context)ctx, (String)sessionId, new ConcurrentHashMap()).setLastAccessedTime(now).setCreationTime(now);
    }

    @Nullable
    public Session findSession(@Nonnull Context ctx) {
        String sessionId = this.token.findToken(ctx);
        if (sessionId == null) {
            return null;
        }
        return (Session)this.withConnection(connection -> {
            String redisId;
            RedisCommands commands = connection.sync();
            Map data = commands.hgetall((Object)(redisId = this.key(sessionId)));
            if (data == null || data.isEmpty()) {
                return null;
            }
            Optional.ofNullable(this.timeout).map(Duration::getSeconds).ifPresent(seconds -> commands.expire((Object)redisId, seconds.longValue()));
            Instant lastAccessedTime = Instant.parse((CharSequence)data.remove(LAST_ACCESSED_AT));
            Instant createdAt = Instant.parse((CharSequence)data.remove(CREATED_AT));
            this.token.saveToken(ctx, sessionId);
            return Session.create((Context)ctx, (String)sessionId, new ConcurrentHashMap(data)).setCreationTime(createdAt).setLastAccessedTime(lastAccessedTime);
        });
    }

    public void deleteSession(@Nonnull Context ctx, @Nonnull Session session) {
        String sessionId = session.getId();
        this.withConnection(connection -> connection.async().del(new Object[]{this.key(sessionId)}));
        this.token.deleteToken(ctx, sessionId);
    }

    public void touchSession(@Nonnull Context ctx, @Nonnull Session session) {
        this.saveSession(ctx, session);
        this.token.saveToken(ctx, session.getId());
    }

    public void saveSession(@Nonnull Context ctx, @Nonnull Session session) {
        this.saveSession(session.getId(), new HashMap<String, String>(session.toMap()));
    }

    public void renewSessionId(@Nonnull Context ctx, @Nonnull Session session) {
    }

    private void saveSession(String sessionId, Map<String, String> data) {
        this.withConnection(connection -> {
            Instant now = Instant.now();
            String isoNow = DateTimeFormatter.ISO_INSTANT.format(now);
            data.put(LAST_ACCESSED_AT, isoNow);
            data.put(CREATED_AT, isoNow);
            RedisAsyncCommands commands = connection.async();
            String redisId = this.key(sessionId);
            commands.multi();
            commands.del((Object[])new String[]{redisId});
            commands.hset((Object)redisId, data);
            return commands.exec().handle((value, cause) -> {
                if (cause != null) {
                    this.log.error("unable to create session: {}", (Object)sessionId, cause);
                    return sessionId;
                }
                Optional.ofNullable(this.timeout).map(Duration::getSeconds).ifPresent(seconds -> commands.expire((Object)redisId, seconds.longValue()));
                return value;
            });
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T withConnection(SneakyThrows.Function<StatefulRedisConnection, T> callback) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            Object object = callback.apply((Object)connection);
            return (T)object;
        }
        catch (Exception cause) {
            throw SneakyThrows.propagate((Throwable)cause);
        }
    }

    private String key(String id) {
        return this.namespace + ":" + id;
    }
}

