/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.redis;

import com.typesafe.config.Config;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class RedisModule
implements Extension {
    private String name;
    private RedisURI uri;

    public RedisModule(@Nonnull String value) {
        try {
            this.uri = RedisURI.create((String)value);
            this.name = "redis";
        }
        catch (IllegalArgumentException x) {
            this.name = value;
        }
    }

    public RedisModule() {
        this("redis");
    }

    public void install(@Nonnull Jooby application) throws Exception {
        if (this.uri == null) {
            Config config = application.getConfig();
            this.uri = Stream.of(this.name + ".uri", this.name).filter(arg_0 -> ((Config)config).hasPath(arg_0)).map(arg_0 -> ((Config)config).getString(arg_0)).map(RedisURI::create).findFirst().orElseThrow(() -> new IllegalStateException("Redis uri missing from application configuration: " + this.name));
        }
        RedisClient client = RedisClient.create((RedisURI)this.uri);
        StatefulRedisConnection connection = client.connect();
        StatefulRedisPubSubConnection connectPubSub = client.connectPubSub();
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        GenericObjectPool pool = ConnectionPoolSupport.createGenericObjectPool(() -> client.connect(), (GenericObjectPoolConfig)poolConfig);
        application.onStop(() -> ((GenericObjectPool)pool).close());
        application.onStop(() -> ((StatefulRedisConnection)connection).close());
        application.onStop(() -> ((StatefulRedisPubSubConnection)connectPubSub).close());
        application.onStop(() -> ((RedisClient)client).shutdown());
        ServiceRegistry registry = application.getServices();
        registry.putIfAbsent(ServiceKey.key(RedisClient.class), (Object)client);
        registry.put(ServiceKey.key(RedisClient.class, (String)this.name), (Object)client);
        registry.putIfAbsent(ServiceKey.key(StatefulRedisConnection.class), (Object)connection);
        registry.put(ServiceKey.key(StatefulRedisConnection.class, (String)this.name), (Object)connection);
        registry.putIfAbsent(ServiceKey.key(GenericObjectPool.class), (Object)pool);
        registry.put(ServiceKey.key(GenericObjectPool.class, (String)this.name), (Object)pool);
        registry.putIfAbsent(ServiceKey.key(StatefulRedisPubSubConnection.class), (Object)connectPubSub);
        registry.put(ServiceKey.key(StatefulRedisPubSubConnection.class, (String)this.name), (Object)connectPubSub);
    }
}

