/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.jetty;

import com.typesafe.config.Config;
import io.jooby.Http2Configurer;
import io.jooby.Jooby;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.SneakyThrows;
import io.jooby.SslOptions;
import io.jooby.internal.jetty.JettyHandler;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.MultiPartFormDataCompliance;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;

public class Jetty
extends Server.Base {
    private static final int THREADS = 200;
    private org.eclipse.jetty.server.Server server;
    private List<Jooby> applications = new ArrayList<Jooby>();
    private ServerOptions options = new ServerOptions().setServer("jetty").setWorkerThreads(200);

    @Nonnull
    public Jetty setOptions(@Nonnull ServerOptions options) {
        this.options = options.setWorkerThreads(options.getWorkerThreads(200));
        return this;
    }

    @Nonnull
    public ServerOptions getOptions() {
        return this.options;
    }

    @Nonnull
    public Server start(Jooby application) {
        try {
            System.setProperty("org.eclipse.jetty.util.UrlEncoded.charset", "utf-8");
            System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", Long.toString(this.options.getMaxRequestSize()));
            this.applications.add(application);
            this.addShutdownHook();
            QueuedThreadPool executor = new QueuedThreadPool(this.options.getWorkerThreads());
            executor.setName("worker");
            this.fireStart(this.applications, (Executor)executor);
            this.server = new org.eclipse.jetty.server.Server((ThreadPool)executor);
            this.server.setStopAtShutdown(false);
            Http2Configurer http2 = this.options.isHttp2() == null || this.options.isHttp2() == Boolean.TRUE ? (Http2Configurer)StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(Http2Configurer.class).iterator(), 16), false).filter(it -> it.support(HttpConfiguration.class)).findFirst().orElse(null) : null;
            HttpConfiguration httpConf = new HttpConfiguration();
            httpConf.setOutputBufferSize(this.options.getBufferSize());
            httpConf.setOutputAggregationSize(this.options.getBufferSize());
            httpConf.setSendXPoweredBy(false);
            httpConf.setSendDateHeader(this.options.getDefaultHeaders());
            httpConf.setSendServerVersion(false);
            httpConf.setMultiPartFormDataCompliance(MultiPartFormDataCompliance.RFC7578);
            ArrayList<HttpConnectionFactory> connectionFactories = new ArrayList<HttpConnectionFactory>();
            connectionFactories.add(new HttpConnectionFactory(httpConf));
            Optional.ofNullable(http2).ifPresent(extension -> connectionFactories.addAll((Collection)extension.configure((Object)httpConf)));
            if (!this.options.isHttpsOnly()) {
                ServerConnector http = new ServerConnector(this.server, connectionFactories.toArray(new ConnectionFactory[0]));
                http.setPort(this.options.getPort());
                http.setHost(this.options.getHost());
                this.server.addConnector((Connector)http);
            }
            if (this.options.isSSLEnabled()) {
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                sslContextFactory.setSslContext(this.options.getSSLContext(application.getEnvironment().getClassLoader()));
                List protocol = this.options.getSsl().getProtocol();
                sslContextFactory.setIncludeProtocols(protocol.toArray(new String[0]));
                this.isNotInUse(protocol, "TLSv1", xva$0 -> sslContextFactory.addExcludeProtocols(new String[]{xva$0}));
                this.isNotInUse(protocol, "TLSv1.1", xva$0 -> sslContextFactory.addExcludeProtocols(new String[]{xva$0}));
                SslOptions.ClientAuth clientAuth = Optional.ofNullable(this.options.getSsl()).map(SslOptions::getClientAuth).orElse(SslOptions.ClientAuth.NONE);
                if (clientAuth == SslOptions.ClientAuth.REQUESTED) {
                    sslContextFactory.setWantClientAuth(true);
                } else if (clientAuth == SslOptions.ClientAuth.REQUIRED) {
                    sslContextFactory.setNeedClientAuth(true);
                }
                HttpConfiguration httpsConf = new HttpConfiguration(httpConf);
                httpsConf.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                ArrayList<Object> secureConnectionFactories = new ArrayList<Object>();
                if (http2 == null) {
                    secureConnectionFactories.add(new SslConnectionFactory((SslContextFactory)sslContextFactory, "http/1.1"));
                } else {
                    secureConnectionFactories.add(new SslConnectionFactory((SslContextFactory)sslContextFactory, "alpn"));
                    ((List)http2.configure((Object)httpsConf)).forEach(secureConnectionFactories::add);
                }
                secureConnectionFactories.add(new HttpConnectionFactory(httpsConf));
                ServerConnector secureConnector = new ServerConnector(this.server, secureConnectionFactories.toArray(new ConnectionFactory[0]));
                secureConnector.setPort(this.options.getSecurePort().intValue());
                secureConnector.setHost(this.options.getHost());
                this.server.addConnector((Connector)secureConnector);
            } else if (this.options.isHttpsOnly()) {
                throw new IllegalArgumentException("Server configured for httpsOnly, but ssl options not set");
            }
            ContextHandler context = new ContextHandler();
            JettyHandler handler = new JettyHandler((Router)this.applications.get(0), this.options.getBufferSize(), this.options.getMaxRequestSize(), this.options.getDefaultHeaders());
            if (this.options.getCompressionLevel() != null) {
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setCompressionLevel(this.options.getCompressionLevel().intValue());
                gzipHandler.setHandler((Handler)handler);
                context.setHandler((Handler)gzipHandler);
            } else {
                context.setHandler((Handler)handler);
            }
            Config conf = application.getConfig();
            int maxSize = conf.hasPath("websocket.maxSize") ? conf.getBytes("websocket.maxSize").intValue() : 131072;
            context.setAttribute(DecoratedObjectFactory.ATTR, (Object)new DecoratedObjectFactory());
            WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
            policy.setMaxTextMessageBufferSize(maxSize);
            policy.setMaxTextMessageSize(maxSize);
            long timeout = conf.hasPath("websocket.idleTimeout") ? conf.getDuration("websocket.idleTimeout", TimeUnit.MILLISECONDS) : TimeUnit.MINUTES.toMillis(5L);
            policy.setIdleTimeout(timeout);
            WebSocketServerFactory wssf = new WebSocketServerFactory((ServletContext)context.getServletContext(), policy);
            context.setAttribute("___ws_s_f_", (Object)wssf);
            context.addManaged((LifeCycle)wssf);
            this.server.setHandler((Handler)context);
            this.server.start();
            this.fireReady(this.applications);
        }
        catch (Exception x2) {
            BindException x2;
            if (Server.isAddressInUse((Throwable)x2.getCause())) {
                x2 = new BindException("Address already in use: " + this.options.getPort());
            }
            throw SneakyThrows.propagate((Throwable)x2);
        }
        return this;
    }

    private void isNotInUse(List<String> protocols, String protocol, Consumer<String> consumer) {
        if (!protocols.contains(protocol)) {
            consumer.accept(protocol);
        }
    }

    @Nonnull
    public synchronized Server stop() {
        this.fireStop(this.applications);
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception x) {
                throw SneakyThrows.propagate((Throwable)x);
            }
            finally {
                this.server = null;
            }
        }
        return this;
    }

    static {
        System.setProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.Slf4jLog");
    }
}

