/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.jetty;

import io.jooby.StatusCode;
import io.jooby.exception.StatusCodeException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private long maxSize;
    private long count;

    public LimitedInputStream(InputStream pIn, long maxSize) {
        super(pIn);
        this.maxSize = maxSize;
    }

    private void checkLimit() {
        if (this.count > this.maxSize) {
            throw new StatusCodeException(StatusCode.REQUEST_ENTITY_TOO_LARGE);
        }
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            ++this.count;
            this.checkLimit();
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res > 0) {
            this.count += (long)res;
            this.checkLimit();
        }
        return res;
    }
}

