/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.propagation;

import io.jaegertracing.internal.JaegerObjectFactory;
import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.internal.exceptions.EmptyTracerStateStringException;
import io.jaegertracing.internal.exceptions.MalformedTracerStateStringException;
import io.jaegertracing.internal.exceptions.TraceIdOutOfBoundException;
import io.jaegertracing.internal.propagation.PrefixedKeys;
import io.jaegertracing.internal.utils.Utils;
import io.jaegertracing.spi.Codec;
import io.opentracing.propagation.TextMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextMapCodec
implements Codec<TextMap> {
    private static final Logger log = LoggerFactory.getLogger(TextMapCodec.class);
    private static final String SPAN_CONTEXT_KEY = "uber-trace-id";
    private static final String BAGGAGE_KEY_PREFIX = "uberctx-";
    private static final PrefixedKeys keys = new PrefixedKeys();
    private final String contextKey;
    private final String baggagePrefix;
    private final boolean urlEncoding;
    private final JaegerObjectFactory objectFactory;

    public TextMapCodec(boolean urlEncoding) {
        this(TextMapCodec.builder().withUrlEncoding(urlEncoding));
    }

    private TextMapCodec(Builder builder) {
        this.urlEncoding = builder.urlEncoding;
        this.contextKey = builder.spanContextKey;
        this.baggagePrefix = builder.baggagePrefix;
        this.objectFactory = builder.objectFactory;
    }

    static JaegerSpanContext contextFromString(String value) throws MalformedTracerStateStringException, EmptyTracerStateStringException {
        if (value == null || value.isEmpty()) {
            throw new EmptyTracerStateStringException();
        }
        int traceIdEnd = value.indexOf(58);
        if (traceIdEnd == -1) {
            throw new MalformedTracerStateStringException(value);
        }
        if (traceIdEnd > 32 || traceIdEnd == 0) {
            throw new TraceIdOutOfBoundException("Trace id [" + value.substring(0, traceIdEnd) + "] length is not within 1 and 32");
        }
        int lowTraceIdStart = Math.max(0, traceIdEnd - 16);
        long high = lowTraceIdStart == 0 ? 0L : TextMapCodec.hexToUnsignedLong("trace ID high part", value, 0, lowTraceIdStart);
        long low = TextMapCodec.hexToUnsignedLong("trace ID low part", value, lowTraceIdStart, traceIdEnd);
        int spanIdEnd = value.indexOf(58, traceIdEnd + 1);
        if (spanIdEnd == -1) {
            throw new MalformedTracerStateStringException(value);
        }
        long spanId = TextMapCodec.hexToUnsignedLong("span ID", value, traceIdEnd + 1, spanIdEnd);
        int parentIdEnd = value.indexOf(58, spanIdEnd + 1);
        if (parentIdEnd == -1) {
            throw new MalformedTracerStateStringException(value);
        }
        long parentId = TextMapCodec.hexToUnsignedLong("parent ID", value, spanIdEnd + 1, parentIdEnd);
        byte flags = (byte)TextMapCodec.hexToUnsignedLong("flags", value, parentIdEnd + 1, value.length());
        return new JaegerSpanContext(high, low, spanId, parentId, flags);
    }

    private static long hexToUnsignedLong(String label, String value, int beginIndex, int endIndex) {
        if (beginIndex >= endIndex) {
            throw new MalformedTracerStateStringException("Empty " + label + " in context string " + value);
        }
        long result = 0L;
        while (beginIndex < endIndex) {
            char c = value.charAt(beginIndex);
            result <<= 4;
            if (c >= '0' && c <= '9') {
                result |= (long)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                result |= (long)(c - 97 + 10);
            } else {
                throw new MalformedTracerStateStringException("Failed to parse " + label + " in context string " + value + ", '" + c + "' is not a legal hex character expecting only 0-9 and a-f");
            }
            ++beginIndex;
        }
        return result;
    }

    public static String contextAsString(JaegerSpanContext context) {
        return context.getTraceId() + ":" + context.toSpanId() + ":" + (context.getParentId() == 0L ? "0" : Utils.to16HexString(context.getParentId())) + ":" + Integer.toHexString(context.getFlags() & 0xFF);
    }

    @Override
    public void inject(JaegerSpanContext spanContext, TextMap carrier) {
        carrier.put(this.contextKey, TextMapCodec.contextAsString(spanContext));
        for (Map.Entry<String, String> entry : spanContext.baggageItems()) {
            carrier.put(keys.prefixedKey(entry.getKey(), this.baggagePrefix), this.encodedValue(entry.getValue()));
        }
    }

    @Override
    public JaegerSpanContext extract(TextMap carrier) {
        JaegerSpanContext context = null;
        Map<String, String> baggage = null;
        String debugId = null;
        for (Map.Entry entry : carrier) {
            String key = (String)entry.getKey();
            if (key.equalsIgnoreCase(this.contextKey)) {
                context = TextMapCodec.contextFromString(this.decodedValue((String)entry.getValue()));
                continue;
            }
            if (key.equalsIgnoreCase("jaeger-debug-id")) {
                debugId = this.decodedValue((String)entry.getValue());
                continue;
            }
            if (key.regionMatches(true, 0, this.baggagePrefix, 0, this.baggagePrefix.length())) {
                if (baggage == null) {
                    baggage = new HashMap<String, String>();
                }
                baggage.put(keys.unprefixedKey(key.toLowerCase(Locale.ROOT), this.baggagePrefix), this.decodedValue((String)entry.getValue()));
                continue;
            }
            if (!key.equalsIgnoreCase("jaeger-baggage")) continue;
            baggage = this.parseBaggageHeader(this.decodedValue((String)entry.getValue()), baggage);
        }
        if (debugId == null && baggage == null) {
            return context;
        }
        return this.objectFactory.createSpanContext(context == null ? 0L : context.getTraceIdHigh(), context == null ? 0L : context.getTraceIdLow(), context == null ? 0L : context.getSpanId(), context == null ? 0L : context.getParentId(), context == null ? (byte)0 : context.getFlags(), baggage, debugId);
    }

    private Map<String, String> parseBaggageHeader(String header, Map<String, String> baggage) {
        for (String part : header.split("\\s*,\\s*")) {
            String[] kv = part.split("\\s*=\\s*");
            if (kv.length == 2) {
                if (baggage == null) {
                    baggage = new HashMap<String, String>();
                }
                baggage.put(kv[0], kv[1]);
                continue;
            }
            log.debug("malformed token in {} header: {}", (Object)"jaeger-baggage", (Object)part);
        }
        return baggage;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("TextMapCodec{").append("contextKey=").append(this.contextKey).append(',').append("baggagePrefix=").append(this.baggagePrefix).append(',').append("urlEncoding=").append(this.urlEncoding).append('}');
        return buffer.toString();
    }

    private String encodedValue(String value) {
        if (!this.urlEncoding) {
            return value;
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private String decodedValue(String value) {
        if (!this.urlEncoding) {
            return value;
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean urlEncoding;
        private String spanContextKey = "uber-trace-id";
        private String baggagePrefix = "uberctx-";
        private JaegerObjectFactory objectFactory = new JaegerObjectFactory();

        public Builder withUrlEncoding(boolean urlEncoding) {
            this.urlEncoding = urlEncoding;
            return this;
        }

        public Builder withSpanContextKey(String spanContextKey) {
            this.spanContextKey = spanContextKey;
            return this;
        }

        public Builder withBaggagePrefix(String baggagePrefix) {
            this.baggagePrefix = baggagePrefix;
            return this;
        }

        public Builder withObjectFactory(JaegerObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
            return this;
        }

        public TextMapCodec build() {
            return new TextMapCodec(this);
        }
    }
}

