/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.util;

import jakarta.jms.JMSException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.BufferInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.stomp.client.Constants;
import org.fusesource.stomp.codec.StompFrame;
import org.fusesource.stomp.jms.message.StompJmsBytesMessage;
import org.fusesource.stomp.jms.message.StompJmsMapMessage;
import org.fusesource.stomp.jms.message.StompJmsMessage;
import org.fusesource.stomp.jms.message.StompJmsObjectMessage;
import org.fusesource.stomp.jms.message.StompJmsStreamMessage;
import org.fusesource.stomp.jms.message.StompJmsTextMessage;
import org.fusesource.stomp.jms.util.ClassLoadingAwareObjectInputStream;

public class StompTranslator {
    public static Object readObjectFromBuffer(Buffer buffer) throws JMSException {
        try {
            BufferInputStream bufferIn = new BufferInputStream(buffer);
            ClassLoadingAwareObjectInputStream is = new ClassLoadingAwareObjectInputStream((InputStream)bufferIn);
            return is.readObject();
        }
        catch (Exception e) {
            throw new JMSException("Could not decode: " + e);
        }
    }

    public static Buffer writeBufferFromObject(Object object) throws JMSException {
        try {
            DataByteArrayOutputStream buffer = new DataByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream((OutputStream)buffer);
            out.writeObject(object);
            out.close();
            return buffer.toBuffer();
        }
        catch (IOException e) {
            throw new JMSException("Could not encode: " + e);
        }
    }

    public static StompJmsMessage convert(StompFrame frame) throws JMSException {
        String contentType;
        Map<AsciiBuffer, AsciiBuffer> headers = frame.headerMap(StompJmsMessage.REVERSED_HEADER_NAMES);
        AsciiBuffer type = headers.get(Constants.TRANSFORMATION);
        if (type != null) {
            switch (StompJmsMessage.JmsMsgType.valueOf(type.toString())) {
                case BYTES: {
                    return new StompJmsBytesMessage();
                }
                case TEXT: {
                    return new StompJmsTextMessage();
                }
                case TEXT_NULL: {
                    return new StompJmsTextMessage();
                }
                case MAP: {
                    return new StompJmsMapMessage();
                }
                case OBJECT: {
                    return new StompJmsObjectMessage();
                }
                case STREAM: {
                    return new StompJmsStreamMessage();
                }
                case MESSAGE: {
                    return new StompJmsMessage();
                }
            }
        }
        if ((type = headers.get(Constants.CONTENT_TYPE)) != null && ((contentType = type.ascii().toString()).startsWith("text") || contentType.endsWith("json") || contentType.endsWith("xml"))) {
            return new StompJmsTextMessage();
        }
        return new StompJmsBytesMessage();
    }

    public static String toString(AsciiBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }
}

