/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.message;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.stomp.client.Constants;
import org.fusesource.stomp.codec.StompFrame;
import org.fusesource.stomp.jms.StompJmsConnection;
import org.fusesource.stomp.jms.StompJmsDestination;
import org.fusesource.stomp.jms.StompJmsExceptionSupport;
import org.fusesource.stomp.jms.message.StompJmsMessageTransformation;
import org.fusesource.stomp.jms.util.PropertyExpression;
import org.fusesource.stomp.jms.util.TypeConversionSupport;

public class StompJmsMessage
implements Message {
    private static final Map<String, PropertySetter> JMS_PROPERTY_SETERS = new HashMap<String, PropertySetter>();
    static HashSet<AsciiBuffer> RESERVED_HEADER_NAMES = new HashSet();
    public static HashSet<AsciiBuffer> REVERSED_HEADER_NAMES;
    protected transient Callable<Void> acknowledgeCallback;
    protected transient StompJmsConnection connection;
    protected boolean readOnlyBody;
    protected boolean readOnlyProperties;
    protected Map<String, Object> properties;
    protected AsciiBuffer transactionId;
    protected StompFrame frame = new StompFrame(Constants.MESSAGE);

    public StompJmsMessage() {
        this.getHeaderMap().put(Constants.TRANSFORMATION, this.getMsgType().buffer);
    }

    public StompJmsMessage copy() throws JMSException {
        StompJmsMessage other = new StompJmsMessage();
        other.copy(this);
        return other;
    }

    public JmsMsgType getMsgType() {
        return JmsMsgType.MESSAGE;
    }

    public StompFrame getFrame() {
        return this.frame;
    }

    public void setFrame(StompFrame frame) {
        this.frame = frame;
    }

    protected void copy(StompJmsMessage other) {
        this.readOnlyBody = other.readOnlyBody;
        this.readOnlyProperties = other.readOnlyBody;
        this.properties = other.properties != null ? new HashMap<String, Object>(other.properties) : null;
        this.frame = other.frame.clone();
        this.acknowledgeCallback = other.acknowledgeCallback;
        this.transactionId = other.transactionId;
        this.connection = other.connection;
    }

    public int hashCode() {
        String id = this.getJMSMessageID();
        if (id != null) {
            return id.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        StompJmsMessage msg = (StompJmsMessage)o;
        String oMsg = msg.getJMSMessageID();
        String thisMsg = this.getJMSMessageID();
        return thisMsg != null && oMsg != null && oMsg.equals(thisMsg);
    }

    public void acknowledge() throws JMSException {
        if (this.acknowledgeCallback != null) {
            try {
                this.acknowledgeCallback.call();
            }
            catch (Throwable e) {
                throw StompJmsExceptionSupport.create(e);
            }
        }
    }

    public Buffer getContent() {
        Buffer content = this.frame.content();
        if (content.isEmpty()) {
            return null;
        }
        return content;
    }

    public void setContent(Buffer content) {
        if (content == null) {
            this.frame.content(StompFrame.NO_DATA);
        } else {
            this.frame.content(content);
        }
    }

    public void clearBody() throws JMSException {
        if (this.frame != null) {
            this.frame.content(StompFrame.NO_DATA);
        }
        this.setContent(null);
        this.readOnlyBody = false;
    }

    public void setReadOnlyBody(boolean readOnlyBody) {
        this.readOnlyBody = readOnlyBody;
    }

    public void setReadOnlyProperties(boolean readOnlyProperties) {
        this.readOnlyProperties = readOnlyProperties;
    }

    private String getStringHeader(AsciiBuffer key) {
        AsciiBuffer buffer = this.getHeaderMap().get(key);
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }

    private void setStringHeader(AsciiBuffer key, String value) {
        if (value == null) {
            this.getHeaderMap().remove(key);
        } else {
            this.getHeaderMap().put(key, Buffer.ascii((String)value));
        }
    }

    private byte[] getBytesHeader(AsciiBuffer key) {
        AsciiBuffer buffer = this.getHeaderMap().get(key);
        if (buffer == null) {
            return null;
        }
        return buffer.deepCopy().data;
    }

    private void setBytesHeader(AsciiBuffer key, byte[] value) {
        if (value == null) {
            this.getHeaderMap().remove(key);
        } else {
            this.getHeaderMap().put(key, new Buffer(value).deepCopy().ascii());
        }
    }

    private Integer getIntegerHeader(AsciiBuffer key) {
        AsciiBuffer buffer = this.getHeaderMap().get(key);
        if (buffer == null) {
            return null;
        }
        return Integer.parseInt(buffer.toString());
    }

    private void setIntegerHeader(AsciiBuffer key, Integer value) {
        if (value == null) {
            this.getHeaderMap().remove(key);
        } else {
            this.getHeaderMap().put(key, Buffer.ascii((String)value.toString()));
        }
    }

    private Long getLongHeader(AsciiBuffer key) {
        AsciiBuffer buffer = this.getHeaderMap().get(key);
        if (buffer == null) {
            return null;
        }
        return Long.parseLong(buffer.toString());
    }

    private void setLongHeader(AsciiBuffer key, Long value) {
        if (value == null) {
            this.getHeaderMap().remove(key);
        } else {
            this.getHeaderMap().put(key, Buffer.ascii((String)value.toString()));
        }
    }

    private Boolean getBooleanHeader(AsciiBuffer key) {
        AsciiBuffer buffer = this.getHeaderMap().get(key);
        if (buffer == null) {
            return null;
        }
        return Boolean.parseBoolean(buffer.toString());
    }

    private void setBooleanHeader(AsciiBuffer key, Boolean value) {
        if (value == null) {
            this.getHeaderMap().remove(key);
        } else {
            this.getHeaderMap().put(key, value != false ? Constants.TRUE : Constants.FALSE);
        }
    }

    private StompJmsDestination getDestinationHeader(AsciiBuffer key) throws JMSException {
        AsciiBuffer buffer = this.getHeaderMap().get(key);
        if (buffer == null) {
            return null;
        }
        return StompJmsDestination.createDestination(this.connection, buffer.toString());
    }

    private void setDestinationHeader(AsciiBuffer key, StompJmsDestination value) {
        if (value == null) {
            this.getHeaderMap().remove(key);
        } else {
            this.getHeaderMap().put(key, Buffer.ascii((String)value.toString()));
        }
    }

    public AsciiBuffer getMessageID() {
        return this.getHeaderMap().get(Constants.MESSAGE_ID);
    }

    public String getJMSMessageID() {
        return this.getStringHeader(Constants.MESSAGE_ID);
    }

    public void setJMSMessageID(String value) {
        this.setStringHeader(Constants.MESSAGE_ID, value);
    }

    public void setMessageID(AsciiBuffer value) {
        this.getHeaderMap().put(Constants.MESSAGE_ID, value);
    }

    private <T> T or(T value, T other) {
        if (value != null) {
            return value;
        }
        return other;
    }

    public long getJMSTimestamp() {
        return this.or(this.getLongHeader(Constants.TIMESTAMP), 0L);
    }

    public void setJMSTimestamp(long timestamp) {
        this.setLongHeader(Constants.TIMESTAMP, timestamp == 0L ? null : Long.valueOf(timestamp));
    }

    public String getJMSCorrelationID() {
        return this.getStringHeader(Constants.CORRELATION_ID);
    }

    public void setJMSCorrelationID(String correlationId) {
        this.setStringHeader(Constants.CORRELATION_ID, correlationId);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.getBytesHeader(Constants.CORRELATION_ID);
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationId) throws JMSException {
        this.setBytesHeader(Constants.CORRELATION_ID, correlationId);
    }

    public boolean isPersistent() {
        return this.or(this.getBooleanHeader(Constants.PERSISTENT), false);
    }

    public void setPersistent(boolean value) {
        this.setBooleanHeader(Constants.PERSISTENT, value ? Boolean.valueOf(true) : null);
    }

    protected static String decodeString(byte[] data) throws JMSException {
        try {
            if (data == null) {
                return null;
            }
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JMSException("Invalid UTF-8 encoding: " + e.getMessage());
        }
    }

    protected static byte[] encodeString(String data) throws JMSException {
        try {
            if (data == null) {
                return null;
            }
            return data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JMSException("Invalid UTF-8 encoding: " + e.getMessage());
        }
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.getStompJmsReplyTo();
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        this.setJMSReplyTo(StompJmsMessageTransformation.transformDestination(this.connection, destination));
    }

    public void setJMSReplyTo(StompJmsDestination destination) {
        this.setDestinationHeader(Constants.REPLY_TO, destination);
    }

    public StompJmsDestination getStompJmsReplyTo() throws JMSException {
        return this.getDestinationHeader(Constants.REPLY_TO);
    }

    public Destination getJMSDestination() throws JMSException {
        return this.getStompJmsDestination();
    }

    public StompJmsDestination getStompJmsDestination() throws JMSException {
        return this.getDestinationHeader(Constants.DESTINATION);
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.setJMSDestination(StompJmsMessageTransformation.transformDestination(this.connection, destination));
    }

    public void setJMSDestination(StompJmsDestination destination) {
        this.setDestinationHeader(Constants.DESTINATION, destination);
    }

    public int getJMSDeliveryMode() {
        return this.isPersistent() ? 2 : 1;
    }

    public void setJMSDeliveryMode(int mode) {
        this.setPersistent(mode == 2);
    }

    public boolean isRedelivered() {
        return this.getRedeliveryCounter() > 0;
    }

    public void setRedelivered(boolean redelivered) {
        if (redelivered) {
            if (!this.isRedelivered()) {
                this.setRedeliveryCounter(1);
            }
        } else if (this.isRedelivered()) {
            this.setRedeliveryCounter(0);
        }
    }

    public int getRedeliveryCounter() {
        AsciiBuffer value = this.getHeaderMap().get(Constants.JMSX_DELIVERY_COUNT);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value.toString());
    }

    public void setRedeliveryCounter(int deliveryCounter) {
        this.getHeaderMap().put(Constants.JMSX_DELIVERY_COUNT, StompFrame.encodeHeader("" + deliveryCounter));
    }

    public boolean getJMSRedelivered() {
        return this.isRedelivered();
    }

    public void setJMSRedelivered(boolean redelivered) {
        this.setRedelivered(redelivered);
    }

    public String getJMSType() {
        return this.getStringHeader(Constants.TYPE);
    }

    public void setJMSType(String type) {
        this.setStringHeader(Constants.TYPE, type);
    }

    public long getJMSExpiration() {
        return this.or(this.getLongHeader(Constants.EXPIRATION_TIME), 0L);
    }

    public void setJMSExpiration(long expiration) {
        this.setLongHeader(Constants.EXPIRATION_TIME, expiration == 0L ? null : Long.valueOf(expiration));
    }

    public int getJMSPriority() {
        return this.or(this.getIntegerHeader(Constants.PRIORITY), 4);
    }

    public void setJMSPriority(int priority) {
        this.setIntegerHeader(Constants.PRIORITY, priority == 4 ? null : Integer.valueOf(priority));
    }

    public Map<String, Object> getProperties() throws IOException {
        this.lazyCreateProperties();
        return Collections.unmodifiableMap(this.properties);
    }

    public void clearProperties() {
        if (this.frame != null) {
            this.getHeaderMap().clear();
        }
        this.properties = null;
    }

    public void setProperty(String name, Object value) throws IOException {
        this.lazyCreateProperties();
        this.properties.put(name, value);
        this.getHeaderMap().put(StompFrame.encodeHeader(name), StompFrame.encodeHeader(value.toString()));
    }

    public void removeProperty(String name) throws IOException {
        this.lazyCreateProperties();
        this.properties.remove(name);
    }

    protected void lazyCreateProperties() throws IOException {
        if (this.properties == null) {
            if (this.frame != null) {
                this.properties = new HashMap<String, Object>(this.getHeaderMap().size());
                for (Map.Entry<AsciiBuffer, AsciiBuffer> entry : this.getHeaderMap().entrySet()) {
                    if (RESERVED_HEADER_NAMES.contains(entry.getKey())) continue;
                    this.properties.put(StompFrame.decodeHeader((Buffer)entry.getKey()), StompFrame.decodeHeader((Buffer)entry.getValue()));
                }
            } else {
                this.properties = new HashMap<String, Object>();
            }
        }
    }

    public boolean propertyExists(String name) throws JMSException {
        try {
            return this.getProperties().containsKey(name) || this.getObjectProperty(name) != null;
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.create(e);
        }
    }

    public Enumeration getPropertyNames() throws JMSException {
        try {
            Vector<String> result = new Vector<String>(this.getProperties().keySet());
            return result.elements();
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.create(e);
        }
    }

    public Enumeration getAllPropertyNames() throws JMSException {
        try {
            Vector<String> result = new Vector<String>(this.getProperties().keySet());
            result.addAll(JMS_PROPERTY_SETERS.keySet());
            return result.elements();
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.create(e);
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.setObjectProperty(name, value, true);
    }

    public void setObjectProperty(String name, Object value, boolean checkReadOnly) throws JMSException {
        if (checkReadOnly) {
            this.checkReadOnlyProperties();
        }
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Property name cannot be empty or null");
        }
        this.checkValidObject(value);
        PropertySetter setter = JMS_PROPERTY_SETERS.get(name);
        if (setter != null && value != null) {
            setter.set(this.connection, this, value);
        } else {
            try {
                this.setProperty(name, value);
            }
            catch (IOException e) {
                throw StompJmsExceptionSupport.create(e);
            }
        }
    }

    public void setProperties(Map<String, Object> properties) throws JMSException {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.setObjectProperty(entry.getKey(), entry.getValue());
        }
    }

    protected void checkValidObject(Object value) throws MessageFormatException {
        boolean valid = value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
        boolean bl = valid = valid || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String || value == null;
        if (!valid) {
            throw new MessageFormatException("Only objectified primitive objects and String types are allowed but was: " + value + " type: " + value.getClass());
        }
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (name == null) {
            throw new NullPointerException("Property name cannot be null");
        }
        PropertyExpression expression = new PropertyExpression(name);
        return expression.evaluate(this);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            return false;
        }
        Boolean rc = (Boolean)TypeConversionSupport.convert(this.connection, value, Boolean.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a boolean");
        }
        return rc;
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Byte rc = (Byte)TypeConversionSupport.convert(this.connection, value, Byte.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a byte");
        }
        return rc;
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Short rc = (Short)TypeConversionSupport.convert(this.connection, value, Short.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a short");
        }
        return rc;
    }

    public int getIntProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Integer rc = (Integer)TypeConversionSupport.convert(this.connection, value, Integer.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as an integer");
        }
        return rc;
    }

    public long getLongProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Long rc = (Long)TypeConversionSupport.convert(this.connection, value, Long.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a long");
        }
        return rc;
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Float rc = (Float)TypeConversionSupport.convert(this.connection, value, Float.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a float");
        }
        return rc.floatValue();
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Double rc = (Double)TypeConversionSupport.convert(this.connection, value, Double.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a double");
        }
        return rc;
    }

    public String getStringProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            return null;
        }
        String rc = (String)TypeConversionSupport.convert(this.connection, value, String.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a String");
        }
        return rc;
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setBooleanProperty(name, value, true);
    }

    public void setBooleanProperty(String name, boolean value, boolean checkReadOnly) throws JMSException {
        this.setObjectProperty(name, value, checkReadOnly);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, new Float(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, new Double(value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    private void checkReadOnlyProperties() throws MessageNotWriteableException {
        if (this.readOnlyProperties) {
            throw new MessageNotWriteableException("Message properties are read-only");
        }
    }

    protected void checkReadOnlyBody() throws MessageNotWriteableException {
        if (this.readOnlyBody) {
            throw new MessageNotWriteableException("Message body is read-only");
        }
    }

    public Callable<Void> getAcknowledgeCallback() {
        return this.acknowledgeCallback;
    }

    public void setAcknowledgeCallback(Callable<Void> acknowledgeCallback) {
        this.acknowledgeCallback = acknowledgeCallback;
    }

    public void onSend() throws JMSException {
        this.setReadOnlyBody(true);
        this.setReadOnlyProperties(true);
        this.storeContent();
    }

    public void storeContent() throws JMSException {
    }

    public AsciiBuffer getConsumerId() {
        return this.getHeaderMap().get(Constants.SUBSCRIPTION);
    }

    protected Map<AsciiBuffer, AsciiBuffer> getHeaderMap() {
        return this.frame.headerMap(REVERSED_HEADER_NAMES);
    }

    public AsciiBuffer getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(AsciiBuffer transactionId) {
        this.transactionId = transactionId;
    }

    public StompJmsConnection getConnection() {
        return this.connection;
    }

    public void setConnection(StompJmsConnection connection) {
        this.connection = connection;
    }

    public long getJMSDeliveryTime() throws JMSException {
        throw new UnsupportedOperationException("getJMSDeliveryTime() is not supported");
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        throw new UnsupportedOperationException("setJMSDeliveryTime(deliveryTime) is not supported");
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        throw new UnsupportedOperationException("getBody(Class<T> c) is not supported");
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        throw new UnsupportedOperationException("isBodyAssignableTo(Class) is not supported");
    }

    static {
        RESERVED_HEADER_NAMES.add(Constants.DESTINATION);
        RESERVED_HEADER_NAMES.add(Constants.REPLY_TO);
        RESERVED_HEADER_NAMES.add(Constants.MESSAGE_ID);
        RESERVED_HEADER_NAMES.add(Constants.CORRELATION_ID);
        RESERVED_HEADER_NAMES.add(Constants.EXPIRATION_TIME);
        RESERVED_HEADER_NAMES.add(Constants.TIMESTAMP);
        RESERVED_HEADER_NAMES.add(Constants.PRIORITY);
        RESERVED_HEADER_NAMES.add(Constants.REDELIVERED);
        RESERVED_HEADER_NAMES.add(Constants.TYPE);
        RESERVED_HEADER_NAMES.add(Constants.PERSISTENT);
        RESERVED_HEADER_NAMES.add(Constants.RECEIPT_REQUESTED);
        RESERVED_HEADER_NAMES.add(Constants.TRANSFORMATION);
        RESERVED_HEADER_NAMES.add(Constants.SUBSCRIPTION);
        RESERVED_HEADER_NAMES.add(Constants.CONTENT_LENGTH);
        RESERVED_HEADER_NAMES.add(Constants.JMSX_DELIVERY_COUNT);
        REVERSED_HEADER_NAMES = new HashSet();
        REVERSED_HEADER_NAMES.add(Constants.DESTINATION);
        REVERSED_HEADER_NAMES.add(Constants.REPLY_TO);
        JMS_PROPERTY_SETERS.put("JMSXDeliveryCount", new PropertySetter(){

            @Override
            public void set(StompJmsConnection connection, StompJmsMessage message, Object value) throws MessageFormatException {
                Integer rc = (Integer)TypeConversionSupport.convert(connection, value, Integer.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSXDeliveryCount cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setRedeliveryCounter(rc - 1);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSCorrelationID", new PropertySetter(){

            @Override
            public void set(StompJmsConnection connection, StompJmsMessage message, Object value) throws MessageFormatException {
                String rc = (String)TypeConversionSupport.convert(connection, value, String.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSCorrelationID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setJMSCorrelationID(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSDeliveryMode", new PropertySetter(){

            @Override
            public void set(StompJmsConnection connection, StompJmsMessage message, Object value) throws MessageFormatException {
                Integer rc = (Integer)TypeConversionSupport.convert(connection, value, Integer.class);
                if (rc == null) {
                    Boolean bool = (Boolean)TypeConversionSupport.convert(connection, value, Boolean.class);
                    if (bool == null) {
                        throw new MessageFormatException("Property JMSDeliveryMode cannot be set from a " + value.getClass().getName() + ".");
                    }
                    rc = bool != false ? 2 : 1;
                }
                message.setJMSDeliveryMode(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSExpiration", new PropertySetter(){

            @Override
            public void set(StompJmsConnection connection, StompJmsMessage message, Object value) throws MessageFormatException {
                Long rc = (Long)TypeConversionSupport.convert(connection, value, Long.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSExpiration cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setJMSExpiration(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSPriority", new PropertySetter(){

            @Override
            public void set(StompJmsConnection connection, StompJmsMessage message, Object value) throws MessageFormatException {
                Integer rc = (Integer)TypeConversionSupport.convert(connection, value, Integer.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSPriority cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setJMSPriority(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSRedelivered", new PropertySetter(){

            @Override
            public void set(StompJmsConnection connection, StompJmsMessage message, Object value) throws MessageFormatException {
                Boolean rc = (Boolean)TypeConversionSupport.convert(connection, value, Boolean.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSRedelivered cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setJMSRedelivered(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSReplyTo", new PropertySetter(){

            @Override
            public void set(StompJmsConnection connection, StompJmsMessage message, Object value) throws MessageFormatException {
                StompJmsDestination rc = (StompJmsDestination)TypeConversionSupport.convert(connection, value, StompJmsDestination.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSReplyTo cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setJMSReplyTo(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSTimestamp", new PropertySetter(){

            @Override
            public void set(StompJmsConnection connection, StompJmsMessage message, Object value) throws MessageFormatException {
                Long rc = (Long)TypeConversionSupport.convert(connection, value, Long.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSTimestamp cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setJMSTimestamp(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSType", new PropertySetter(){

            @Override
            public void set(StompJmsConnection connection, StompJmsMessage message, Object value) throws MessageFormatException {
                String rc = (String)TypeConversionSupport.convert(connection, value, String.class);
                if (rc == null) {
                    throw new MessageFormatException("Property JMSType cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setJMSType(rc);
            }
        });
    }

    static interface PropertySetter {
        public void set(StompJmsConnection var1, StompJmsMessage var2, Object var3) throws MessageFormatException;
    }

    public static enum JmsMsgType {
        MESSAGE("jms/message"),
        BYTES("jms/bytes-message"),
        MAP("jms/map-message"),
        OBJECT("jms/object-message"),
        STREAM("jms/stream-message"),
        TEXT("jms/text-message"),
        TEXT_NULL("jms/text-message-null");

        public final AsciiBuffer buffer = new AsciiBuffer(this.name());
        public final AsciiBuffer mime;

        private JmsMsgType(String mime) {
            this.mime = Buffer.ascii((String)mime);
        }
    }
}

