/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.jndi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.fusesource.stomp.jms.jndi.JNDIReferenceFactory;

public abstract class JNDIStorable
implements Referenceable,
Externalizable {
    private Map<String, String> properties;

    protected abstract void buildFromProperties(Map<String, String> var1);

    protected abstract void populateProperties(Map<String, String> var1);

    public synchronized void setProperties(Map<String, String> props) {
        this.properties = props;
        this.buildFromProperties(props);
    }

    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.populateProperties(this.properties);
        return this.properties;
    }

    @Override
    public Reference getReference() throws NamingException {
        return JNDIReferenceFactory.createReference(this.getClass().getName(), this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Map props = (Map)in.readObject();
        if (props != null) {
            this.setProperties(props);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getProperties());
    }

    protected String getProperty(Map<String, String> map, String key, String defaultValue) {
        String value = map.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

