/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.id;

import io.hypersistence.utils.hibernate.id.BatchSequence;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.SequenceStructure;
import org.hibernate.id.factory.spi.CustomIdGeneratorCreationContext;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class BatchSequenceGenerator
implements BulkInsertionCapableIdentifierGenerator,
PersistentIdentifierGenerator,
Configurable {
    @Deprecated
    public static final String SEQUENCE_PARAM = "sequence";
    @Deprecated
    public static final String FETCH_SIZE_PARAM = "fetch_size";
    public static final int DEFAULT_FETCH_SIZE = 10;
    private final Lock lock = new ReentrantLock();
    private int fetchSize;
    private QualifiedName sequenceName;
    private IdentifierExtractor identifierExtractor;
    private SequenceStructure sequenceStructure;
    private String select;
    private IdentifierPool identifierPool;

    public BatchSequenceGenerator(BatchSequence annotation, Member annotatedMember, CustomIdGeneratorCreationContext context) {
        JdbcEnvironment jdbcEnvironment = (JdbcEnvironment)context.getServiceRegistry().getService(JdbcEnvironment.class);
        this.sequenceName = BatchSequenceGenerator.determineSequenceName(annotation, jdbcEnvironment);
        this.fetchSize = annotation.fetchSize();
        Class<?> type = BatchSequenceGenerator.getType(annotatedMember);
        this.identifierExtractor = IdentifierExtractor.getIdentifierExtractor(type);
        this.sequenceStructure = this.buildSequenceStructure(type, this.sequenceName, jdbcEnvironment);
    }

    public BatchSequenceGenerator() {
    }

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        if (this.sequenceName == null) {
            JdbcEnvironment jdbcEnvironment = (JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class);
            this.sequenceName = BatchSequenceGenerator.determineSequenceName(params, jdbcEnvironment);
            this.fetchSize = BatchSequenceGenerator.determineFetchSize(params);
            Class numberType = type.getReturnedClass();
            this.identifierExtractor = IdentifierExtractor.getIdentifierExtractor(numberType);
            this.sequenceStructure = this.buildSequenceStructure(numberType, this.sequenceName, jdbcEnvironment);
        }
    }

    private static Class<?> getType(Member annotatedMember) {
        if (annotatedMember instanceof Field) {
            return ((Field)annotatedMember).getType();
        }
        if (annotatedMember instanceof Method) {
            return ((Method)annotatedMember).getReturnType();
        }
        throw new IllegalArgumentException("unknown member type: " + annotatedMember);
    }

    public void initialize(SqlStringGenerationContext context) {
        Dialect dialect = context.getDialect();
        String sequenceNextValString = dialect.getSequenceSupport().getSelectSequenceNextValString(context.format(this.sequenceName));
        this.identifierPool = IdentifierPool.empty();
        this.sequenceStructure.initialize(context);
        this.select = BatchSequenceGenerator.buildSelect(sequenceNextValString, dialect);
    }

    private static String buildSelect(String nextValString, Dialect dialect) {
        if (dialect instanceof OracleDialect) {
            return "SELECT " + nextValString + " FROM dual CONNECT BY rownum <= ?";
        }
        if (dialect instanceof SQLServerDialect) {
            return "WITH t(n) AS ( SELECT 1 AS n UNION ALL SELECT n + 1 AS n FROM t WHERE n < ?) SELECT " + nextValString + " AS n FROM t";
        }
        if (dialect instanceof DB2Dialect) {
            return "WITH t(n) AS ( SELECT 1 AS n FROM (VALUES 1) UNION ALL SELECT n + 1 AS n FROM t WHERE n < ?) SELECT " + nextValString + " AS n FROM t";
        }
        if (dialect instanceof HSQLDialect) {
            return "SELECT " + nextValString + " FROM UNNEST(SEQUENCE_ARRAY(1, ?, 1))";
        }
        if (dialect instanceof PostgreSQLDialect) {
            return "SELECT " + nextValString + " FROM generate_series(1, ?)";
        }
        return "WITH RECURSIVE t(n) AS (SELECT 1 UNION ALL SELECT n + 1 FROM t  WHERE n < ?) SELECT " + nextValString + " FROM t";
    }

    private SequenceStructure buildSequenceStructure(Class<?> type, QualifiedName sequenceName, JdbcEnvironment jdbcEnvironment) {
        return new SequenceStructure(jdbcEnvironment, "orm", sequenceName, 1, 1, type);
    }

    private static QualifiedName determineSequenceName(Properties params, JdbcEnvironment jdbcEnv) {
        String sequenceName = params.getProperty(SEQUENCE_PARAM);
        if (sequenceName == null) {
            throw new MappingException("no squence name specified");
        }
        Identifier catalog = jdbcEnv.getIdentifierHelper().toIdentifier(params.getProperty("catalog"));
        Identifier schema = jdbcEnv.getIdentifierHelper().toIdentifier(params.getProperty("schema"));
        if (sequenceName.contains(".")) {
            return QualifiedNameParser.INSTANCE.parse(sequenceName);
        }
        return new QualifiedNameParser.NameParts(catalog, schema, jdbcEnv.getIdentifierHelper().toIdentifier(sequenceName));
    }

    private static QualifiedName determineSequenceName(BatchSequence annotation, JdbcEnvironment jdbcEnv) {
        String sequenceName = annotation.name();
        if (sequenceName == null) {
            throw new MappingException("no squence name specified");
        }
        Identifier catalog = jdbcEnv.getIdentifierHelper().toIdentifier(annotation.catalog());
        Identifier schema = jdbcEnv.getIdentifierHelper().toIdentifier(annotation.schema());
        if (sequenceName.contains(".")) {
            return QualifiedNameParser.INSTANCE.parse(sequenceName);
        }
        return new QualifiedNameParser.NameParts(catalog, schema, jdbcEnv.getIdentifierHelper().toIdentifier(sequenceName));
    }

    private static int determineFetchSize(Properties params) {
        int fetchSize = ConfigurationHelper.getInt((String)FETCH_SIZE_PARAM, (Map)params, (int)10);
        if (fetchSize <= 0) {
            throw new MappingException("fetch size must be positive");
        }
        return fetchSize;
    }

    public boolean supportsBulkInsertionIdentifierGeneration() {
        return true;
    }

    public String determineBulkInsertionIdentifierGenerationSelectFragment(SqlStringGenerationContext sqlStringGenerationContext) {
        return sqlStringGenerationContext.getDialect().getSequenceSupport().getSequenceNextValString(sqlStringGenerationContext.format(this.sequenceStructure.getPhysicalName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        this.lock.lock();
        try {
            if (this.identifierPool.isEmpty()) {
                this.identifierPool = this.replenishIdentifierPool(session);
            }
            Serializable serializable = this.identifierPool.next();
            return serializable;
        }
        finally {
            this.lock.unlock();
        }
    }

    private String getSequenceName() {
        return this.sequenceStructure.getPhysicalName().render();
    }

    public void registerExportables(Database database) {
        this.sequenceStructure.registerExportables(database);
    }

    private IdentifierPool replenishIdentifierPool(SharedSessionContractImplementor session) throws HibernateException {
        JdbcCoordinator coordinator = session.getJdbcCoordinator();
        ArrayList<Serializable> identifiers = new ArrayList<Serializable>(this.fetchSize);
        try (PreparedStatement statement = coordinator.getStatementPreparer().prepareStatement(this.select);){
            statement.setFetchSize(this.fetchSize);
            statement.setInt(1, this.fetchSize);
            try (ResultSet resultSet = coordinator.getResultSetReturn().extract(statement, this.select);){
                while (resultSet.next()) {
                    identifiers.add(this.identifierExtractor.extractIdentifier(resultSet));
                }
            }
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "could not get next sequence value", this.select);
        }
        if (identifiers.size() != this.fetchSize) {
            throw new IdentifierGenerationException("expected " + this.fetchSize + " values from " + this.getSequenceName() + " but got " + identifiers.size());
        }
        return IdentifierPool.forList(identifiers);
    }

    public Optimizer getOptimizer() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getSequenceName() + ")";
    }

    static enum IdentifierExtractor {
        INTEGER_IDENTIFIER_EXTRACTOR{

            @Override
            Serializable extractIdentifier(ResultSet resultSet) throws SQLException {
                int intValue = resultSet.getInt(1);
                if (resultSet.wasNull()) {
                    throw new IdentifierGenerationException("sequence returned null");
                }
                return Integer.valueOf(intValue);
            }
        }
        ,
        LONG_IDENTIFIER_EXTRACTOR{

            @Override
            Serializable extractIdentifier(ResultSet resultSet) throws SQLException {
                long longValue = resultSet.getLong(1);
                if (resultSet.wasNull()) {
                    throw new IdentifierGenerationException("sequence returned null");
                }
                return Long.valueOf(longValue);
            }
        }
        ,
        BIG_INTEGER_IDENTIFIER_EXTRACTOR{

            @Override
            Serializable extractIdentifier(ResultSet resultSet) throws SQLException {
                BigDecimal bigDecimal = resultSet.getBigDecimal(1);
                if (resultSet.wasNull()) {
                    throw new IdentifierGenerationException("sequence returned null");
                }
                return bigDecimal.setScale(0, 7).toBigInteger();
            }
        }
        ,
        BIG_DECIMAL_IDENTIFIER_EXTRACTOR{

            @Override
            Serializable extractIdentifier(ResultSet resultSet) throws SQLException {
                BigDecimal bigDecimal = resultSet.getBigDecimal(1);
                if (resultSet.wasNull()) {
                    throw new IdentifierGenerationException("sequence returned null");
                }
                return bigDecimal;
            }
        };


        abstract Serializable extractIdentifier(ResultSet var1) throws SQLException;

        static IdentifierExtractor getIdentifierExtractor(Class<?> integralType) {
            if (integralType == Integer.class || integralType == Integer.TYPE) {
                return INTEGER_IDENTIFIER_EXTRACTOR;
            }
            if (integralType == Long.class || integralType == Long.TYPE) {
                return LONG_IDENTIFIER_EXTRACTOR;
            }
            if (integralType == BigInteger.class) {
                return BIG_INTEGER_IDENTIFIER_EXTRACTOR;
            }
            if (integralType == BigDecimal.class) {
                return BIG_DECIMAL_IDENTIFIER_EXTRACTOR;
            }
            throw new IdentifierGenerationException("unsupported integral type: " + integralType);
        }
    }

    static final class IdentifierPool {
        private final Iterator<Serializable> iterator;

        private IdentifierPool(List<Serializable> identifiers) {
            this.iterator = identifiers.iterator();
        }

        static IdentifierPool forList(List<Serializable> identifiers) {
            return new IdentifierPool(identifiers);
        }

        static IdentifierPool empty() {
            return new IdentifierPool(Collections.emptyList());
        }

        boolean isEmpty() {
            return !this.iterator.hasNext();
        }

        Serializable next() {
            return this.iterator.next();
        }
    }
}

