/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json.internal;

import com.fasterxml.jackson.databind.JsonNode;
import io.hypersistence.utils.hibernate.type.util.ObjectMapperWrapper;
import java.io.Serializable;
import org.hibernate.SharedSessionContract;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;

public class JsonNodeJavaTypeDescriptor
extends AbstractClassJavaType<JsonNode> {
    public static final JsonNodeJavaTypeDescriptor INSTANCE = new JsonNodeJavaTypeDescriptor();
    private ObjectMapperWrapper objectMapperWrapper;

    public JsonNodeJavaTypeDescriptor() {
        this(ObjectMapperWrapper.INSTANCE);
    }

    public JsonNodeJavaTypeDescriptor(ObjectMapperWrapper objectMapperWrapper) {
        super(JsonNode.class, (MutabilityPlan)JsonBinaryMutabilityPlan.INSTANCE);
        this.objectMapperWrapper = objectMapperWrapper;
    }

    public boolean areEqual(JsonNode one, JsonNode another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return this.objectMapperWrapper.toJsonNode(this.objectMapperWrapper.toString(one)).equals((Object)this.objectMapperWrapper.toJsonNode(this.objectMapperWrapper.toString(another)));
    }

    public String toString(JsonNode value) {
        return this.objectMapperWrapper.toString(value);
    }

    public JsonNode fromString(CharSequence string) {
        return this.objectMapperWrapper.toJsonNode((String)string);
    }

    public <X> X unwrap(JsonNode value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return (X)this.objectMapperWrapper.toJsonNode(this.toString(value));
        }
        throw this.unknownUnwrap(type);
    }

    public <X> JsonNode wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        return this.fromString(value.toString());
    }

    static class JsonBinaryMutabilityPlan
    extends MutableMutabilityPlan<JsonNode> {
        static final JsonBinaryMutabilityPlan INSTANCE = new JsonBinaryMutabilityPlan();

        JsonBinaryMutabilityPlan() {
        }

        public Serializable disassemble(JsonNode value, SharedSessionContract session) {
            return value != null ? (Serializable)value.deepCopy() : null;
        }

        public JsonNode assemble(Serializable cached, SharedSessionContract session) {
            return (JsonNode)cached;
        }

        protected JsonNode deepCopyNotNull(JsonNode value) {
            return value.deepCopy();
        }
    }
}

