/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array.internal;

import io.hypersistence.utils.hibernate.type.array.internal.AbstractArrayTypeDescriptor;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.UUID;

public class GenericArrayTypeDescriptor
extends AbstractArrayTypeDescriptor<Object> {
    public GenericArrayTypeDescriptor() {
        super(Object.class);
    }

    @Override
    protected String getSqlArrayType() {
        String sqlArrayType = super.getSqlArrayType();
        if (sqlArrayType != null) {
            return sqlArrayType;
        }
        Class javaAttributeClass = this.getJavaArrayComponentType(this.getArrayObjectClass());
        if (Boolean.TYPE.isAssignableFrom(javaAttributeClass) || Boolean.class.isAssignableFrom(javaAttributeClass)) {
            this.setSqlArrayType("boolean");
        } else if (java.sql.Date.class.isAssignableFrom(javaAttributeClass) || LocalDate.class.isAssignableFrom(javaAttributeClass)) {
            this.setSqlArrayType("date");
        } else if (BigDecimal.class.isAssignableFrom(javaAttributeClass)) {
            this.setSqlArrayType("decimal");
        } else if (Double.TYPE.isAssignableFrom(javaAttributeClass) || Double.class.isAssignableFrom(javaAttributeClass)) {
            this.setSqlArrayType("float8");
        } else if (Float.TYPE.isAssignableFrom(javaAttributeClass) || Float.class.isAssignableFrom(javaAttributeClass)) {
            this.setSqlArrayType("float4");
        } else if (Integer.TYPE.isAssignableFrom(javaAttributeClass) || Integer.class.isAssignableFrom(javaAttributeClass)) {
            this.setSqlArrayType("integer");
        } else if (Long.TYPE.isAssignableFrom(javaAttributeClass) || Long.class.isAssignableFrom(javaAttributeClass)) {
            this.setSqlArrayType("bigint");
        } else if (Date.class.isAssignableFrom(javaAttributeClass) || Timestamp.class.isAssignableFrom(javaAttributeClass) || LocalDateTime.class.isAssignableFrom(javaAttributeClass)) {
            this.setSqlArrayType("timestamp");
        } else if (String.class.isAssignableFrom(javaAttributeClass)) {
            this.setSqlArrayType("text");
        } else if (UUID.class.isAssignableFrom(javaAttributeClass)) {
            this.setSqlArrayType("uuid");
        }
        return super.getSqlArrayType();
    }

    private Class getJavaArrayComponentType(Class javaAttributeClass) {
        Class<?> javaArrayComponentType = javaAttributeClass.getComponentType();
        if (javaArrayComponentType.isArray()) {
            return this.getJavaArrayComponentType(javaArrayComponentType);
        }
        return javaArrayComponentType;
    }
}

