/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.jdbc.validator;

import io.hypersistence.utils.jdbc.validator.SQLStatementCountMismatchException;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;

enum StatementType {
    SELECT{

        @Override
        protected long recordedCount() {
            QueryCount queryCount = QueryCountHolder.getGrandTotal();
            return queryCount.getSelect();
        }
    }
    ,
    INSERT{

        @Override
        protected long recordedCount() {
            QueryCount queryCount = QueryCountHolder.getGrandTotal();
            return queryCount.getInsert();
        }
    }
    ,
    UPDATE{

        @Override
        protected long recordedCount() {
            QueryCount queryCount = QueryCountHolder.getGrandTotal();
            return queryCount.getUpdate();
        }
    }
    ,
    DELETE{

        @Override
        protected long recordedCount() {
            QueryCount queryCount = QueryCountHolder.getGrandTotal();
            return queryCount.getDelete();
        }
    }
    ,
    TOTAL{

        @Override
        protected long recordedCount() {
            QueryCount queryCount = QueryCountHolder.getGrandTotal();
            return queryCount.getTotal();
        }

        @Override
        protected String toString(long expectedCount, long recordedCount) {
            return String.format("Expected a total of [%d] statement(s) but recorded [%d] instead!", expectedCount, recordedCount);
        }
    };


    protected abstract long recordedCount();

    protected String toString(long expectedCount, long recordedCount) {
        return String.format("Expected [%d] %s statement%s but recorded [%d] instead!", expectedCount, this.name(), expectedCount > 1L ? "s" : "", recordedCount);
    }

    void validate(long expectedCount) {
        long recordedCount = this.recordedCount();
        if (expectedCount != recordedCount) {
            throw new SQLStatementCountMismatchException(this, expectedCount, recordedCount);
        }
    }
}

