/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.query;

import io.hypersistence.utils.hibernate.util.ReflectionUtils;
import jakarta.persistence.Query;
import java.util.function.Supplier;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sqm.internal.ConcreteSqmSelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.QuerySqmImpl;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;

public class SQLExtractor {
    protected SQLExtractor() {
    }

    public static String from(Query query) {
        if (query instanceof SqmInterpretationsKey.InterpretationsKeySource && query instanceof QueryImplementor && query instanceof QuerySqmImpl) {
            SelectQueryPlan plan;
            SqmInterpretationsKey cacheKey = SqmInterpretationsKey.createInterpretationsKey((SqmInterpretationsKey.InterpretationsKeySource)((SqmInterpretationsKey.InterpretationsKeySource)query));
            QuerySqmImpl querySqm = (QuerySqmImpl)query;
            Supplier<Object> buildSelectQueryPlan = () -> ReflectionUtils.invokeMethod((Object)querySqm, "buildSelectQueryPlan", new Object[0]);
            SelectQueryPlan selectQueryPlan = plan = cacheKey != null ? ((QueryImplementor)query).getSession().getFactory().getQueryEngine().getInterpretationCache().resolveSelectQueryPlan((QueryInterpretationCache.Key)cacheKey, buildSelectQueryPlan) : (SelectQueryPlan)buildSelectQueryPlan.get();
            if (plan instanceof ConcreteSqmSelectQueryPlan) {
                JdbcOperationQuerySelect jdbcSelect;
                ConcreteSqmSelectQueryPlan selectQueryPlan2 = (ConcreteSqmSelectQueryPlan)plan;
                Object cacheableSqmInterpretation = ReflectionUtils.getFieldValueOrNull(selectQueryPlan2, "cacheableSqmInterpretation");
                if (cacheableSqmInterpretation == null) {
                    DomainQueryExecutionContext domainQueryExecutionContext = (DomainQueryExecutionContext)DomainQueryExecutionContext.class.cast(querySqm);
                    cacheableSqmInterpretation = ReflectionUtils.invokeStaticMethod(ReflectionUtils.getMethod(ConcreteSqmSelectQueryPlan.class, "buildCacheableSqmInterpretation", SqmSelectStatement.class, DomainParameterXref.class, DomainQueryExecutionContext.class), ReflectionUtils.getFieldValueOrNull(selectQueryPlan2, "sqm"), ReflectionUtils.getFieldValueOrNull(selectQueryPlan2, "domainParameterXref"), domainQueryExecutionContext);
                }
                if (cacheableSqmInterpretation != null && (jdbcSelect = (JdbcOperationQuerySelect)ReflectionUtils.getFieldValueOrNull(cacheableSqmInterpretation, "jdbcSelect")) != null) {
                    return jdbcSelect.getSqlString();
                }
            }
        }
        return (String)ReflectionUtils.invokeMethod((Object)query, "getQueryString", new Object[0]);
    }
}

