/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.util;

import io.hypersistence.utils.hibernate.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.Column;
import org.hibernate.usertype.DynamicParameterizedType;

public class ParameterTypeUtils {
    private static final Pattern COLUMN_TYPE_PATTERN = Pattern.compile("([a-zA-Z0-9]+).*?");

    private ParameterTypeUtils() {
        throw new UnsupportedOperationException("StringUtils is not instantiable!");
    }

    public static DynamicParameterizedType.ParameterType resolve(Properties properties) {
        Object parameterTypeObject = properties.get("org.hibernate.type.ParameterType");
        if (parameterTypeObject instanceof DynamicParameterizedType.ParameterType) {
            return (DynamicParameterizedType.ParameterType)parameterTypeObject;
        }
        return null;
    }

    public static <A extends Annotation> A getAnnotationOrNull(DynamicParameterizedType.ParameterType parameterType, Class<A> annotationClass) {
        List<A> annotations = ParameterTypeUtils.getAnnotations(parameterType, annotationClass);
        int annotationCount = annotations.size();
        if (annotationCount > 1) {
            throw new IllegalArgumentException(String.format("The provided ParameterType associated with the [%s] property contains more than one annotation of the [%s] type!", parameterType.getReturnedClass(), annotationClass.getName()));
        }
        return (A)(annotationCount == 1 ? (Annotation)annotations.get(0) : null);
    }

    public static <A extends Annotation> List<A> getAnnotations(DynamicParameterizedType.ParameterType parameterType, Class<A> annotationClass) {
        return Arrays.stream(parameterType.getAnnotationsMethod()).filter(a -> annotationClass.isAssignableFrom(a.annotationType())).map(a -> a).collect(Collectors.toList());
    }

    public static String getColumnType(DynamicParameterizedType.ParameterType parameterType) {
        Matcher matcher;
        String columnDefinition;
        Column columnAnnotation;
        if (parameterType != null && (columnAnnotation = ParameterTypeUtils.getAnnotationOrNull(parameterType, Column.class)) != null && !StringUtils.isBlank(columnDefinition = columnAnnotation.columnDefinition()) && (matcher = COLUMN_TYPE_PATTERN.matcher(columnDefinition)).matches()) {
            return StringUtils.toLowercase(matcher.group(1));
        }
        return null;
    }
}

