/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json.internal;

import io.hypersistence.utils.hibernate.type.json.internal.AbstractJsonSqlTypeDescriptor;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.dialect.Database;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;

public class JsonBytesSqlTypeDescriptor
extends AbstractJsonSqlTypeDescriptor {
    public static final JsonBytesSqlTypeDescriptor INSTANCE = new JsonBytesSqlTypeDescriptor();
    private static final Map<Database, JsonBytesSqlTypeDescriptor> INSTANCE_MAP = new HashMap<Database, JsonBytesSqlTypeDescriptor>();
    public static final String CHARSET = "UTF8";
    private final int jdbcType;

    public static JsonBytesSqlTypeDescriptor of(Database database) {
        return INSTANCE_MAP.get(database);
    }

    public JsonBytesSqlTypeDescriptor() {
        this.jdbcType = -2;
    }

    public JsonBytesSqlTypeDescriptor(int jdbcType) {
        this.jdbcType = jdbcType;
    }

    @Override
    public int getSqlType() {
        return this.jdbcType;
    }

    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setBytes(index, JsonBytesSqlTypeDescriptor.this.toJsonBytes((String)javaTypeDescriptor.unwrap(value, String.class, options)));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setBytes(name, JsonBytesSqlTypeDescriptor.this.toJsonBytes((String)javaTypeDescriptor.unwrap(value, String.class, options)));
            }
        };
    }

    @Override
    protected Object extractJson(ResultSet rs, String name) throws SQLException {
        return this.fromJsonBytes(rs.getBytes(name));
    }

    @Override
    protected Object extractJson(CallableStatement statement, int index) throws SQLException {
        return this.fromJsonBytes(statement.getBytes(index));
    }

    @Override
    protected Object extractJson(CallableStatement statement, String name) throws SQLException {
        return this.fromJsonBytes(statement.getBytes(name));
    }

    protected byte[] toJsonBytes(String jsonValue) {
        try {
            return jsonValue.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String fromJsonBytes(byte[] jsonBytes) {
        if (jsonBytes == null) {
            return null;
        }
        try {
            return new String(jsonBytes, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        INSTANCE_MAP.put(Database.H2, INSTANCE);
        INSTANCE_MAP.put(Database.ORACLE, new JsonBytesSqlTypeDescriptor(2016));
    }
}

