/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5;

import io.helidon.testing.junit5.TestJunitExtension;
import io.helidon.webserver.testing.junit5.AfterStop;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

abstract class JunitExtensionBase
extends TestJunitExtension
implements AfterAllCallback {
    private Class<?> testClass;

    JunitExtensionBase() {
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.callAfterStop();
        super.afterAll(extensionContext);
    }

    void testClass(Class<?> testClass) {
        this.testClass = testClass;
    }

    Class<?> testClass() {
        return this.testClass;
    }

    private void callAfterStop() {
        if (this.testClass == null) {
            return;
        }
        ArrayList<Method> toInvoke = new ArrayList<Method>();
        Method[] methods = this.testClass.getMethods();
        for (Method method : methods) {
            AfterStop annotation = method.getAnnotation(AfterStop.class);
            if (annotation == null) continue;
            if (method.getParameterCount() != 0) {
                throw new IllegalStateException("Method " + String.valueOf(method) + " is annotated with @AfterStop, but it has parameters");
            }
            if (Modifier.isStatic(method.getModifiers())) {
                method.setAccessible(true);
                toInvoke.add(method);
                continue;
            }
            throw new IllegalStateException("Method " + String.valueOf(method) + " is annotated with @AfterStop, but it is not static");
        }
        for (Method method : toInvoke) {
            try {
                method.invoke(this.testClass, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke method: " + String.valueOf(method), e);
            }
        }
    }
}

