/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5;

import io.helidon.webserver.testing.junit5.Socket;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.LinkedList;
import java.util.function.BiConsumer;

public final class Junit5Util {
    private Junit5Util() {
    }

    public static String socketName(Parameter parameter) {
        Socket socketAnnot = parameter.getAnnotation(Socket.class);
        if (socketAnnot == null) {
            return "@default";
        }
        return socketAnnot.value();
    }

    static <T extends Annotation> void withStaticMethods(Class<?> testClass, Class<T> annotationType, BiConsumer<T, Method> handler) {
        LinkedList hierarchy = new LinkedList();
        for (Class<?> analyzedClass = testClass; analyzedClass != null && !analyzedClass.equals(Object.class); analyzedClass = analyzedClass.getSuperclass()) {
            hierarchy.addFirst(analyzedClass);
        }
        for (Class clazz : hierarchy) {
            for (Method method : clazz.getDeclaredMethods()) {
                T annotation = method.getDeclaredAnnotation(annotationType);
                if (annotation == null) continue;
                if (Modifier.isStatic(method.getModifiers())) {
                    handler.accept(annotation, method);
                    continue;
                }
                throw new IllegalStateException("Method " + String.valueOf(method) + " is annotated with " + annotationType.getSimpleName() + " yet it is not static");
            }
        }
    }
}

