/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ProtocolConfigs;
import io.helidon.webserver.Router;
import io.helidon.webserver.http1.Http1Config;
import io.helidon.webserver.http1.Http1ConnectionProvider;
import io.helidon.webserver.spi.ServerConnection;
import io.helidon.webserver.testing.junit5.DirectClientServerContext;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;

class DirectClientConnection
implements ClientConnection {
    private final AtomicBoolean serverStarted = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final DataReader clientReader;
    private final DataWriter clientWriter;
    private final DirectClientServerContext serverContext;
    private final HelidonSocket socket;

    DirectClientConnection(HelidonSocket socket, Router router) {
        ArrayBlockingQueue<byte[]> serverToClient = new ArrayBlockingQueue<byte[]>(1024);
        ArrayBlockingQueue<byte[]> clientToServer = new ArrayBlockingQueue<byte[]>(1024);
        this.clientReader = this.reader(serverToClient);
        this.clientWriter = this.writer(clientToServer);
        this.socket = socket;
        this.serverContext = new DirectClientServerContext(router, socket, this.reader(clientToServer), this.writer(serverToClient));
    }

    public HelidonSocket helidonSocket() {
        return this.socket;
    }

    public DataReader reader() {
        return this.clientReader;
    }

    public DataWriter writer() {
        return this.clientWriter;
    }

    public void releaseResource() {
        this.closeResource();
    }

    public void closeResource() {
        if (this.closed.compareAndSet(false, true)) {
            this.clientWriter.writeNow(BufferData.empty());
        }
    }

    public String channelId() {
        return "unit-client";
    }

    public void readTimeout(Duration readTimeout) {
    }

    private DataWriter writer(final ArrayBlockingQueue<byte[]> queue) {
        return new DataWriter(){

            public void write(BufferData ... buffers) {
                this.writeNow(buffers);
            }

            public void write(BufferData buffer) {
                this.writeNow(buffer);
            }

            public void writeNow(BufferData ... buffers) {
                for (BufferData buffer : buffers) {
                    this.writeNow(buffer);
                }
            }

            public void writeNow(BufferData buffer) {
                if (DirectClientConnection.this.serverStarted.compareAndSet(false, true)) {
                    DirectClientConnection.this.startServer();
                }
                byte[] bytes = new byte[buffer.available()];
                buffer.read(bytes);
                try {
                    queue.put(bytes);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Thread interrupted", e);
                }
            }
        };
    }

    private DataReader reader(ArrayBlockingQueue<byte[]> queue) {
        return new DataReader(() -> {
            byte[] data;
            try {
                data = (byte[])queue.take();
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Thread interrupted", e);
            }
            if (data.length == 0) {
                return null;
            }
            return data;
        });
    }

    private void startServer() {
        ServerConnection connection = new Http1ConnectionProvider().create("@default", Http1Config.create(), ProtocolConfigs.create(List.of())).connection((ConnectionContext)this.serverContext);
        this.serverContext.executor().submit(() -> {
            try {
                connection.handle(new Semaphore(1024));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }
}

