/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.metrics;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.webserver.observe.ObserverConfigBase;
import io.helidon.webserver.observe.metrics.MetricsObserver;
import io.helidon.webserver.observe.metrics.MetricsObserverConfigBlueprint;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.observe.metrics.MetricsObserverConfigBlueprint")
public interface MetricsObserverConfig
extends MetricsObserverConfigBlueprint,
Prototype.Api,
ObserverConfigBase {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetricsObserverConfig instance) {
        return (Builder)((Object)MetricsObserverConfig.builder().from(instance));
    }

    public static MetricsObserverConfig create(Config config) {
        return ((Builder)MetricsObserverConfig.builder().config(config)).buildPrototype();
    }

    public static MetricsObserverConfig create() {
        return MetricsObserverConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, MetricsObserverConfig>
    implements io.helidon.common.Builder<Builder, MetricsObserver> {
        private Builder() {
        }

        public MetricsObserverConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.MetricsObserverConfigImpl(this);
        }

        public MetricsObserver build() {
            return MetricsObserver.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends MetricsObserverConfig>
    extends ObserverConfigBase.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private MeterRegistry meterRegistry;
        private MetricsConfig metricsConfig = MetricsConfig.create();
        private String endpoint = "metrics";

        protected BuilderBase() {
            this.name("metrics");
        }

        public BUILDER from(MetricsObserverConfig prototype) {
            super.from((ObserverConfigBase)prototype);
            this.endpoint(prototype.endpoint());
            this.metricsConfig(prototype.metricsConfig());
            this.meterRegistry(prototype.meterRegistry());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            this.endpoint(builder.endpoint());
            this.metricsConfig(builder.metricsConfig());
            builder.meterRegistry().ifPresent(this::meterRegistry);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            super.config(config);
            config.get("endpoint").as(String.class).ifPresent(this::endpoint);
            config.map(MetricsConfig::create).ifPresent(this::metricsConfig);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER endpoint(String endpoint) {
            Objects.requireNonNull(endpoint);
            this.endpoint = endpoint;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER metricsConfig(MetricsConfig metricsConfig) {
            Objects.requireNonNull(metricsConfig);
            this.metricsConfig = metricsConfig;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER metricsConfig(Consumer<MetricsConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            MetricsConfig.Builder builder = MetricsConfig.builder();
            consumer.accept(builder);
            this.metricsConfig(builder.build());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER metricsConfig(Supplier<? extends MetricsConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.metricsConfig(supplier.get());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearMeterRegistry() {
            this.meterRegistry = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER meterRegistry(MeterRegistry meterRegistry) {
            Objects.requireNonNull(meterRegistry);
            this.meterRegistry = meterRegistry;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public String endpoint() {
            return this.endpoint;
        }

        public MetricsConfig metricsConfig() {
            return this.metricsConfig;
        }

        public Optional<MeterRegistry> meterRegistry() {
            return Optional.ofNullable(this.meterRegistry);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "MetricsObserverConfigBuilder{endpoint=" + this.endpoint + ",metricsConfig=" + String.valueOf(this.metricsConfig) + ",meterRegistry=" + String.valueOf(this.meterRegistry) + "};" + super.toString();
        }

        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        protected void validatePrototype() {
            super.validatePrototype();
        }

        BUILDER meterRegistry(Optional<? extends MeterRegistry> meterRegistry) {
            Objects.requireNonNull(meterRegistry);
            this.meterRegistry = meterRegistry.map(MeterRegistry.class::cast).orElse(this.meterRegistry);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        protected static class MetricsObserverConfigImpl
        extends ObserverConfigBase.BuilderBase.ObserverConfigBaseImpl
        implements MetricsObserverConfig,
        Supplier<MetricsObserver> {
            private final MetricsConfig metricsConfig;
            private final Optional<MeterRegistry> meterRegistry;
            private final String endpoint;

            protected MetricsObserverConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.endpoint = builder.endpoint();
                this.metricsConfig = builder.metricsConfig();
                this.meterRegistry = builder.meterRegistry();
            }

            public MetricsObserver build() {
                return MetricsObserver.create(this);
            }

            @Override
            public MetricsObserver get() {
                return this.build();
            }

            @Override
            public String endpoint() {
                return this.endpoint;
            }

            @Override
            public MetricsConfig metricsConfig() {
                return this.metricsConfig;
            }

            @Override
            public Optional<MeterRegistry> meterRegistry() {
                return this.meterRegistry;
            }

            public String toString() {
                return "MetricsObserverConfig{endpoint=" + this.endpoint + ",metricsConfig=" + String.valueOf(this.metricsConfig) + ",meterRegistry=" + String.valueOf(this.meterRegistry) + "};" + super.toString();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MetricsObserverConfig)) {
                    return false;
                }
                MetricsObserverConfig other = (MetricsObserverConfig)o;
                return super.equals((Object)other) && Objects.equals(this.endpoint, other.endpoint()) && Objects.equals(this.metricsConfig, other.metricsConfig()) && Objects.equals(this.meterRegistry, other.meterRegistry());
            }

            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.endpoint, this.metricsConfig, this.meterRegistry);
            }
        }
    }
}

