/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.Builder;
import io.helidon.common.LazyValue;
import io.helidon.common.Weighted;
import io.helidon.common.Weights;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Router;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerToHttpFeatureBuilder;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.http.ErrorHandler;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.spi.ServerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class ServerFeatureContextImpl
implements ServerFeature.ServerFeatureContext {
    private final WebServerConfig serverConfig;
    private final Map<String, ListenerBuildersImpl> socketToBuilders;
    private final Set<String> configuredSockets;
    private final Map<String, ServerToHttpFeatureBuilder> inProgressBuilders;
    private final AtomicReference<Double> weight;

    private ServerFeatureContextImpl(WebServerConfig serverConfig, Map<String, ListenerBuildersImpl> socketToBuilders, AtomicReference<Double> weight) {
        this.serverConfig = serverConfig;
        this.socketToBuilders = socketToBuilders;
        this.configuredSockets = socketToBuilders.keySet().stream().filter(Predicate.not("@default"::equals)).collect(Collectors.toSet());
        this.weight = weight;
        this.inProgressBuilders = new HashMap<String, ServerToHttpFeatureBuilder>();
    }

    static ServerFeatureContextImpl create(WebServerConfig serverConfig) {
        AtomicReference<Double> weight = new AtomicReference<Double>();
        Map<String, List<Builder<?, ? extends Routing>>> routingMap = serverConfig.namedRoutings();
        Map<String, ListenerConfig> sockets = serverConfig.sockets();
        WeightedBuilder httpRouting = new WeightedBuilder(ServerFeatureContextImpl.defaultRouting(serverConfig), weight);
        List<Builder<?, ? extends Routing>> routings = serverConfig.routings();
        HashMap<String, ListenerBuildersImpl> socketToBuilders = new HashMap<String, ListenerBuildersImpl>();
        socketToBuilders.put("@default", new ListenerBuildersImpl("@default", serverConfig, httpRouting, routings));
        sockets.forEach((socketName, listener) -> {
            ArrayList builders = new ArrayList(listener.routings());
            List existingBuilders = (List)routingMap.get(socketName);
            if (existingBuilders != null) {
                builders.addAll(existingBuilders);
            }
            WeightedBuilder listenerHttpRouting = null;
            for (Builder builder : builders) {
                if (!(builder instanceof HttpRouting.Builder)) continue;
                HttpRouting.Builder httpBuilder = (HttpRouting.Builder)builder;
                listenerHttpRouting = new WeightedBuilder(httpBuilder, weight);
            }
            if (listenerHttpRouting == null) {
                listenerHttpRouting = new WeightedBuilder(listener.routing().orElseGet(HttpRouting::builder), weight);
                builders.add(listenerHttpRouting);
            }
            socketToBuilders.put((String)socketName, new ListenerBuildersImpl((String)socketName, serverConfig, listenerHttpRouting, builders));
        });
        return new ServerFeatureContextImpl(serverConfig, socketToBuilders, weight);
    }

    @Override
    public WebServerConfig serverConfig() {
        return this.serverConfig;
    }

    @Override
    public boolean socketExists(String socketName) {
        return "@default".equals(socketName) || this.configuredSockets.contains(socketName);
    }

    @Override
    public Set<String> sockets() {
        return this.configuredSockets;
    }

    @Override
    public ServerFeature.SocketBuilders socket(String socketName) {
        return Optional.ofNullable(this.socketToBuilders.get(socketName)).map(it -> this.socketBuilderDelegate(socketName, (ListenerBuildersImpl)it)).orElseThrow(() -> new NoSuchElementException("There is no socket configuration for socket named \"" + socketName + "\""));
    }

    void setUpFeature(ServerFeature feature) {
        this.weight(Weights.find((Object)feature, (double)100.0));
        feature.setup(this);
        this.inProgressBuilders.forEach(this::createHttpFeature);
        this.inProgressBuilders.clear();
        this.weight(100.0);
    }

    void weight(double weight) {
        this.weight.set(weight);
    }

    Router router(String socketName) {
        ListenerBuildersImpl listener = this.listenerBuilder(socketName);
        boolean containsHttp = listener.routings.stream().anyMatch(it -> it instanceof HttpRouting.Builder);
        Router.Builder builder = Router.builder();
        if (!containsHttp) {
            builder.addRouting(listener.httpRouting());
        }
        return (Router)((Router.Builder)builder.update(it -> listener.routings().forEach(it::addRouting))).build();
    }

    private static HttpRouting.Builder defaultRouting(WebServerConfig serverConfig) {
        HttpRouting.Builder httpRouting = serverConfig.routing().orElse(null);
        if (httpRouting == null) {
            List<Builder<?, Routing>> routings = serverConfig.routings();
            for (Builder<?, ? extends Routing> builder : routings) {
                HttpRouting.Builder httpBuilder;
                if (!(builder instanceof HttpRouting.Builder)) continue;
                httpRouting = httpBuilder = (HttpRouting.Builder)builder;
            }
            if (httpRouting == null) {
                httpRouting = HttpRouting.builder();
            }
        }
        return httpRouting;
    }

    private ServerFeature.SocketBuilders socketBuilderDelegate(final String socketName, final ListenerBuildersImpl listenerBuilders) {
        return new ServerFeature.SocketBuilders(){

            @Override
            public ListenerConfig listener() {
                return listenerBuilders.listener();
            }

            @Override
            public HttpRouting.Builder httpRouting() {
                return ServerFeatureContextImpl.this.inProgressBuilders.computeIfAbsent(socketName, it -> new ServerToHttpFeatureBuilder(ServerFeatureContextImpl.this.weight.get(), listenerBuilders.httpRouting()));
            }

            @Override
            public ServerFeature.RoutingBuilders routingBuilders() {
                final ServerFeature.RoutingBuilders delegate = listenerBuilders.routingBuilders();
                return new ServerFeature.RoutingBuilders(){

                    @Override
                    public boolean hasRouting(Class<?> builderType) {
                        return delegate.hasRouting(builderType);
                    }

                    @Override
                    public <T extends Builder<T, ?>> T routingBuilder(Class<T> builderType) {
                        if (builderType.equals(HttpRouting.class)) {
                            return (T)this.httpRouting();
                        }
                        return delegate.routingBuilder(builderType);
                    }
                };
            }
        };
    }

    private ListenerBuildersImpl listenerBuilder(String socketName) {
        return Optional.ofNullable(this.socketToBuilders.get(socketName)).orElseThrow(() -> new NoSuchElementException("There is no socket configuration for socket named \"" + socketName + "\""));
    }

    private void createHttpFeature(String socket, ServerToHttpFeatureBuilder builder) {
        this.socket(socket).httpRouting().addFeature(builder.toFeature());
    }

    private static class WeightedBuilder
    implements HttpRouting.Builder {
        private final HttpRouting.Builder delegate;
        private final AtomicReference<Double> weight;

        private WeightedBuilder(HttpRouting.Builder delegate, AtomicReference<Double> weight) {
            this.delegate = delegate;
            this.weight = weight;
        }

        @Override
        public HttpRouting.Builder register(HttpService ... services) {
            this.delegate.register(services);
            return this;
        }

        @Override
        public HttpRouting.Builder register(String path, HttpService ... services) {
            this.delegate.register(path, services);
            return this;
        }

        @Override
        public HttpRouting.Builder route(HttpRoute route) {
            this.delegate.route(route);
            return this;
        }

        @Override
        public HttpRouting.Builder addFilter(Filter filter) {
            this.delegate.addFilter(filter);
            return this;
        }

        @Override
        public HttpRouting.Builder addFeature(HttpFeature feature) {
            double foundWeight = Weights.find((Object)feature, (double)-1.0);
            if (foundWeight == -1.0) {
                this.delegate.addFeature(new WeightedHttpFeature(feature, this.weight.get()));
            } else {
                this.delegate.addFeature(feature);
            }
            return this;
        }

        @Override
        public HttpRouting.Builder addFeature(Supplier<? extends HttpFeature> feature) {
            if (feature instanceof HttpFeature) {
                HttpFeature h = (HttpFeature)feature;
                return this.addFeature(h);
            }
            this.delegate.addFeature(new WeightedHttpFeature(feature, this.weight.get()));
            return this;
        }

        @Override
        public <T extends Throwable> HttpRouting.Builder error(Class<T> exceptionClass, ErrorHandler<? super T> handler) {
            this.delegate.error(exceptionClass, handler);
            return this;
        }

        @Override
        public HttpRouting.Builder maxReRouteCount(int maxReRouteCount) {
            this.delegate.maxReRouteCount(maxReRouteCount);
            return this;
        }

        @Override
        public HttpRouting.Builder security(HttpSecurity security) {
            this.delegate.security(security);
            return this;
        }

        @Override
        public HttpRouting.Builder copy() {
            this.delegate.copy();
            return this;
        }

        public HttpRouting build() {
            return (HttpRouting)this.delegate.build();
        }
    }

    private static class ListenerBuildersImpl
    implements ServerFeature.SocketBuilders {
        private final ListenerConfig listenerConfig;
        private final HttpRouting.Builder httpRouting;
        private final List<Builder<?, ? extends Routing>> routings;
        private final ServerFeature.RoutingBuilders routingBuilders;

        ListenerBuildersImpl(String socketName, ListenerConfig listenerConfig, HttpRouting.Builder httpRouting, List<Builder<?, ? extends Routing>> routings) {
            this.listenerConfig = listenerConfig;
            this.httpRouting = httpRouting;
            this.routings = routings;
            this.routingBuilders = RoutingBuildersImpl.create(socketName, routings);
        }

        @Override
        public ListenerConfig listener() {
            return this.listenerConfig;
        }

        @Override
        public HttpRouting.Builder httpRouting() {
            return this.httpRouting;
        }

        @Override
        public ServerFeature.RoutingBuilders routingBuilders() {
            return this.routingBuilders;
        }

        List<Builder<?, ? extends Routing>> routings() {
            return this.routings;
        }
    }

    private static final class WeightedHttpFeature
    implements HttpFeature,
    Weighted {
        private final LazyValue<? extends HttpFeature> delegate;
        private final double weight;

        private WeightedHttpFeature(Supplier<? extends HttpFeature> delegate, double weight) {
            this.delegate = LazyValue.create(delegate);
            this.weight = weight;
        }

        @Override
        public void setup(HttpRouting.Builder routing) {
            ((HttpFeature)this.delegate.get()).setup(routing);
        }

        @Override
        public String socket() {
            return ((HttpFeature)this.delegate.get()).socket();
        }

        @Override
        public boolean socketRequired() {
            return ((HttpFeature)this.delegate.get()).socketRequired();
        }

        @Override
        public void beforeStart() {
            ((HttpFeature)this.delegate.get()).beforeStart();
        }

        @Override
        public void afterStart(WebServer webServer) {
            ((HttpFeature)this.delegate.get()).afterStart(webServer);
        }

        @Override
        public void afterStop() {
            ((HttpFeature)this.delegate.get()).afterStop();
        }

        public double weight() {
            return this.weight;
        }
    }

    private static class RoutingBuildersImpl
    implements ServerFeature.RoutingBuilders {
        private final String socketName;
        private final Map<Class<?>, Object> buildersByType;

        RoutingBuildersImpl(String socketName, Map<Class<?>, Object> builders) {
            this.socketName = socketName;
            this.buildersByType = builders;
        }

        static ServerFeature.RoutingBuilders create(String socketName, List<Builder<?, ? extends Routing>> routings) {
            IdentityHashMap byType = new IdentityHashMap();
            for (Builder<?, Routing> builder : routings) {
                byType.put(builder.getClass(), builder);
            }
            return new RoutingBuildersImpl(socketName, byType);
        }

        @Override
        public boolean hasRouting(Class<?> builderType) {
            return this.buildersByType.containsKey(builderType);
        }

        @Override
        public <T extends Builder<T, ?>> T routingBuilder(Class<T> builderType) {
            Optional<Object> result = Optional.ofNullable(this.buildersByType.get(builderType));
            if (result.isPresent()) {
                return (T)((Builder)builderType.cast(result.get()));
            }
            throw new NoSuchElementException("There is no routing builder of type " + builderType.getName() + " available on socket \"" + this.socketName + "\"");
        }
    }
}

