/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.common.media.type.MediaType;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.InternalServerException;
import io.helidon.http.Method;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.staticcontent.CachedHandler;
import io.helidon.webserver.staticcontent.CachedHandlerInMemory;
import io.helidon.webserver.staticcontent.CachedHandlerJar;
import io.helidon.webserver.staticcontent.CachedHandlerRedirect;
import io.helidon.webserver.staticcontent.CachedHandlerUrlStream;
import io.helidon.webserver.staticcontent.ClasspathHandlerConfig;
import io.helidon.webserver.staticcontent.FileBasedContentHandler;
import io.helidon.webserver.staticcontent.StaticContentService;
import io.helidon.webserver.staticcontent.TemporaryStorage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class ClassPathContentHandler
extends FileBasedContentHandler {
    private static final System.Logger LOGGER = System.getLogger(ClassPathContentHandler.class.getName());
    private final AtomicBoolean populatedInMemoryCache = new AtomicBoolean();
    private final ClassLoader classLoader;
    private final String root;
    private final String rootWithTrailingSlash;
    private final Set<String> cacheInMemory;
    private final TemporaryStorage tmpStorage;

    ClassPathContentHandler(ClasspathHandlerConfig config) {
        super(config);
        this.classLoader = config.classLoader().orElseGet(() -> Thread.currentThread().getContextClassLoader());
        this.cacheInMemory = new HashSet<String>(config.cachedFiles());
        this.root = ClassPathContentHandler.cleanRoot(config.location());
        this.rootWithTrailingSlash = this.root + "/";
        this.tmpStorage = config.temporaryStorage().orElseGet(TemporaryStorage::create);
    }

    static StaticContentService create(ClasspathHandlerConfig config) {
        return new ClassPathContentHandler(config);
    }

    @Override
    public void beforeStart() {
        if (this.populatedInMemoryCache.compareAndSet(false, true)) {
            for (String resource : this.cacheInMemory) {
                try {
                    this.addToInMemoryCache(resource);
                }
                catch (Exception e) {
                    LOGGER.log(System.Logger.Level.WARNING, "Failed to add file to in-memory cache", (Throwable)e);
                }
            }
        }
        super.beforeStart();
    }

    @Override
    void releaseCache() {
        this.populatedInMemoryCache.set(false);
    }

    @Override
    boolean doHandle(Method method, String requestedPath, ServerRequest request, ServerResponse response, boolean mapped) throws IOException, URISyntaxException {
        Optional<CachedHandler> handler;
        String welcomeFileResource;
        Object welcomeUrl;
        String rawPath = request.prologue().uriPath().rawPath();
        String requestedResource = this.requestedResource(rawPath, requestedPath, mapped);
        if (!requestedResource.equals(this.root) && !requestedResource.startsWith(this.rootWithTrailingSlash)) {
            return false;
        }
        Optional<CachedHandler> cached = this.cacheHandler(requestedResource);
        if (cached.isPresent()) {
            return cached.get().handle(this.handlerCache(), method, request, response, requestedResource);
        }
        Object url = this.classLoader.getResource(requestedResource);
        String welcomeFileName = this.welcomePageName();
        if (welcomeFileName != null && (welcomeUrl = this.classLoader.getResource(welcomeFileResource = requestedResource + (requestedResource.endsWith("/") ? "" : "/") + welcomeFileName)) != null) {
            if (rawPath.endsWith("/")) {
                Optional<CachedHandlerInMemory> inMemoryMaybe = this.cacheInMemory(welcomeFileResource);
                if (inMemoryMaybe.isPresent()) {
                    this.cacheInMemory(requestedResource, inMemoryMaybe.get());
                    return inMemoryMaybe.get().handle(this.handlerCache(), method, request, response, requestedResource);
                }
                url = welcomeUrl;
            } else {
                String redirectLocation = rawPath + "/";
                CachedHandlerRedirect handler2 = new CachedHandlerRedirect(redirectLocation);
                this.cacheHandler(requestedResource, handler2);
                return handler2.handle(this.handlerCache(), method, request, response, requestedResource);
            }
        }
        if (url == null || ((URL)url).getPath().endsWith("/")) {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Requested resource " + requestedResource + " does not exist or is a directory without welcome file.");
            }
            return false;
        }
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Located resource url. Resource: " + requestedResource + ", URL: " + String.valueOf(url));
        }
        switch (((URL)url).getProtocol()) {
            case "file": {
                Optional<CachedHandler> optional = this.fileHandler(Paths.get(((URL)url).toURI()));
                break;
            }
            case "jar": {
                Optional<CachedHandler> optional = this.jarHandler(requestedResource, (URL)url);
                break;
            }
            default: {
                Optional<CachedHandler> optional = handler = this.urlStreamHandler((URL)url);
            }
        }
        if (handler.isEmpty()) {
            return false;
        }
        CachedHandler cachedHandler = handler.get();
        this.cacheHandler(requestedResource, cachedHandler);
        return cachedHandler.handle(this.handlerCache(), method, request, response, requestedResource);
    }

    private static String fileName(URL url) {
        String path = url.getPath();
        int index = path.lastIndexOf(47);
        if (index > -1) {
            return path.substring(index + 1);
        }
        return path;
    }

    private String requestedResource(String rawPath, String requestedPath, boolean mapped) throws URISyntaxException {
        String resource;
        String string = resource = requestedPath.isEmpty() || "/".equals(requestedPath) ? this.root : this.rootWithTrailingSlash + requestedPath;
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Requested class path resource: " + resource);
        }
        URI myuri = new URI(null, null, resource, null);
        String result = myuri.normalize().getPath();
        if (mapped) {
            return result;
        }
        return rawPath.endsWith("/") ? result + "/" : result;
    }

    private Optional<CachedHandler> jarHandler(String requestedResource, URL url) throws IOException {
        Optional<CachedHandlerInMemory> cached;
        Optional<Instant> lastModified;
        JarURLConnection jarUrlConnection = (JarURLConnection)url.openConnection();
        JarEntry jarEntry = jarUrlConnection.getJarEntry();
        if (jarEntry.isDirectory()) {
            return Optional.empty();
        }
        long contentLength = jarEntry.getSize();
        MediaType contentType = this.detectType(ClassPathContentHandler.fileName(url));
        try (JarFile jarFile = jarUrlConnection.getJarFile();){
            lastModified = this.lastModified(jarFile.getName());
        }
        BiConsumer<ServerResponseHeaders, Instant> lastModifiedHandler = this.lastModifiedHandler(lastModified);
        if (contentLength <= Integer.MAX_VALUE && this.canCacheInMemory((int)contentLength) && (cached = this.cacheInMemory(requestedResource, (int)contentLength, this.inMemorySupplier(url, lastModified.orElse(null), lastModifiedHandler, contentType, contentLength))).isPresent()) {
            return Optional.of((CachedHandler)cached.get());
        }
        CachedHandlerJar jarHandler = CachedHandlerJar.create(this.tmpStorage, url, lastModified.orElse(null), contentType, contentLength);
        return Optional.of(jarHandler);
    }

    private BiConsumer<ServerResponseHeaders, Instant> lastModifiedHandler(Optional<Instant> lastModified) {
        if (lastModified.isPresent()) {
            Header lastModifiedHeader = HeaderValues.create((HeaderName)HeaderNames.LAST_MODIFIED, (boolean)true, (boolean)false, (String[])new String[]{ClassPathContentHandler.formatLastModified(lastModified.get())});
            return (headers, instant) -> headers.set(lastModifiedHeader);
        }
        return (headers, instant) -> {};
    }

    private Supplier<CachedHandlerInMemory> inMemorySupplier(URL url, Instant lastModified, BiConsumer<ServerResponseHeaders, Instant> lastModifiedHandler, MediaType contentType, long contentLength) {
        Header contentLengthHeader = HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (long)contentLength);
        return () -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (InputStream in = url.openStream();){
                in.transferTo(baos);
            }
            catch (IOException e) {
                throw new InternalServerException("Cannot load resource", (Throwable)e);
            }
            byte[] bytes = baos.toByteArray();
            return new CachedHandlerInMemory(contentType, lastModified, lastModifiedHandler, bytes, bytes.length, contentLengthHeader);
        };
    }

    private Optional<CachedHandler> urlStreamHandler(URL url) {
        return Optional.of(new CachedHandlerUrlStream(this.detectType(ClassPathContentHandler.fileName(url)), url));
    }

    private void addToInMemoryCache(String resource) throws IOException {
        String requestedResource;
        try {
            requestedResource = this.requestedResource("", resource, true);
        }
        catch (URISyntaxException e) {
            LOGGER.log(System.Logger.Level.WARNING, "Resource " + resource + " cannot be added to in memory cache, as it is not a valid identifier", (Throwable)e);
            return;
        }
        if (!requestedResource.equals(this.root) && !requestedResource.startsWith(this.rootWithTrailingSlash)) {
            LOGGER.log(System.Logger.Level.WARNING, "Resource " + resource + " cannot be added to in memory cache, as it is not within the resource root directory.");
            return;
        }
        URL url = this.classLoader.getResource(requestedResource);
        if (url == null) {
            LOGGER.log(System.Logger.Level.WARNING, "Resource " + resource + " cannot be added to in memory cache, as it does not exist on classpath");
            return;
        }
        Optional<Instant> lastModified = this.lastModified(url);
        MediaType contentType = this.detectType(ClassPathContentHandler.fileName(url));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream in = url.openStream();){
            in.transferTo(baos);
        }
        byte[] entityBytes = baos.toByteArray();
        this.cacheInMemory(requestedResource, contentType, entityBytes, lastModified);
    }

    private Optional<Instant> lastModified(URL url) {
        try {
            return switch (url.getProtocol()) {
                case "file" -> ClassPathContentHandler.lastModified(Paths.get(url.toURI()));
                case "jar" -> this.lastModifiedFromJar(url);
                default -> Optional.empty();
            };
        }
        catch (IOException | URISyntaxException e) {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Failed to get last modification of a file for URL: " + String.valueOf(url), (Throwable)e);
            }
            return Optional.empty();
        }
    }

    private Optional<Instant> lastModifiedFromJar(URL url) throws IOException {
        JarURLConnection jarUrlConnection = (JarURLConnection)url.openConnection();
        JarFile jarFile = jarUrlConnection.getJarFile();
        return this.lastModified(jarFile.getName());
    }

    private Optional<Instant> lastModified(String path) throws IOException {
        return ClassPathContentHandler.lastModified(Paths.get(path, new String[0]));
    }

    private static String cleanRoot(String location) {
        String cleanRoot = location;
        if (cleanRoot.startsWith("/")) {
            cleanRoot = cleanRoot.substring(1);
        }
        while (cleanRoot.endsWith("/")) {
            cleanRoot = cleanRoot.substring(0, cleanRoot.length() - 1);
        }
        if (cleanRoot.isEmpty()) {
            throw new IllegalArgumentException("Cannot serve full classpath, please configure a classpath prefix");
        }
        return cleanRoot;
    }
}

