/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.security;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.Weighted;
import io.helidon.security.Security;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.security.PathsConfig;
import io.helidon.webserver.security.SecurityFeatureConfig;
import io.helidon.webserver.security.SecurityHandler;
import io.helidon.webserver.security.SecurityHandlerConfig;
import io.helidon.webserver.security.SecurityHttpFeature;
import io.helidon.webserver.spi.ServerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=SecurityFeatureConfig.class)
public class SecurityFeature
implements Weighted,
ServerFeature,
RuntimeType.Api<SecurityFeatureConfig> {
    static final double WEIGHT = 800.0;
    static final String SECURITY_ID = "security";
    private static final System.Logger LOGGER = System.getLogger(SecurityFeature.class.getName());
    private final Security security;
    private final SecurityFeatureConfig featureConfig;

    private SecurityFeature(SecurityFeatureConfig featureConfig) {
        this.security = featureConfig.security();
        this.featureConfig = featureConfig;
    }

    public static SecurityFeatureConfig.Builder builder() {
        return SecurityFeatureConfig.builder();
    }

    public static SecurityFeature create(SecurityFeatureConfig config) {
        return new SecurityFeature(config);
    }

    public static SecurityFeature create(Consumer<SecurityFeatureConfig.Builder> builderConsumer) {
        return ((SecurityFeatureConfig.Builder)SecurityFeature.builder().update(builderConsumer)).build();
    }

    public static SecurityHandler secure() {
        return SecurityHandler.create().authenticate().authorize();
    }

    public static SecurityHandler authenticate() {
        return SecurityHandler.create().authenticate();
    }

    public static SecurityHandler audit() {
        return SecurityHandler.create().audit();
    }

    public static SecurityHandler authenticator(String explicitAuthenticator) {
        return SecurityHandler.create().authenticate().authenticator(explicitAuthenticator);
    }

    public static SecurityHandler authorizer(String explicitAuthorizer) {
        return SecurityHandler.create().authenticate().authorize().authorizer(explicitAuthorizer);
    }

    public static SecurityHandler rolesAllowed(String ... roles) {
        return SecurityHandler.create().rolesAllowed(roles);
    }

    public static SecurityHandler allowAnonymous() {
        return SecurityHandler.create().authenticate().authenticationOptional();
    }

    public static SecurityHandler authorize() {
        return SecurityHandler.create().authorize();
    }

    public static SecurityHandler enforce() {
        return SecurityHandler.create();
    }

    public SecurityFeatureConfig prototype() {
        return this.featureConfig;
    }

    public String name() {
        return this.featureConfig.name();
    }

    public String type() {
        return SECURITY_ID;
    }

    public void setup(ServerFeature.ServerFeatureContext featureContext) {
        if (!this.security.enabled()) {
            LOGGER.log(System.Logger.Level.TRACE, "Security is disabled. Not registering any security handlers");
            return;
        }
        SecurityHandler defaults = this.featureConfig.defaults();
        HashSet<String> defaultSockets = new HashSet<String>();
        SecurityHandlerConfig defaultConfig = defaults.prototype();
        if (defaultConfig.sockets().isEmpty()) {
            defaultSockets.addAll(featureContext.sockets());
            defaultSockets.add("@default");
        } else {
            defaultSockets.addAll(defaultConfig.sockets());
        }
        HashMap<String, List> configurations = new HashMap<String, List>();
        List<PathsConfig> paths = this.featureConfig.paths();
        for (PathsConfig path : paths) {
            ArrayList<String> sockets = new ArrayList<String>(path.sockets());
            if (sockets.isEmpty()) {
                sockets.addAll(defaultSockets);
            }
            for (String socket : sockets) {
                configurations.computeIfAbsent(socket, it -> new ArrayList()).add(path);
            }
        }
        HashSet<String> allSockets = new HashSet<String>(featureContext.sockets());
        allSockets.add("@default");
        configurations.forEach((socketName, configs) -> {
            if (featureContext.socketExists(socketName)) {
                allSockets.remove(socketName);
                ServerFeature.SocketBuilders socket = featureContext.socket(socketName);
                SecurityHttpFeature routingFeature = this.routingFeature(defaults, (List<PathsConfig>)configs);
                socket.httpRouting().addFeature((HttpFeature)routingFeature);
            }
        });
        for (String allSocket : allSockets) {
            ServerFeature.SocketBuilders socket = featureContext.socket(allSocket);
            SecurityHttpFeature routingFeature = this.routingFeature(defaults, List.of());
            socket.httpRouting().addFeature((HttpFeature)routingFeature);
        }
    }

    SecurityHttpFeature routingFeature() {
        SecurityHandler defaults = this.featureConfig.defaults();
        ArrayList<PathsConfig> configurations = new ArrayList<PathsConfig>();
        List<PathsConfig> paths = this.featureConfig.paths();
        for (PathsConfig path : paths) {
            ArrayList<String> sockets = new ArrayList<String>(path.sockets());
            if (!sockets.isEmpty() && !sockets.contains("@default")) continue;
            configurations.add(path);
        }
        return SecurityHttpFeature.create(this.security, this.featureConfig.weight(), defaults, configurations);
    }

    public double weight() {
        return this.featureConfig.weight();
    }

    private SecurityHttpFeature routingFeature(SecurityHandler defaults, List<PathsConfig> configs) {
        return SecurityHttpFeature.create(this.security, this.featureConfig.weight(), defaults, configs);
    }
}

