/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.config;

import io.helidon.common.config.Config;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.Traceable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class ComponentTracingConfig
extends Traceable {
    public static final ComponentTracingConfig DISABLED = ComponentTracingConfig.builder("disabled").enabled(false).build();
    public static final ComponentTracingConfig ENABLED = ComponentTracingConfig.builder("enabled").build();

    protected ComponentTracingConfig(String name) {
        super(name);
    }

    static ComponentTracingConfig merge(final ComponentTracingConfig older, final ComponentTracingConfig newer) {
        return new ComponentTracingConfig(newer.name()){

            @Override
            public Optional<SpanTracingConfig> getSpan(String spanName) {
                if (!this.enabled()) {
                    return Optional.of(SpanTracingConfig.DISABLED);
                }
                Optional<SpanTracingConfig> newSpan = newer.getSpan(spanName);
                Optional<SpanTracingConfig> oldSpan = older.getSpan(spanName);
                if (newSpan.isPresent() && oldSpan.isPresent()) {
                    return Optional.of(SpanTracingConfig.merge(oldSpan.get(), newSpan.get()));
                }
                if (newSpan.isPresent()) {
                    return newSpan;
                }
                return oldSpan;
            }

            @Override
            public Optional<Boolean> isEnabled() {
                return newer.isEnabled().or(older::isEnabled);
            }
        };
    }

    protected abstract Optional<SpanTracingConfig> getSpan(String var1);

    public SpanTracingConfig span(String spanName) {
        return this.span(spanName, true);
    }

    public SpanTracingConfig span(String spanName, boolean enabledByDefault) {
        if (this.enabled()) {
            return this.getSpan(spanName).orElseGet(() -> enabledByDefault ? SpanTracingConfig.ENABLED : SpanTracingConfig.DISABLED);
        }
        return SpanTracingConfig.DISABLED;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static ComponentTracingConfig create(String name, Config config) {
        return ComponentTracingConfig.builder(name).config(config).build();
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, ComponentTracingConfig> {
        private final Map<String, SpanTracingConfig> tracedSpans = new HashMap<String, SpanTracingConfig>();
        private Optional<Boolean> enabled = Optional.empty();
        private final String name;

        private Builder(String name) {
            this.name = name;
        }

        public ComponentTracingConfig build() {
            final Optional<Boolean> finalEnabled = this.enabled;
            final HashMap<String, SpanTracingConfig> finalSpans = new HashMap<String, SpanTracingConfig>(this.tracedSpans);
            return new ComponentTracingConfig(this.name){

                @Override
                public Optional<SpanTracingConfig> getSpan(String spanName) {
                    if (enabled.orElse(true).booleanValue()) {
                        return Optional.ofNullable((SpanTracingConfig)finalSpans.get(spanName));
                    }
                    return Optional.of(SpanTracingConfig.DISABLED);
                }

                @Override
                public Optional<Boolean> isEnabled() {
                    return finalEnabled;
                }
            };
        }

        public Builder config(Config config) {
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            config.get("spans").asNodeList().ifPresent(spanConfigList -> spanConfigList.forEach(spanConfig -> this.addSpan(SpanTracingConfig.create((String)spanConfig.get("name").asString().get(), spanConfig))));
            return this;
        }

        public Builder addSpan(SpanTracingConfig span) {
            this.tracedSpans.put(span.name(), span);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(enabled);
            return this;
        }
    }
}

