/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.GenericType;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.DependencyBlueprint;
import io.helidon.service.registry.DependencyCardinality;
import io.helidon.service.registry.Qualifier;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.service.registry.DependencyBlueprint")
public interface Dependency
extends DependencyBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Dependency instance) {
        return (Builder)Dependency.builder().from(instance);
    }

    public static Dependency create() {
        return Dependency.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, Dependency>
    implements io.helidon.common.Builder<Builder, Dependency> {
        private Builder() {
        }

        public Dependency buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.DependencyImpl(this);
        }

        public Dependency build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Dependency>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Set<Qualifier> qualifiers = new LinkedHashSet<Qualifier>();
        private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();
        private AccessModifier access = AccessModifier.PACKAGE_PRIVATE;
        private boolean isServiceInstance;
        private boolean isSupplier;
        private DependencyCardinality cardinality = DependencyCardinality.REQUIRED;
        private ElementKind elementKind = ElementKind.CONSTRUCTOR;
        private GenericType<?> contractType = GenericType.OBJECT;
        private String descriptorConstant;
        private String method;
        private String name;
        private TypeName contract;
        private TypeName descriptor;
        private TypeName service;
        private TypeName typeName;

        protected BuilderBase() {
        }

        public BUILDER from(Dependency prototype) {
            this.service(prototype.service());
            this.name(prototype.name());
            this.contract(prototype.contract());
            this.contractType(prototype.contractType());
            this.descriptor(prototype.descriptor());
            this.descriptorConstant(prototype.descriptorConstant());
            this.typeName(prototype.typeName());
            this.elementKind(prototype.elementKind());
            this.addQualifiers(prototype.qualifiers());
            this.access(prototype.access());
            this.addAnnotations(prototype.annotations());
            this.method(prototype.method());
            this.cardinality(prototype.cardinality());
            this.isServiceInstance(prototype.isServiceInstance());
            this.isSupplier(prototype.isSupplier());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.service().ifPresent(this::service);
            builder.name().ifPresent(this::name);
            builder.contract().ifPresent(this::contract);
            this.contractType(builder.contractType());
            builder.descriptor().ifPresent(this::descriptor);
            builder.descriptorConstant().ifPresent(this::descriptorConstant);
            builder.typeName().ifPresent(this::typeName);
            this.elementKind(builder.elementKind());
            this.addQualifiers(builder.qualifiers);
            this.access(builder.access());
            this.addAnnotations(builder.annotations);
            builder.method().ifPresent(this::method);
            this.cardinality(builder.cardinality());
            this.isServiceInstance(builder.isServiceInstance());
            this.isSupplier(builder.isSupplier());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER service(TypeName service) {
            Objects.requireNonNull(service);
            this.service = service;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER service(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.service(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER service(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.service(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contract(TypeName contract) {
            Objects.requireNonNull(contract);
            this.contract = contract;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contract(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.contract(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contract(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.contract(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contractType(GenericType<?> contractType) {
            Objects.requireNonNull(contractType);
            this.contractType = contractType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER descriptor(TypeName descriptor) {
            Objects.requireNonNull(descriptor);
            this.descriptor = descriptor;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER descriptor(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.descriptor(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER descriptor(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.descriptor(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER descriptorConstant(String descriptorConstant) {
            Objects.requireNonNull(descriptorConstant);
            this.descriptorConstant = descriptorConstant;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(TypeName typeName) {
            Objects.requireNonNull(typeName);
            this.typeName = typeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.typeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.typeName(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementKind(ElementKind elementKind) {
            Objects.requireNonNull(elementKind);
            this.elementKind = elementKind;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER qualifiers(Set<? extends Qualifier> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.qualifiers.clear();
            this.qualifiers.addAll(qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifiers(Set<? extends Qualifier> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.qualifiers.addAll(qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifier(Qualifier qualifier) {
            Objects.requireNonNull(qualifier);
            this.qualifiers.add(qualifier);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifier(Consumer<Qualifier.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Qualifier.Builder builder = Qualifier.builder();
            consumer.accept(builder);
            this.qualifiers.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER access(AccessModifier access) {
            Objects.requireNonNull(access);
            this.access = access;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER annotations(Set<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.annotations.clear();
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotations(Set<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Annotation annotation) {
            Objects.requireNonNull(annotation);
            this.annotations.add(annotation);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.annotations.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMethod() {
            this.method = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(String method) {
            Objects.requireNonNull(method);
            this.method = method;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cardinality(DependencyCardinality cardinality) {
            Objects.requireNonNull(cardinality);
            this.cardinality = cardinality;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER isServiceInstance(boolean isServiceInstance) {
            this.isServiceInstance = isServiceInstance;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER isSupplier(boolean isSupplier) {
            this.isSupplier = isSupplier;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypeName> service() {
            return Optional.ofNullable(this.service);
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<TypeName> contract() {
            return Optional.ofNullable(this.contract);
        }

        public GenericType<?> contractType() {
            return this.contractType;
        }

        public Optional<TypeName> descriptor() {
            return Optional.ofNullable(this.descriptor);
        }

        public Optional<String> descriptorConstant() {
            return Optional.ofNullable(this.descriptorConstant);
        }

        public Optional<TypeName> typeName() {
            return Optional.ofNullable(this.typeName);
        }

        public ElementKind elementKind() {
            return this.elementKind;
        }

        public Set<Qualifier> qualifiers() {
            return this.qualifiers;
        }

        public AccessModifier access() {
            return this.access;
        }

        public Set<Annotation> annotations() {
            return this.annotations;
        }

        public Optional<String> method() {
            return Optional.ofNullable(this.method);
        }

        public DependencyCardinality cardinality() {
            return this.cardinality;
        }

        public boolean isServiceInstance() {
            return this.isServiceInstance;
        }

        public boolean isSupplier() {
            return this.isSupplier;
        }

        public String toString() {
            return "DependencyBuilder{service=" + String.valueOf(this.service) + ",name=" + this.name + ",typeName=" + String.valueOf(this.typeName) + ",elementKind=" + String.valueOf(this.elementKind) + ",qualifiers=" + String.valueOf(this.qualifiers) + ",method=" + this.method + ",cardinality=" + String.valueOf((Object)this.cardinality) + ",isServiceInstance=" + this.isServiceInstance + ",isSupplier=" + this.isSupplier + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.service == null) {
                collector.fatal(this.getClass(), "Property \"service\" must not be null, but not set");
            }
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            if (this.contract == null) {
                collector.fatal(this.getClass(), "Property \"contract\" must not be null, but not set");
            }
            if (this.descriptor == null) {
                collector.fatal(this.getClass(), "Property \"descriptor\" must not be null, but not set");
            }
            if (this.descriptorConstant == null) {
                collector.fatal(this.getClass(), "Property \"descriptorConstant\" must not be null, but not set");
            }
            if (this.typeName == null) {
                collector.fatal(this.getClass(), "Property \"typeName\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER method(Optional<String> method) {
            Objects.requireNonNull(method);
            this.method = method.map(String.class::cast).orElse(this.method);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class DependencyImpl
        implements Dependency {
            private final AccessModifier access;
            private final boolean isServiceInstance;
            private final boolean isSupplier;
            private final DependencyCardinality cardinality;
            private final ElementKind elementKind;
            private final GenericType<?> contractType;
            private final Optional<String> method;
            private final Set<Qualifier> qualifiers;
            private final Set<Annotation> annotations;
            private final String descriptorConstant;
            private final String name;
            private final TypeName contract;
            private final TypeName descriptor;
            private final TypeName service;
            private final TypeName typeName;

            protected DependencyImpl(BuilderBase<?, ?> builder) {
                this.service = builder.service().get();
                this.name = builder.name().get();
                this.contract = builder.contract().get();
                this.contractType = builder.contractType();
                this.descriptor = builder.descriptor().get();
                this.descriptorConstant = builder.descriptorConstant().get();
                this.typeName = builder.typeName().get();
                this.elementKind = builder.elementKind();
                this.qualifiers = Collections.unmodifiableSet(new LinkedHashSet<Qualifier>(builder.qualifiers()));
                this.access = builder.access();
                this.annotations = Collections.unmodifiableSet(new LinkedHashSet<Annotation>(builder.annotations()));
                this.method = builder.method();
                this.cardinality = builder.cardinality();
                this.isServiceInstance = builder.isServiceInstance();
                this.isSupplier = builder.isSupplier();
            }

            @Override
            public TypeName service() {
                return this.service;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public TypeName contract() {
                return this.contract;
            }

            @Override
            public GenericType<?> contractType() {
                return this.contractType;
            }

            @Override
            public TypeName descriptor() {
                return this.descriptor;
            }

            @Override
            public String descriptorConstant() {
                return this.descriptorConstant;
            }

            @Override
            public TypeName typeName() {
                return this.typeName;
            }

            @Override
            public ElementKind elementKind() {
                return this.elementKind;
            }

            @Override
            public Set<Qualifier> qualifiers() {
                return this.qualifiers;
            }

            @Override
            public AccessModifier access() {
                return this.access;
            }

            @Override
            public Set<Annotation> annotations() {
                return this.annotations;
            }

            @Override
            public Optional<String> method() {
                return this.method;
            }

            @Override
            public DependencyCardinality cardinality() {
                return this.cardinality;
            }

            @Override
            public boolean isServiceInstance() {
                return this.isServiceInstance;
            }

            @Override
            public boolean isSupplier() {
                return this.isSupplier;
            }

            public String toString() {
                return "Dependency{service=" + String.valueOf(this.service) + ",name=" + this.name + ",typeName=" + String.valueOf(this.typeName) + ",elementKind=" + String.valueOf(this.elementKind) + ",qualifiers=" + String.valueOf(this.qualifiers) + ",method=" + String.valueOf(this.method) + ",cardinality=" + String.valueOf((Object)this.cardinality) + ",isServiceInstance=" + this.isServiceInstance + ",isSupplier=" + this.isSupplier + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dependency)) {
                    return false;
                }
                Dependency other = (Dependency)o;
                return Objects.equals(this.service, other.service()) && Objects.equals(this.name, other.name()) && Objects.equals(this.elementKind, other.elementKind()) && Objects.equals((Object)this.cardinality, (Object)other.cardinality()) && this.isServiceInstance == other.isServiceInstance() && this.isSupplier == other.isSupplier();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.service, this.name, this.elementKind, this.cardinality, this.isServiceInstance, this.isSupplier});
            }
        }
    }
}

