/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.util.Objects;

public final class ServiceSuperType {
    private final TypeInfo typeInfo;
    private final TypeName descriptorTypeName;

    private ServiceSuperType(TypeInfo typeInfo, TypeName descriptoryTypeName) {
        this.descriptorTypeName = descriptoryTypeName;
        this.typeInfo = typeInfo;
    }

    public static ServiceSuperType create(TypeInfo typeInfo, TypeName descriptorTypeName) {
        Objects.requireNonNull(typeInfo);
        Objects.requireNonNull(descriptorTypeName);
        return new ServiceSuperType(typeInfo, descriptorTypeName);
    }

    public static ServiceSuperType create() {
        return new ServiceSuperType(null, null);
    }

    public boolean present() {
        return this.typeInfo != null;
    }

    public boolean empty() {
        return this.typeInfo == null;
    }

    public TypeInfo typeInfo() {
        if (this.typeInfo == null) {
            throw new IllegalStateException("TypeInfo is only available if a service has a valid super type, please guard with SuperServiceType#present().");
        }
        return this.typeInfo;
    }

    public TypeName descriptorType() {
        if (this.typeInfo == null) {
            throw new IllegalStateException("Descriptor TypeName is only available if a service has a valid super type, please guard with SuperServiceType#present().");
        }
        return this.descriptorTypeName;
    }
}

