/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.ClassCode;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.ModuleInfo;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.TypeHierarchy;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.service.codegen.DescriptorClassCode;
import io.helidon.service.codegen.HelidonMetaInfServices;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.RoundContextImpl;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.spi.RegistryCodegenExtension;
import io.helidon.service.codegen.spi.RegistryCodegenExtensionProvider;
import io.helidon.service.metadata.DescriptorMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class ServiceRegistryCodegenExtension
implements CodegenExtension {
    private final Set<DescriptorMetadata> generatedServiceDescriptors = new HashSet<DescriptorMetadata>();
    private final List<ExtensionInfo> extensions;
    private final RegistryCodegenContext ctx;
    private final String module;

    private ServiceRegistryCodegenExtension(CodegenContext ctx, List<RegistryCodegenExtensionProvider> extensions) {
        this.ctx = RegistryCodegenContext.create(ctx);
        this.module = ctx.moduleName().orElse(null);
        this.extensions = extensions.stream().map(it -> {
            RegistryCodegenExtension extension = it.create(this.ctx);
            return new ExtensionInfo(extension, ServiceRegistryCodegenExtension.discoveryPredicate(it.supportedAnnotations(), it.supportedAnnotationPackages()), it.supportedMetaAnnotations());
        }).toList();
    }

    static ServiceRegistryCodegenExtension create(CodegenContext ctx, List<RegistryCodegenExtensionProvider> extensions) {
        return new ServiceRegistryCodegenExtension(ctx, extensions);
    }

    public void process(RoundContext roundContext) {
        ArrayList<DescriptorClassCode> descriptors = new ArrayList<DescriptorClassCode>();
        Collection allTypes = roundContext.types();
        if (allTypes.isEmpty()) {
            this.extensions.forEach(it -> it.extension().process(this.createRoundContext(roundContext, List.of(), (ExtensionInfo)it, (List<DescriptorClassCode>)descriptors)));
            return;
        }
        List<TypeInfoAndAnnotations> annotatedTypes = this.annotatedTypes(allTypes);
        for (ExtensionInfo extension : this.extensions) {
            extension.extension().process(this.createRoundContext(roundContext, annotatedTypes, extension, descriptors));
        }
        this.writeNewTypes(descriptors);
        for (TypeInfo typeInfo : roundContext.annotatedTypes(ServiceCodegenTypes.SERVICE_ANNOTATION_DESCRIPTOR)) {
            Annotation descriptorAnnot = typeInfo.annotation(ServiceCodegenTypes.SERVICE_ANNOTATION_DESCRIPTOR);
            double weight = descriptorAnnot.doubleValue("weight").orElse(100.0);
            Set contracts = descriptorAnnot.typeValues("contracts").stream().flatMap(Collection::stream).map(ResolvedType::create).collect(Collectors.toUnmodifiableSet());
            this.generatedServiceDescriptors.add(DescriptorMetadata.create((TypeName)typeInfo.typeName(), (double)weight, contracts, Set.of()));
        }
        if (roundContext.availableAnnotations().size() == 1 && roundContext.availableAnnotations().contains(TypeNames.GENERATED) && !this.generatedServiceDescriptors.isEmpty()) {
            this.addDescriptorsToServiceMeta();
            this.generatedServiceDescriptors.clear();
        }
    }

    public void processingOver(RoundContext roundContext) {
        this.extensions.stream().map(ExtensionInfo::extension).forEach(RegistryCodegenExtension::processingOver);
        if (!this.generatedServiceDescriptors.isEmpty()) {
            this.addDescriptorsToServiceMeta();
            this.generatedServiceDescriptors.clear();
        }
    }

    private static Predicate<TypeName> discoveryPredicate(Set<TypeName> typeNames, Collection<String> packages) {
        List<String> prefixes = packages.stream().map(it -> it.endsWith(".*") ? it.substring(0, it.length() - 2) : it).toList();
        return typeName -> {
            if (typeNames.contains(typeName)) {
                return true;
            }
            String packageName = typeName.packageName();
            for (String prefix : prefixes) {
                if (!packageName.startsWith(prefix)) continue;
                return true;
            }
            return false;
        };
    }

    private void addDescriptorsToServiceMeta() {
        boolean hasModule;
        Optional currentModule = this.ctx.module();
        Object moduleName = this.module == null ? (String)currentModule.map(ModuleInfo::name).orElse(null) : this.module;
        String packageName = CodegenOptions.CODEGEN_PACKAGE.findValue(this.ctx.options()).orElseGet(() -> this.topLevelPackage(this.generatedServiceDescriptors));
        boolean bl = hasModule = moduleName != null && !"unnamed module".equals(moduleName);
        if (!hasModule) {
            moduleName = "unnamed/" + packageName + (String)(this.ctx.scope().isProduction() ? "" : "/" + this.ctx.scope().name());
        }
        HelidonMetaInfServices services = HelidonMetaInfServices.create(this.ctx.filer(), (String)moduleName);
        services.addAll(this.generatedServiceDescriptors);
        services.write();
    }

    private void writeNewTypes(List<DescriptorClassCode> descriptors) {
        for (DescriptorClassCode descriptor : descriptors) {
            ClassCode classCode = descriptor.classCode();
            this.generatedServiceDescriptors.add(DescriptorMetadata.create((TypeName)classCode.newType(), (double)descriptor.weight(), descriptor.contracts(), descriptor.factoryContracts()));
        }
    }

    private List<TypeInfoAndAnnotations> annotatedTypes(Collection<TypeInfo> allTypes) {
        ArrayList<TypeInfoAndAnnotations> result = new ArrayList<TypeInfoAndAnnotations>();
        for (TypeInfo typeInfo : allTypes) {
            result.add(new TypeInfoAndAnnotations(typeInfo, TypeHierarchy.nestedAnnotations((CodegenContext)this.ctx, (TypeInfo)typeInfo)));
        }
        return result;
    }

    private RegistryRoundContext createRoundContext(RoundContext roundContext, List<TypeInfoAndAnnotations> annotatedTypes, ExtensionInfo extension, List<DescriptorClassCode> newDescriptors) {
        HashSet<TypeName> availableAnnotations = new HashSet<TypeName>();
        HashMap<TypeName, List> annotationToTypes = new HashMap<TypeName, List>();
        HashMap<TypeName, TypeInfo> processedTypes = new HashMap<TypeName, TypeInfo>();
        for (TypeInfoAndAnnotations annotatedType : annotatedTypes) {
            for (TypeName annotationType : annotatedType.annotations()) {
                if (!extension.supportedAnnotationsPredicate.test(annotationType) && !this.isMetaAnnotated(roundContext, extension, annotationType)) continue;
                availableAnnotations.add(annotationType);
                processedTypes.put(annotatedType.typeInfo().typeName(), annotatedType.typeInfo());
                annotationToTypes.computeIfAbsent(annotationType, k -> new ArrayList()).add(annotatedType.typeInfo());
            }
        }
        HashMap metaAnnotated = new HashMap();
        for (TypeName typeName : extension.supportedMetaAnnotations()) {
            metaAnnotated.put(typeName, Set.copyOf(roundContext.annotatedAnnotations(typeName)));
        }
        return new RoundContextImpl(this.ctx, roundContext, newDescriptors::add, Set.copyOf(availableAnnotations), Map.copyOf(annotationToTypes), Map.copyOf(metaAnnotated), List.copyOf(processedTypes.values()));
    }

    private boolean isMetaAnnotated(RoundContext roundContext, ExtensionInfo extension, TypeName annotationType) {
        for (TypeName typeName : extension.supportedMetaAnnotations()) {
            if (!roundContext.annotatedAnnotations(typeName).contains(annotationType)) continue;
            return true;
        }
        return false;
    }

    private String topLevelPackage(Set<DescriptorMetadata> typeNames) {
        String thePackage = typeNames.iterator().next().descriptorType().packageName();
        for (DescriptorMetadata typeName : typeNames) {
            String nextPackage = typeName.descriptorType().packageName();
            if (nextPackage.length() >= thePackage.length()) continue;
            thePackage = nextPackage;
        }
        return thePackage;
    }

    private record ExtensionInfo(RegistryCodegenExtension extension, Predicate<TypeName> supportedAnnotationsPredicate, Set<TypeName> supportedMetaAnnotations) {
    }

    private record TypeInfoAndAnnotations(TypeInfo typeInfo, Set<TypeName> annotations) {
    }
}

