/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeNames;
import io.helidon.service.codegen.InterceptionStrategy;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.TypedElements;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

final class Interception {
    private static final Annotation RUNTIME_RETENTION = Annotation.create(Retention.class, (String)RetentionPolicy.RUNTIME.name());
    private static final Annotation CLASS_RETENTION = Annotation.create(Retention.class, (String)RetentionPolicy.CLASS.name());
    private final InterceptionStrategy interceptionStrategy;

    Interception(InterceptionStrategy interceptionStrategy) {
        this.interceptionStrategy = interceptionStrategy;
    }

    List<TypedElements.ElementMeta> maybeIntercepted(TypeInfo typeInfo) {
        if (this.interceptionStrategy == InterceptionStrategy.NONE) {
            return List.of();
        }
        ArrayList<TypedElements.ElementMeta> result = new ArrayList<TypedElements.ElementMeta>();
        List<TypedElements.ElementMeta> allElements = TypedElements.gatherElements(typeInfo);
        if (this.hasInterceptTrigger(typeInfo)) {
            allElements.stream().filter(it -> it.element().accessModifier() != AccessModifier.PRIVATE).forEach(result::add);
            result.add(TypedElements.DEFAULT_CONSTRUCTOR);
        } else {
            allElements.stream().filter(methodMetadata -> this.hasInterceptTrigger(typeInfo, (TypedElements.ElementMeta)methodMetadata)).peek(it -> {
                if (it.element().accessModifier() == AccessModifier.PRIVATE) {
                    throw new CodegenException(typeInfo.typeName().fqName() + "#" + it.element().elementName() + " is declared as private, but has interceptor trigger annotation declared. This cannot be supported, as we do not modify sources or bytecode.", it.element().originatingElementValue());
                }
            }).forEach(result::add);
        }
        return result;
    }

    List<TypedElements.ElementMeta> maybeIntercepted(TypeInfo typeInfo, List<TypedElements.ElementMeta> elements) {
        if (this.interceptionStrategy == InterceptionStrategy.NONE) {
            return List.of();
        }
        ArrayList<TypedElements.ElementMeta> result = new ArrayList<TypedElements.ElementMeta>();
        if (this.hasInterceptTrigger(typeInfo)) {
            elements.stream().filter(it -> it.element().accessModifier() != AccessModifier.PRIVATE).forEach(result::add);
            result.add(TypedElements.DEFAULT_CONSTRUCTOR);
        } else {
            elements.stream().filter(methodMetadata -> this.hasInterceptTrigger(typeInfo, (TypedElements.ElementMeta)methodMetadata)).peek(it -> {
                if (it.element().accessModifier() == AccessModifier.PRIVATE) {
                    throw new CodegenException(typeInfo.typeName().fqName() + "#" + it.element().elementName() + " is declared as private, but has interceptor trigger annotation declared. This cannot be supported, as we do not modify sources or bytecode.", it.element().originatingElementValue());
                }
            }).forEach(result::add);
        }
        return result;
    }

    private boolean hasInterceptTrigger(TypeInfo typeInfo) {
        if (this.hasInterceptTrigger(typeInfo, (Annotated)typeInfo)) {
            return true;
        }
        for (TypeInfo ifaceType : typeInfo.interfaceTypeInfo()) {
            if (!this.hasInterceptTrigger(ifaceType)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInterceptTrigger(TypeInfo typeInfo, TypedElements.ElementMeta methodMeta) {
        if (this.hasInterceptTrigger(typeInfo, (Annotated)methodMeta.element())) {
            return true;
        }
        Iterator<TypedElements.DeclaredElement> iterator = methodMeta.abstractMethods().iterator();
        if (iterator.hasNext()) {
            TypedElements.DeclaredElement interfaceMethod = iterator.next();
            return this.hasInterceptTrigger(interfaceMethod.abstractType(), (Annotated)interfaceMethod.element());
        }
        return false;
    }

    private boolean hasInterceptTrigger(TypeInfo typeInfo, Annotated element) {
        for (Annotation annotation : element.annotations()) {
            Optional retention;
            if (this.interceptionStrategy.ordinal() >= InterceptionStrategy.EXPLICIT.ordinal() && typeInfo.hasMetaAnnotation(annotation.typeName(), ServiceCodegenTypes.INTERCEPTION_INTERCEPTED)) {
                return true;
            }
            if (this.interceptionStrategy.ordinal() >= InterceptionStrategy.ALL_RUNTIME.ordinal()) {
                retention = typeInfo.metaAnnotation(annotation.typeName(), TypeNames.RETENTION);
                boolean isRuntime = retention.map(arg_0 -> ((Annotation)RUNTIME_RETENTION).equals(arg_0)).orElse(false);
                if (isRuntime) {
                    return true;
                }
            }
            if (this.interceptionStrategy.ordinal() < InterceptionStrategy.ALL_RETAINED.ordinal()) continue;
            retention = typeInfo.metaAnnotation(annotation.typeName(), TypeNames.RETENTION);
            boolean isClass = retention.map(arg_0 -> ((Annotation)CLASS_RETENTION).equals(arg_0)).orElse(false);
            if (!isClass) continue;
            return true;
        }
        return false;
    }
}

