/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc;

import io.helidon.common.Errors;
import io.helidon.common.LazyValue;
import io.helidon.common.parameters.Parameters;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.SetCookie;
import io.helidon.http.Status;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Grant;
import io.helidon.security.Principal;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Role;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityException;
import io.helidon.security.SecurityLevel;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.abac.scope.ScopeValidator;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.JwtUtil;
import io.helidon.security.jwt.JwtValidator;
import io.helidon.security.jwt.SignedJwt;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.providers.common.TokenCredential;
import io.helidon.security.providers.oidc.OidcFeature;
import io.helidon.security.providers.oidc.OidcUtil;
import io.helidon.security.providers.oidc.common.OidcConfig;
import io.helidon.security.providers.oidc.common.Tenant;
import io.helidon.security.providers.oidc.common.TenantConfig;
import io.helidon.security.util.TokenHandler;
import io.helidon.webclient.api.HttpClientRequest;
import io.helidon.webclient.api.HttpClientResponse;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class TenantAuthenticationHandler {
    private static final System.Logger LOGGER = System.getLogger(TenantAuthenticationHandler.class.getName());
    private static final TokenHandler PARAM_HEADER_HANDLER = TokenHandler.forHeader((String)"X_OIDC_TOKEN_HEADER");
    private static final TokenHandler PARAM_ID_HEADER_HANDLER = TokenHandler.forHeader((String)"X_OIDC_ID_TOKEN_HEADER");
    private static final LazyValue<SecureRandom> RANDOM = LazyValue.create(SecureRandom::new);
    private static final JwtValidator TIME_VALIDATORS = JwtValidator.builder().addDefaultTimeValidators().build();
    private final boolean optional;
    private final OidcConfig oidcConfig;
    private final TenantConfig tenantConfig;
    private final Tenant tenant;
    private final boolean useJwtGroups;
    private final BiFunction<SignedJwt, Errors.Collector, Errors.Collector> jwtValidator;
    private final BiConsumer<StringBuilder, String> scopeAppender;
    private final Pattern attemptPattern;

    TenantAuthenticationHandler(OidcConfig oidcConfig, Tenant tenant, boolean useJwtGroups, boolean optional) {
        this.oidcConfig = oidcConfig;
        this.tenant = tenant;
        this.tenantConfig = tenant.tenantConfig();
        this.useJwtGroups = useJwtGroups;
        this.optional = optional;
        this.attemptPattern = Pattern.compile(".*?" + oidcConfig.redirectAttemptParam() + "=(\\d+).*");
        this.jwtValidator = this.tenantConfig.validateJwtWithJwk() ? (signedJwt, collector) -> {
            JwkKeys jwk = tenant.signJwk();
            Errors errors = signedJwt.verifySignature(jwk);
            errors.forEach(errorMessage -> {
                switch (errorMessage.getSeverity()) {
                    case FATAL: {
                        collector.fatal(errorMessage.getSource(), errorMessage.getMessage());
                        break;
                    }
                    case WARN: {
                        collector.warn(errorMessage.getSource(), errorMessage.getMessage());
                        break;
                    }
                    default: {
                        collector.hint(errorMessage.getSource(), errorMessage.getMessage());
                    }
                }
            });
            return collector;
        } : (signedJwt, collector) -> {
            block14: {
                Parameters.Builder form = Parameters.builder((String)"oidc-form-params").add("token", new String[]{signedJwt.tokenContent()});
                HttpClientRequest post = (HttpClientRequest)((HttpClientRequest)((HttpClientRequest)((HttpClientRequest)tenant.appWebClient().post()).uri(tenant.introspectUri())).header(HeaderValues.ACCEPT_JSON)).headers(it -> it.add(HeaderNames.CACHE_CONTROL, new String[]{"no-cache, no-store, must-revalidate"}));
                OidcUtil.updateRequest(OidcConfig.RequestType.INTROSPECT_JWT, this.tenantConfig, form);
                try (HttpClientResponse response = post.submit((Object)form.build());){
                    if (response.status().family() == Status.Family.SUCCESSFUL) {
                        try {
                            JsonObject jsonObject = (JsonObject)response.as(JsonObject.class);
                            if (!jsonObject.getBoolean("active")) {
                                collector.fatal((Object)jsonObject, "Token is not active");
                            }
                            break block14;
                        }
                        catch (Exception e) {
                            collector.fatal((Object)e, "Failed to validate token, request failed: Failed to read JSON from response");
                        }
                        break block14;
                    }
                    try {
                        String message = (String)response.as(String.class);
                        collector.fatal((Object)response.status(), "Failed to validate token, response status: " + String.valueOf(response.status()) + ", entity: " + message);
                    }
                    catch (Exception e) {
                        collector.fatal((Object)e, "Failed to validate token, request failed: Failed to process error entity");
                    }
                }
                catch (Exception e) {
                    collector.fatal((Object)e, "Failed to validate token, request failed: Failed to invoke request");
                }
            }
            return collector;
        };
        String configuredScopeAudience = this.tenantConfig.scopeAudience();
        this.scopeAppender = configuredScopeAudience == null || configuredScopeAudience.isEmpty() ? StringBuilder::append : (configuredScopeAudience.endsWith("/") ? (stringBuilder, scope) -> stringBuilder.append(configuredScopeAudience).append((String)scope) : (stringBuilder, scope) -> stringBuilder.append(configuredScopeAudience).append("/").append((String)scope));
    }

    AuthenticationResponse authenticate(String tenantId, ProviderRequest providerRequest) {
        Optional idToken = Optional.empty();
        try {
            Optional cookie;
            if (this.oidcConfig.useParam() && (idToken = idToken.or(() -> PARAM_ID_HEADER_HANDLER.extractToken(providerRequest.env().headers()))).isEmpty()) {
                idToken = idToken.or(() -> providerRequest.env().queryParams().first(this.oidcConfig.idTokenParamName()).asOptional());
            }
            if (this.oidcConfig.useCookie() && idToken.isEmpty() && (cookie = this.oidcConfig.idTokenCookieHandler().findCookie(providerRequest.env().headers())).isPresent()) {
                try {
                    String idTokenValue = (String)cookie.get();
                    return this.validateIdToken(tenantId, providerRequest, idTokenValue);
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                        LOGGER.log(System.Logger.Level.DEBUG, "Invalid id token in cookie", (Throwable)e);
                    }
                    return this.errorResponse(providerRequest, Status.UNAUTHORIZED_401, null, "Invalid id token", tenantId);
                }
            }
        }
        catch (SecurityException e) {
            LOGGER.log(System.Logger.Level.DEBUG, "Failed to extract token from one of the configured locations", (Throwable)e);
            return this.failOrAbstain("Failed to extract one of the configured tokens" + String.valueOf((Object)e));
        }
        if (idToken.isPresent()) {
            return this.validateIdToken(tenantId, providerRequest, (String)idToken.get());
        }
        return this.processAccessToken(tenantId, providerRequest, null);
    }

    private AuthenticationResponse processAccessToken(String tenantId, ProviderRequest providerRequest, Jwt idToken) {
        Optional token;
        LinkedList<String> missingLocations;
        block14: {
            missingLocations = new LinkedList<String>();
            token = Optional.empty();
            try {
                if (this.oidcConfig.useHeader() && (token = token.or(() -> this.oidcConfig.headerHandler().extractToken(providerRequest.env().headers()))).isEmpty()) {
                    missingLocations.add("header");
                }
                if (this.oidcConfig.useParam()) {
                    if ((token = token.or(() -> PARAM_HEADER_HANDLER.extractToken(providerRequest.env().headers()))).isEmpty()) {
                        token = token.or(() -> providerRequest.env().queryParams().first(this.oidcConfig.paramName()).asOptional());
                    }
                    if (token.isEmpty()) {
                        missingLocations.add("query-param");
                    }
                }
                if (!this.oidcConfig.useCookie() || !token.isEmpty()) break block14;
                Optional cookie = this.oidcConfig.tokenCookieHandler().findCookie(providerRequest.env().headers());
                if (cookie.isEmpty()) {
                    missingLocations.add("cookie");
                    break block14;
                }
                try {
                    String tokenValue = (String)cookie.get();
                    String decodedJson = new String(Base64.getDecoder().decode(tokenValue), StandardCharsets.UTF_8);
                    JsonObject jsonObject = OidcFeature.JSON_READER_FACTORY.createReader((Reader)new StringReader(decodedJson)).readObject();
                    if (this.oidcConfig.accessTokenIpCheck()) {
                        Object userIp = providerRequest.env().abacAttribute("userIp").orElseThrow();
                        if (!jsonObject.getString("remotePeer").equals(userIp)) {
                            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                                LOGGER.log(System.Logger.Level.DEBUG, "Current peer IP does not match the one this access token was issued for");
                            }
                            return this.errorResponse(providerRequest, Status.UNAUTHORIZED_401, "peer_host_mismatch", "Peer host access token mismatch", tenantId);
                        }
                    }
                    return this.validateAccessToken(tenantId, providerRequest, jsonObject.getString("accessToken"), idToken);
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                        LOGGER.log(System.Logger.Level.DEBUG, "Invalid access token in cookie", (Throwable)e);
                    }
                    return this.errorResponse(providerRequest, Status.UNAUTHORIZED_401, null, "Invalid access token", tenantId);
                }
            }
            catch (SecurityException e) {
                LOGGER.log(System.Logger.Level.DEBUG, "Failed to extract access token from one of the configured locations", (Throwable)e);
                return this.failOrAbstain("Failed to extract one of the configured tokens" + String.valueOf((Object)e));
            }
        }
        if (token.isPresent()) {
            return this.validateAccessToken(tenantId, providerRequest, (String)token.get(), idToken);
        }
        LOGGER.log(System.Logger.Level.DEBUG, () -> "Missing access token, could not find in either of: " + String.valueOf(missingLocations));
        return this.errorResponse(providerRequest, Status.UNAUTHORIZED_401, null, "Missing access token, could not find in either of: " + String.valueOf(missingLocations), tenantId);
    }

    private Set<String> expectedScopes(ProviderRequest request) {
        HashSet<String> result = new HashSet<String>();
        for (SecurityLevel securityLevel : request.endpointConfig().securityLevels()) {
            List expectedScopes = securityLevel.combineAnnotations(ScopeValidator.Scopes.class, EndpointConfig.AnnotationScope.values());
            expectedScopes.stream().map(ScopeValidator.Scopes::value).map(Arrays::asList).map(Collection::stream).forEach(stream -> stream.map(ScopeValidator.Scope::value).forEach(result::add));
            List expectedScopeAnnotations = securityLevel.combineAnnotations(ScopeValidator.Scope.class, EndpointConfig.AnnotationScope.values());
            expectedScopeAnnotations.stream().map(ScopeValidator.Scope::value).forEach(result::add);
        }
        return result;
    }

    private AuthenticationResponse errorResponse(ProviderRequest providerRequest, Status status, String code, String description, String tenantId) {
        if (this.oidcConfig.shouldRedirect()) {
            String origUri = this.origUri(providerRequest);
            int redirectAttempt = this.redirectAttempt(origUri);
            if (redirectAttempt >= this.oidcConfig.maxRedirects()) {
                return this.errorResponseNoRedirect(code, description, status);
            }
            String state = TenantAuthenticationHandler.generateRandomString();
            Set<String> expectedScopes = this.expectedScopes(providerRequest);
            StringBuilder scopes = new StringBuilder(this.tenantConfig.baseScopes());
            for (String expectedScope : expectedScopes) {
                String scope;
                if (!scopes.isEmpty()) {
                    scopes.append(' ');
                }
                if ((scope = expectedScope).startsWith("/")) {
                    scope = scope.substring(1);
                }
                this.scopeAppender.accept(scopes, scope);
            }
            String scopeString = URLEncoder.encode(scopes.toString(), StandardCharsets.UTF_8);
            String authorizationEndpoint = this.tenant.authorizationEndpointUri();
            String nonce = UUID.randomUUID().toString();
            String redirectUri = "@default".equals(tenantId) ? this.encode(this.redirectUri(providerRequest.env())) : this.encode(this.redirectUri(providerRequest.env()) + "?" + this.encode(this.oidcConfig.tenantParamName()) + "=" + this.encode(tenantId));
            String queryString = "?client_id=" + this.tenantConfig.clientId() + "&response_type=code&redirect_uri=" + redirectUri + "&scope=" + scopeString + "&nonce=" + nonce + "&state=" + state;
            JsonObject stateJson = OidcFeature.JSON_BUILDER_FACTORY.createObjectBuilder().add("originalUri", origUri).add("state", state).add("nonce", nonce).build();
            String stateBase64 = Base64.getEncoder().encodeToString(stateJson.toString().getBytes(StandardCharsets.UTF_8));
            SetCookie cookie = this.oidcConfig.stateCookieHandler().createCookie(stateBase64).build();
            return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.FAILURE_FINISH)).statusCode(Status.TEMPORARY_REDIRECT_307.code())).responseHeader(HeaderNames.SET_COOKIE.defaultCase(), cookie.toString())).description("Redirecting to identity server: " + description)).responseHeader("Location", authorizationEndpoint + queryString)).build();
        }
        return this.errorResponseNoRedirect(code, description, status);
    }

    private String redirectUri(SecurityEnvironment env) {
        for (Map.Entry entry : env.headers().entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase("host") || ((List)entry.getValue()).isEmpty()) continue;
            String firstHost = (String)((List)entry.getValue()).getFirst();
            String schema = this.oidcConfig.forceHttpsRedirects() ? "https" : env.transport();
            return this.oidcConfig.redirectUriWithHost(schema + "://" + firstHost);
        }
        return this.oidcConfig.redirectUriWithHost();
    }

    private AuthenticationResponse failOrAbstain(String message) {
        if (this.optional) {
            return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.ABSTAIN)).description(message)).build();
        }
        return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.FAILURE)).description(message)).build();
    }

    private AuthenticationResponse errorResponseNoRedirect(String code, String description, Status status) {
        if (this.optional) {
            return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.ABSTAIN)).description(description)).build();
        }
        if (null == code) {
            return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.FAILURE)).statusCode(Status.UNAUTHORIZED_401.code())).responseHeader(HeaderNames.WWW_AUTHENTICATE.defaultCase(), "Bearer realm=\"" + this.tenantConfig.realm() + "\"")).description(description)).build();
        }
        return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.FAILURE)).statusCode(status.code())).responseHeader(HeaderNames.WWW_AUTHENTICATE.defaultCase(), this.errorHeader(code, description))).description(description)).build();
    }

    private int redirectAttempt(String state) {
        Matcher matcher;
        if (state.contains("?") && (matcher = this.attemptPattern.matcher(state)).matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 1;
    }

    private String errorHeader(String code, String description) {
        return "Bearer realm=\"" + this.tenantConfig.realm() + "\", error=\"" + code + "\", error_description=\"" + description + "\"";
    }

    String origUri(ProviderRequest providerRequest) {
        List origUri = providerRequest.env().headers().getOrDefault("X_ORIG_URI_HEADER", List.of());
        if (origUri.isEmpty()) {
            URI targetUri = providerRequest.env().targetUri();
            String query = targetUri.getQuery();
            String path = targetUri.getPath();
            if (query == null || query.isEmpty()) {
                return path;
            }
            return path + "?" + query;
        }
        return (String)origUri.getFirst();
    }

    private String encode(String state) {
        return URLEncoder.encode(state, StandardCharsets.UTF_8);
    }

    private AuthenticationResponse validateIdToken(String tenantId, ProviderRequest providerRequest, String idToken) {
        SignedJwt signedJwt;
        try {
            signedJwt = SignedJwt.parseToken((String)idToken);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Could not parse inbound id token", (Throwable)e);
            }
            return AuthenticationResponse.failed((String)"Invalid id token", (Throwable)e);
        }
        try {
            Errors errors = this.oidcConfig.idTokenSignatureValidation() ? this.jwtValidator.apply(signedJwt, Errors.collector()).collect() : Errors.collector().collect();
            Jwt jwt = signedJwt.getJwt();
            JwtValidator.Builder jwtValidatorBuilder = JwtValidator.builder().addDefaultTimeValidators().addCriticalValidator().addUserPrincipalValidator().addAudienceValidator(this.tenantConfig.clientId());
            if (this.tenant.issuer() != null) {
                jwtValidatorBuilder.addIssuerValidator(this.tenant.issuer());
            }
            JwtValidator jwtValidation = jwtValidatorBuilder.build();
            Errors validationErrors = jwtValidation.validate(jwt);
            if (errors.isValid() && validationErrors.isValid()) {
                return this.processAccessToken(tenantId, providerRequest, jwt);
            }
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                errors.log(LOGGER);
                validationErrors.log(LOGGER);
            }
            return this.errorResponse(providerRequest, Status.UNAUTHORIZED_401, "invalid_id_token", "Id token not valid", tenantId);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Failed to validate request", (Throwable)e);
            }
            return AuthenticationResponse.failed((String)"Failed to validate JWT", (Throwable)e);
        }
    }

    private AuthenticationResponse validateAccessToken(String tenantId, ProviderRequest providerRequest, String token, Jwt idToken) {
        SignedJwt signedJwt;
        try {
            signedJwt = SignedJwt.parseToken((String)token);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Could not parse inbound token", (Throwable)e);
            }
            return AuthenticationResponse.failed((String)"Invalid token", (Throwable)e);
        }
        try {
            Errors.Collector collector = this.oidcConfig.tokenSignatureValidation() ? this.jwtValidator.apply(signedJwt, Errors.collector()) : Errors.collector();
            Errors timeErrors = TIME_VALIDATORS.validate(signedJwt.getJwt());
            if (timeErrors.isValid()) {
                return this.processValidationResult(providerRequest, signedJwt, idToken, tenantId, collector);
            }
            Optional refreshToken = this.oidcConfig.refreshTokenCookieHandler().findCookie(providerRequest.env().headers());
            return refreshToken.map(refreshTokenValue -> this.refreshAccessToken(providerRequest, (String)refreshTokenValue, idToken, tenantId)).orElseGet(() -> this.processValidationResult(providerRequest, signedJwt, idToken, tenantId, collector));
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Failed to validate request", (Throwable)e);
            }
            return AuthenticationResponse.failed((String)"Failed to validate JWT", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private AuthenticationResponse refreshAccessToken(ProviderRequest providerRequest, String refreshTokenString, Jwt idToken, String tenantId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AuthenticationResponse processValidationResult(ProviderRequest providerRequest, SignedJwt signedJwt, Jwt idToken, String tenantId, Errors.Collector collector) {
        return this.processValidationResult(providerRequest, signedJwt, idToken, tenantId, collector, List.of());
    }

    private AuthenticationResponse processValidationResult(ProviderRequest providerRequest, SignedJwt signedJwt, Jwt idToken, String tenantId, Errors.Collector collector, List<String> cookies) {
        Jwt jwt = signedJwt.getJwt();
        Errors errors = collector.collect();
        JwtValidator.Builder jwtValidatorBuilder = JwtValidator.builder().addDefaultTimeValidators().addCriticalValidator().addUserPrincipalValidator();
        if (this.tenant.issuer() != null) {
            jwtValidatorBuilder.addIssuerValidator(this.tenant.issuer());
        }
        if (this.tenantConfig.checkAudience()) {
            jwtValidatorBuilder.addAudienceValidator(this.tenantConfig.audience());
        }
        JwtValidator jwtValidation = jwtValidatorBuilder.build();
        Errors validationErrors = jwtValidation.validate(jwt);
        if (errors.isValid() && validationErrors.isValid()) {
            errors.log(LOGGER);
            Subject subject = this.buildSubject(jwt, signedJwt, idToken);
            Set scopes = subject.grantsByType("scope").stream().map(Grant::getName).collect(Collectors.toSet());
            Set<String> expectedScopes = this.expectedScopes(providerRequest);
            LinkedList<String> missingScopes = new LinkedList<String>();
            for (String expectedScope : expectedScopes) {
                if (scopes.contains(expectedScope)) continue;
                missingScopes.add(expectedScope);
            }
            if (missingScopes.isEmpty()) {
                AuthenticationResponse.Builder response = ((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.SUCCESS)).user(subject);
                if (cookies.isEmpty()) {
                    return response.build();
                }
                return ((AuthenticationResponse.Builder)response.responseHeader(HeaderNames.SET_COOKIE.defaultCase(), cookies)).build();
            }
            return this.errorResponse(providerRequest, Status.FORBIDDEN_403, "insufficient_scope", "Scopes " + String.valueOf(missingScopes) + " are missing", tenantId);
        }
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            errors.log(LOGGER);
            validationErrors.log(LOGGER);
        }
        return this.errorResponse(providerRequest, Status.UNAUTHORIZED_401, "invalid_token", "Token not valid", tenantId);
    }

    private Subject buildSubject(Jwt jwt, SignedJwt signedJwt, Jwt idToken) {
        Principal principal = this.buildPrincipal(jwt, idToken);
        TokenCredential.Builder builder = TokenCredential.builder();
        jwt.issueTime().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).issueTime(arg_0));
        jwt.expirationTime().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).expTime(arg_0));
        jwt.issuer().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).issuer(arg_0));
        builder.token(signedJwt.tokenContent());
        builder.addToken(Jwt.class, (Object)jwt);
        builder.addToken(SignedJwt.class, (Object)signedJwt);
        Subject.Builder subjectBuilder = Subject.builder().principal(principal).addPublicCredential(TokenCredential.class, (Object)builder.build());
        if (this.useJwtGroups) {
            Optional userGroups = jwt.userGroups();
            userGroups.ifPresent(groups -> groups.forEach(group -> subjectBuilder.addGrant((Grant)Role.create((String)group))));
        }
        Optional scopes = jwt.scopes();
        scopes.ifPresent(scopeList -> scopeList.forEach(scope -> subjectBuilder.addGrant(Grant.builder().name(scope).type("scope").build())));
        return subjectBuilder.build();
    }

    private Principal buildPrincipal(Jwt accessToken, Jwt idToken) {
        Jwt tokenToUse = idToken;
        if (idToken == null) {
            tokenToUse = accessToken;
        }
        String subject = (String)tokenToUse.subject().orElseThrow(() -> new JwtException("JWT does not contain subject claim, cannot create principal."));
        String name = tokenToUse.preferredUsername().orElse(subject);
        Principal.Builder builder = Principal.builder();
        builder.name(name).id(subject);
        tokenToUse.payloadClaims().forEach((key, jsonValue) -> builder.addAttribute(key, JwtUtil.toObject((JsonValue)jsonValue)));
        tokenToUse.email().ifPresent(value -> builder.addAttribute("email", value));
        tokenToUse.emailVerified().ifPresent(value -> builder.addAttribute("email_verified", value));
        tokenToUse.locale().ifPresent(value -> builder.addAttribute("locale", value));
        tokenToUse.familyName().ifPresent(value -> builder.addAttribute("family_name", value));
        tokenToUse.givenName().ifPresent(value -> builder.addAttribute("given_name", value));
        tokenToUse.fullName().ifPresent(value -> builder.addAttribute("full_name", value));
        return builder.build();
    }

    private static String generateRandomString() {
        int leftLimit = 48;
        int rightLimit = 122;
        int targetStringLength = 10;
        return ((SecureRandom)RANDOM.get()).ints(leftLimit, rightLimit + 1).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(targetStringLength).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

