/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.providers.oidc.common.BaseBuilder;
import io.helidon.security.providers.oidc.common.OidcConfig;
import io.helidon.security.providers.oidc.common.TenantConfigImpl;
import jakarta.json.JsonObject;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;

public interface TenantConfig {
    public static Builder tenantBuilder() {
        return new Builder();
    }

    public String clientId();

    public String name();

    public String baseScopes();

    public boolean validateJwtWithJwk();

    public Optional<URI> tenantIntrospectUri();

    public Optional<String> tenantIssuer();

    public Optional<JwkKeys> tenantSignJwk();

    public Optional<URI> tenantLogoutEndpointUri();

    public Optional<URI> tenantTokenEndpointUri();

    public String audience();

    public boolean checkAudience();

    public String scopeAudience();

    public URI identityUri();

    public String realm();

    public OidcConfig.ClientAuthentication tokenEndpointAuthentication();

    public Duration clientTimeout();

    public Optional<URI> authorizationEndpoint();

    public String clientSecret();

    public String serverType();

    public JsonObject oidcMetadata();

    public boolean useWellKnown();

    @Configured(description="Open ID Connect tenant configuration")
    public static final class Builder
    extends BaseBuilder<Builder, TenantConfig> {
        private static final String TENANT_IDENT = "name";
        private String name;

        private Builder() {
        }

        @ConfiguredOption(required=true)
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder config(Config config) {
            super.config(config);
            config.get(TENANT_IDENT).asString().ifPresent(this::name);
            return this;
        }

        public TenantConfig build() {
            this.buildConfiguration();
            if (this.name == null) {
                throw new IllegalStateException("Every tenant need to have \"name\" specified");
            }
            return new TenantConfigImpl(this);
        }

        @Override
        String name() {
            return this.name;
        }
    }
}

