/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.parameters.Parameters;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Status;
import io.helidon.security.SecurityException;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.webclient.api.HttpClientRequest;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.WebClient;
import jakarta.json.JsonObject;
import java.net.URI;
import java.time.Duration;

class IdcsSupport {
    private IdcsSupport() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static JwkKeys signJwk(WebClient appWebClient, WebClient generalClient, URI tokenEndpointUri, URI signJwkUri, Duration clientTimeout) {
        Parameters form = Parameters.builder((String)"idcs-form-params").add("grant_type", new String[]{"client_credentials"}).add("scope", new String[]{"urn:opc:idm:__myscopes__"}).build();
        try (HttpClientResponse response = ((HttpClientRequest)((HttpClientRequest)((HttpClientRequest)appWebClient.post()).uri(tokenEndpointUri)).header(HeaderValues.ACCEPT_JSON)).submit((Object)form);){
            if (response.status().family() == Status.Family.SUCCESSFUL) {
                JsonObject json = (JsonObject)response.as(JsonObject.class);
                String accessToken = json.getString("access_token");
                JsonObject jwkJson = (JsonObject)((HttpClientRequest)((HttpClientRequest)((HttpClientRequest)generalClient.get()).uri(signJwkUri)).header(HeaderNames.AUTHORIZATION, new String[]{"Bearer " + accessToken})).requestEntity(JsonObject.class);
                JwkKeys jwkKeys = JwkKeys.create((JsonObject)jwkJson);
                return jwkKeys;
            }
            String errorEntity = (String)response.as(String.class);
            throw new SecurityException("Failed to read JWK from IDCS. Status: " + String.valueOf(response.status()) + ", entity: " + errorEntity);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SecurityException("Failed to read JWK from IDCS", (Throwable)e);
        }
    }
}

