/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.abac.time;

import io.helidon.common.Builder;
import io.helidon.common.Errors;
import io.helidon.common.config.Config;
import io.helidon.security.EndpointConfig;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityLevel;
import io.helidon.security.providers.abac.AbacAnnotation;
import io.helidon.security.providers.abac.AbacValidatorConfig;
import io.helidon.security.providers.abac.spi.AbacValidator;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class TimeValidator
implements AbacValidator<TimeConfig> {
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    private TimeValidator() {
    }

    public static TimeValidator create() {
        return new TimeValidator();
    }

    public Class<TimeConfig> configClass() {
        return TimeConfig.class;
    }

    public String configKey() {
        return "time";
    }

    public TimeConfig fromConfig(Config config) {
        return TimeConfig.create(config);
    }

    public TimeConfig fromAnnotations(EndpointConfig endpointConfig) {
        TimeConfig.Builder builder = TimeConfig.builder();
        for (SecurityLevel securityLevel : endpointConfig.securityLevels()) {
            for (EndpointConfig.AnnotationScope scope : EndpointConfig.AnnotationScope.values()) {
                ArrayList annotations = new ArrayList();
                for (Class<? extends Annotation> clazz : this.supportedAnnotations()) {
                    annotations.addAll(securityLevel.filterAnnotations(clazz, scope));
                }
                for (Annotation annotation : annotations) {
                    if (annotation instanceof DaysOfWeek) {
                        DaysOfWeek daw = (DaysOfWeek)annotation;
                        for (DayOfWeek dayOfWeek : daw.value()) {
                            builder.addDaysOfWeek(dayOfWeek);
                        }
                        continue;
                    }
                    if (annotation instanceof TimesOfDay) {
                        TimesOfDay tods = (TimesOfDay)annotation;
                        for (TimeOfDay tod : tods.value()) {
                            builder.addBetween(LocalTime.parse(tod.from()), LocalTime.parse(tod.to()));
                        }
                        continue;
                    }
                    if (!(annotation instanceof TimeOfDay)) continue;
                    TimeOfDay tod = (TimeOfDay)annotation;
                    builder.addBetween(LocalTime.parse(tod.from()), LocalTime.parse(tod.to()));
                }
            }
        }
        return builder.build();
    }

    public void validate(TimeConfig config, Errors.Collector collector, ProviderRequest request) {
        ZonedDateTime now = request.env().time();
        config.validate(this, now, collector);
    }

    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        return Set.of(TimesOfDay.class, TimeOfDay.class, DaysOfWeek.class);
    }

    public static final class TimeConfig
    implements AbacValidatorConfig {
        private final List<BetweenTime> betweenTimes = new ArrayList<BetweenTime>();
        private final Set<DayOfWeek> daysOfWeek = EnumSet.noneOf(DayOfWeek.class);

        private TimeConfig(Builder builder) {
            this.betweenTimes.addAll(builder.betweenTimes);
            this.daysOfWeek.addAll(builder.daysOfWeek);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static TimeConfig between(LocalTime from, LocalTime to) {
            return TimeConfig.builder().addBetween(from, to).build();
        }

        public static TimeConfig daysOfWeek(DayOfWeek ... days) {
            return TimeConfig.builder().addDaysOfWeek(days).build();
        }

        public static TimeConfig create(Config config) {
            Builder builder = TimeConfig.builder();
            ((List)config.get("time-of-day").asList(Config.class).get()).forEach(tod -> builder.addBetween(LocalTime.parse((CharSequence)tod.get("from").asString().orElse((Object)"00:00:00")), LocalTime.parse((CharSequence)tod.get("to").asString().orElse((Object)"24:00:00"))));
            config.get("days-of-week").asList(DayOfWeek.class).ifPresent(builder::addDaysOfWeek);
            return builder.build();
        }

        void validate(TimeValidator validator, ZonedDateTime now, Errors.Collector collector) {
            DayOfWeek dayOfWeek;
            boolean valid = false;
            LocalTime nowTime = now.toLocalTime();
            for (BetweenTime betweenTime : this.betweenTimes) {
                if (!betweenTime.isValid(nowTime)) continue;
                valid = true;
            }
            if (!valid) {
                collector.fatal((Object)validator, nowTime.format(TIME_FORMATTER) + " is in neither of allowed times: " + String.valueOf(this.betweenTimes));
            }
            if (!this.daysOfWeek.contains(dayOfWeek = now.getDayOfWeek())) {
                collector.fatal((Object)validator, String.valueOf(dayOfWeek) + " is not in allowed days: " + String.valueOf(this.daysOfWeek));
            }
        }

        TimeConfig combineWith(TimeConfig child) {
            return TimeConfig.builder().from(this).from(child).build();
        }

        public static final class Builder
        implements io.helidon.common.Builder<Builder, TimeConfig> {
            private final List<BetweenTime> betweenTimes = new ArrayList<BetweenTime>();
            private final Set<DayOfWeek> daysOfWeek = EnumSet.noneOf(DayOfWeek.class);

            private Builder() {
            }

            public TimeConfig build() {
                return new TimeConfig(this);
            }

            public Builder addBetween(LocalTime from, LocalTime to) {
                this.betweenTimes.add(new BetweenTime(from, to));
                return this;
            }

            public Builder addDaysOfWeek(DayOfWeek ... daysOfWeek) {
                this.daysOfWeek.addAll(Arrays.asList(daysOfWeek));
                return this;
            }

            public Builder addDaysOfWeek(List<DayOfWeek> daysOfWeek) {
                this.daysOfWeek.addAll(daysOfWeek);
                return this;
            }

            public Builder from(TimeConfig timeConfig) {
                this.betweenTimes.addAll(timeConfig.betweenTimes);
                this.daysOfWeek.addAll(timeConfig.daysOfWeek);
                return this;
            }
        }

        private static class BetweenTime {
            private final LocalTime from;
            private final LocalTime to;

            BetweenTime(LocalTime from, LocalTime to) {
                this.from = from;
                this.to = to;
            }

            boolean isValid(LocalTime nowTime) {
                return this.from.isBefore(nowTime) && this.to.isAfter(nowTime);
            }

            public String toString() {
                return String.valueOf(this.from) + " - " + String.valueOf(this.to);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    @Inherited
    @AbacAnnotation
    public static @interface DaysOfWeek {
        public DayOfWeek[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    @Inherited
    @AbacAnnotation
    public static @interface TimesOfDay {
        public TimeOfDay[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    @Inherited
    @AbacAnnotation
    @Repeatable(value=TimesOfDay.class)
    public static @interface TimeOfDay {
        public String from() default "00:00:00";

        public String to() default "23:59:59.999";
    }
}

