/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.openapi.OpenApiFeature;
import io.helidon.openapi.OpenApiManager;
import io.helidon.openapi.OpenApiService;
import io.helidon.openapi.spi.OpenApiManagerProvider;
import io.helidon.openapi.spi.OpenApiServiceProvider;
import io.helidon.webserver.spi.ServerFeatureProvider;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@Prototype.Blueprint
@Prototype.Configured(value="openapi")
@Prototype.Provides(value={ServerFeatureProvider.class})
interface OpenApiFeatureConfigBlueprint
extends Prototype.Factory<OpenApiFeature> {
    @Option.DefaultDouble(value={90.0})
    @Option.Configured
    public double weight();

    @Option.Configured(value="enabled")
    @Option.DefaultBoolean(value={true})
    public boolean isEnabled();

    @Option.Configured
    @Option.Default(value={"/openapi"})
    public String webContext();

    @Option.Configured
    public Optional<String> staticFile();

    @Option.Configured
    public Optional<CrossOriginConfig> cors();

    @Option.Configured
    @Option.Provider(value=OpenApiServiceProvider.class)
    @Option.Singular
    public List<OpenApiService> services();

    @Option.Configured
    @Option.Provider(value=OpenApiManagerProvider.class, discoverServices=false)
    public Optional<OpenApiManager<?>> manager();

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean permitAll();

    @Option.Configured
    @Option.Default(value={"openapi"})
    public List<String> roles();

    @Option.Default(value={"openapi"})
    public String name();

    @Option.Configured
    @Option.Singular
    public Set<String> sockets();
}

