/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.restclientmetrics;

import io.helidon.common.LazyValue;
import io.helidon.microprofile.restclientmetrics.RestClientMetricsCdiExtension;
import io.helidon.microprofile.restclientmetrics.RestClientMetricsConfig;
import io.helidon.microprofile.restclientmetrics.RestClientMetricsFilter;
import jakarta.enterprise.inject.spi.CDI;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;

public class RestClientMetricsClientListener
implements RestClientListener {
    private static final LazyValue<Listener> LISTENER = LazyValue.create(Listener::new);

    public void onNewClient(Class<?> serviceInterface, RestClientBuilder builder) {
        ((Listener)LISTENER.get()).onNewClient(serviceInterface, builder);
    }

    private static class Listener {
        private final RestClientMetricsFilter restClientMetricsFilter;
        private final LazyValue<RestClientMetricsConfig> restClientMetricsConfig = LazyValue.create(() -> {
            boolean enabled = ConfigProvider.getConfig().getOptionalValue("rest-client.metrics.enabled", Boolean.class).orElse(true);
            return ((RestClientMetricsConfig.Builder)RestClientMetricsConfig.builder().enabled(enabled)).build();
        });
        private final LazyValue<RestClientMetricsCdiExtension> ext = LazyValue.create(() -> (RestClientMetricsCdiExtension)CDI.current().getBeanManager().getExtension(RestClientMetricsCdiExtension.class));
        private final Set<Class<?>> restClientsDiscovered = new HashSet();

        private Listener() {
            this.restClientMetricsFilter = RestClientMetricsFilter.create();
        }

        private void onNewClient(Class<?> serviceInterface, RestClientBuilder builder) {
            if (((RestClientMetricsConfig)this.restClientMetricsConfig.get()).enabled()) {
                if (this.restClientsDiscovered.add(serviceInterface)) {
                    ((RestClientMetricsCdiExtension)this.ext.get()).registerMetricsForRestClient(serviceInterface);
                }
                builder.register((Object)this.restClientMetricsFilter, 4900);
            }
        }
    }
}

