/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.LabeledSnapshot;
import io.helidon.metrics.api.Sample;
import org.eclipse.microprofile.metrics.Snapshot;

class WrappedSnapshot
implements LabeledSnapshot {
    private final Sample.Labeled max;
    private final Sample.Derived mean;
    private final Snapshot delegate;

    static WrappedSnapshot create(Snapshot delegate) {
        return new WrappedSnapshot(delegate);
    }

    private WrappedSnapshot(Snapshot delegate) {
        this.delegate = delegate;
        this.max = Sample.labeled((double)delegate.getMax());
        this.mean = Sample.derived((double)delegate.getMean());
    }

    public Sample.Derived value(double quantile) {
        for (Snapshot.PercentileValue pv : this.delegate.percentileValues()) {
            if (!(pv.getPercentile() >= quantile)) continue;
            return Sample.derived((double)pv.getValue());
        }
        return Sample.derived((double)this.delegate.percentileValues()[this.delegate.percentileValues().length - 1].getValue());
    }

    public Sample.Labeled max() {
        return this.max;
    }

    public Sample.Derived mean() {
        return this.mean;
    }

    public long size() {
        return this.delegate.percentileValues().length;
    }
}

