/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.microprofile.security.SecurityCdiExtension;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.BeanManager;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

class SecurityProducer {
    private final AtomicLong contextCounter = new AtomicLong();

    SecurityProducer() {
    }

    @ApplicationScoped
    @Produces
    Security security(BeanManager beanManager) {
        return Contexts.context().flatMap(this::security).orElseGet(() -> this.securityFromExtension(beanManager));
    }

    @RequestScoped
    @Produces
    SecurityContext securityContext(BeanManager beanManager) {
        return Contexts.context().flatMap(this::securityContext).orElseGet(() -> this.emptyContext(this.security(beanManager)));
    }

    private Optional<SecurityContext> securityContext(Context context) {
        return context.get(SecurityContext.class);
    }

    private Optional<Security> security(Context context) {
        return context.get(Security.class);
    }

    private SecurityContext emptyContext(Security security) {
        return security.createContext("security-producer-context-" + this.contextCounter.incrementAndGet());
    }

    private Security securityFromExtension(BeanManager beanManager) {
        return ((SecurityCdiExtension)beanManager.getExtension(SecurityCdiExtension.class)).security().orElseThrow(() -> new IllegalStateException("Security cannot be injected when not configured"));
    }
}

