/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.faulttolerance.Async;
import io.helidon.faulttolerance.Bulkhead;
import io.helidon.faulttolerance.BulkheadConfig;
import io.helidon.faulttolerance.CircuitBreaker;
import io.helidon.faulttolerance.CircuitBreakerConfig;
import io.helidon.faulttolerance.Fallback;
import io.helidon.faulttolerance.FallbackConfig;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.FtHandlerTyped;
import io.helidon.faulttolerance.Retry;
import io.helidon.faulttolerance.RetryConfig;
import io.helidon.faulttolerance.RetryTimeoutException;
import io.helidon.faulttolerance.SupplierHelper;
import io.helidon.faulttolerance.Timeout;
import io.helidon.faulttolerance.TimeoutConfig;
import io.helidon.microprofile.faulttolerance.CancellableFtSupplier;
import io.helidon.microprofile.faulttolerance.FallbackHelper;
import io.helidon.microprofile.faulttolerance.FaultToleranceExtension;
import io.helidon.microprofile.faulttolerance.FaultToleranceMetrics;
import io.helidon.microprofile.faulttolerance.FtSupplier;
import io.helidon.microprofile.faulttolerance.MethodIntrospector;
import io.helidon.microprofile.faulttolerance.RequestScopeHelper;
import io.helidon.microprofile.faulttolerance.ThrowableMapper;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;

class MethodInvoker
implements FtSupplier<Object> {
    private static final MethodStateCache METHOD_STATES = new MethodStateCache();
    private final Method method;
    private final InvocationContext context;
    private final MethodIntrospector introspector;
    private final Context helidonContext;
    private final AtomicBoolean fallbackCalled = new AtomicBoolean(false);
    private final RequestScopeHelper requestScopeHelper;
    private final FtHandlerTyped<Object> handler;
    private final MethodState methodState;
    private long handlerStartNanos;
    private long invocationStartNanos;
    private CancellableFtSupplier<Object> cancellableSupplier;
    private Supplier<?> handlerSupplier;

    MethodInvoker(InvocationContext context, MethodIntrospector introspector) {
        this.context = context;
        this.introspector = introspector;
        this.method = context.getMethod();
        this.helidonContext = Contexts.context().orElseGet(Context::create);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Objects.requireNonNull(ccl);
        MethodStateKey methodStateKey = new MethodStateKey(ccl, context.getTarget().getClass(), this.method);
        this.methodState = METHOD_STATES.computeIfAbsent(methodStateKey, key -> {
            MethodState methodState = new MethodState();
            methodState.lastBreakerState = CircuitBreaker.State.CLOSED;
            if (introspector.hasCircuitBreaker()) {
                methodState.breakerTimerOpen = 0L;
                methodState.breakerTimerClosed = 0L;
                methodState.breakerTimerHalfOpen = 0L;
                methodState.startNanos = System.nanoTime();
            }
            this.initMethodHandler(methodState);
            return methodState;
        });
        this.handler = this.createMethodHandler(this.methodState);
        this.requestScopeHelper = new RequestScopeHelper();
        this.requestScopeHelper.saveScope();
        this.registerMetrics();
    }

    static void clearMethodStatesMap() {
        METHOD_STATES.clear();
    }

    public String toString() {
        String s = super.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(s.substring(s.lastIndexOf(46) + 1)).append(" ").append(this.method.getDeclaringClass().getSimpleName()).append(".").append(this.method.getName()).append("()");
        return sb.toString();
    }

    @Override
    public Object get() throws Throwable {
        this.handlerSupplier = this.ftSupplierToSupplier(this.introspector.isAsynchronous() ? this.asyncToSyncFtSupplier(() -> ((InvocationContext)this.context).proceed()) : () -> ((InvocationContext)this.context).proceed());
        FtSupplier<Object> contextSupplier = () -> Contexts.runInContextWithThrow((Context)this.helidonContext, () -> this.ftSupplierToSupplier(() -> this.handler.invoke(this.handlerSupplier)).get());
        this.updateMetricsBefore();
        if (this.introspector.isAsynchronous()) {
            return this.callSupplierNewThread(contextSupplier);
        }
        Object result = null;
        Throwable throwable = null;
        try {
            result = this.callSupplier(contextSupplier);
        }
        catch (Throwable t) {
            throwable = t;
        }
        this.updateMetricsAfter(throwable);
        if (throwable != null) {
            if (throwable instanceof RetryTimeoutException) {
                RetryTimeoutException rte = (RetryTimeoutException)throwable;
                throw rte.lastRetryException();
            }
            throw throwable;
        }
        return result;
    }

    public <T> FtSupplier<T> asyncToSyncFtSupplier(FtSupplier<Object> supplier) {
        this.cancellableSupplier = CancellableFtSupplier.create(supplier);
        return () -> {
            Object result = this.cancellableSupplier.get();
            if (result instanceof CompletionStage) {
                CompletionStage cs = (CompletionStage)result;
                return cs.toCompletableFuture().get();
            }
            if (result instanceof Future) {
                Future f = (Future)result;
                return f.get();
            }
            throw new InternalError("Supplier must return Future or CompletionStage");
        };
    }

    Supplier<?> ftSupplierToSupplier(FtSupplier<Object> supplier) {
        return () -> {
            try {
                this.invocationStartNanos = System.nanoTime();
                return supplier.get();
            }
            catch (Throwable t) {
                throw SupplierHelper.toRuntimeException((Throwable)t);
            }
        };
    }

    private void registerMetrics() {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        if (this.introspector.hasCircuitBreaker()) {
            FaultToleranceMetrics.CircuitBreakerStateTotal.register((Gauge<Long>)((Gauge)() -> this.methodState.breakerTimerOpen), this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerState.OPEN.get());
            FaultToleranceMetrics.CircuitBreakerStateTotal.register((Gauge<Long>)((Gauge)() -> this.methodState.breakerTimerHalfOpen), this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerState.HALF_OPEN.get());
            FaultToleranceMetrics.CircuitBreakerStateTotal.register((Gauge<Long>)((Gauge)() -> this.methodState.breakerTimerClosed), this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerState.CLOSED.get());
            FaultToleranceMetrics.CircuitBreakerOpenedTotal.register(this.introspector.getMethodNameTag());
        }
        if (this.introspector.hasBulkhead()) {
            FaultToleranceMetrics.BulkheadExecutionsRunning.register((Gauge<Long>)((Gauge)() -> this.methodState.bulkhead.stats().concurrentExecutions()), this.introspector.getMethodNameTag());
            if (this.introspector.isAsynchronous()) {
                FaultToleranceMetrics.BulkheadExecutionsWaiting.register((Gauge<Long>)((Gauge)() -> this.methodState.bulkhead.stats().waitingQueueSize()), this.introspector.getMethodNameTag());
            }
        }
    }

    private Object callSupplier(FtSupplier<Object> supplier) throws Throwable {
        Object result = null;
        Throwable cause = null;
        try {
            this.invocationStartNanos = System.nanoTime();
            result = supplier.get();
        }
        catch (Throwable t) {
            cause = ThrowableMapper.map(SupplierHelper.unwrapThrowable((Throwable)t));
        }
        if (cause != null) {
            throw cause;
        }
        return result;
    }

    private CompletableFuture<Object> callSupplierNewThread(FtSupplier<Object> supplier) {
        FtSupplier<Object> wrappedSupplier = this.requestScopeHelper.wrapInScope(supplier);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        CompletableFuture asyncFuture = Async.create().invoke(() -> {
            Thread.currentThread().setContextClassLoader(ccl);
            try {
                return this.callSupplier(wrappedSupplier);
            }
            catch (Throwable t) {
                throw SupplierHelper.toRuntimeException((Throwable)t);
            }
        });
        final AtomicBoolean mayInterrupt = new AtomicBoolean(false);
        CompletableFuture<Object> resultFuture = new CompletableFuture<Object>(this){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                mayInterrupt.set(mayInterruptIfRunning);
                return super.cancel(mayInterruptIfRunning);
            }
        };
        asyncFuture.whenComplete((result, throwable) -> {
            this.requestScopeHelper.clearScope();
            Throwable cause = SupplierHelper.unwrapThrowable((Throwable)throwable);
            this.updateMetricsAfter(cause);
            if (throwable != null) {
                resultFuture.completeExceptionally(cause);
            } else {
                resultFuture.complete(result);
            }
        });
        resultFuture.exceptionally(t -> {
            if (t instanceof CancellationException || t instanceof TimeoutException) {
                Objects.requireNonNull(this.cancellableSupplier);
                this.cancellableSupplier.cancel();
                if (this.introspector.hasBulkhead()) {
                    this.methodState.bulkhead.cancelSupplier(this.handlerSupplier);
                }
                asyncFuture.cancel(mayInterrupt.get());
            }
            return null;
        });
        return resultFuture;
    }

    private void initMethodHandler(MethodState methodState) {
        if (this.introspector.hasBulkhead()) {
            methodState.bulkhead = Bulkhead.create(builder -> ((BulkheadConfig.Builder)builder.limit(this.introspector.getBulkhead().value())).queueLength(this.introspector.isAsynchronous() ? this.introspector.getBulkhead().waitingTaskQueue() : 0));
        }
        if (this.introspector.hasTimeout()) {
            methodState.timeout = Timeout.create(builder -> ((TimeoutConfig.Builder)builder.timeout(Duration.of(this.introspector.getTimeout().value(), this.introspector.getTimeout().unit()))).currentThread(!this.introspector.isAsynchronous()));
        }
        if (this.introspector.hasCircuitBreaker()) {
            methodState.breaker = CircuitBreaker.create(builder -> ((CircuitBreakerConfig.Builder)((CircuitBreakerConfig.Builder)((CircuitBreakerConfig.Builder)((CircuitBreakerConfig.Builder)((CircuitBreakerConfig.Builder)builder.delay(Duration.of(this.introspector.getCircuitBreaker().delay(), this.introspector.getCircuitBreaker().delayUnit()))).successThreshold(this.introspector.getCircuitBreaker().successThreshold())).errorRatio((int)(this.introspector.getCircuitBreaker().failureRatio() * 100.0))).volume(this.introspector.getCircuitBreaker().requestVolumeThreshold())).applyOn(ThrowableMapper.mapTypes(this.introspector.getCircuitBreaker().failOn()))).skipOn(ThrowableMapper.mapTypes(this.introspector.getCircuitBreaker().skipOn())));
        }
    }

    private FtHandlerTyped<Object> createMethodHandler(MethodState methodState) {
        FaultTolerance.TypedBuilder builder = FaultTolerance.typedBuilder();
        if (methodState.bulkhead != null) {
            builder.addBulkhead(methodState.bulkhead);
        }
        if (methodState.timeout != null) {
            builder.addTimeout(methodState.timeout);
        }
        if (methodState.breaker != null) {
            builder.addBreaker(methodState.breaker);
        }
        if (this.introspector.hasRetry()) {
            int maxRetries = this.calls(this.introspector.getRetry().maxRetries());
            methodState.retry = Retry.create(retryBuilder -> ((RetryConfig.Builder)((RetryConfig.Builder)((RetryConfig.Builder)retryBuilder.retryPolicy((Retry.RetryPolicy)Retry.JitterRetryPolicy.builder().calls(maxRetries).delay(Duration.of(this.introspector.getRetry().delay(), this.introspector.getRetry().delayUnit())).jitter(Duration.of(this.introspector.getRetry().jitter(), this.introspector.getRetry().jitterDelayUnit())).build())).overallTimeout(Duration.of(this.introspector.getRetry().maxDuration(), this.introspector.getRetry().durationUnit()))).applyOn(ThrowableMapper.mapTypes(this.introspector.getRetry().retryOn()))).skipOn(ThrowableMapper.mapTypes(this.introspector.getRetry().abortOn())));
            builder.addRetry(methodState.retry);
        }
        if (this.introspector.hasFallback()) {
            Fallback fallback = Fallback.create(fallbackBuilder -> ((FallbackConfig.Builder)((FallbackConfig.Builder)fallbackBuilder.fallback(throwable -> {
                FallbackHelper cfb = new FallbackHelper(this.context, this.introspector, (Throwable)throwable);
                if (this.introspector.isAsynchronous()) {
                    if (this.method.getReturnType().equals(Future.class) && throwable instanceof ExecutionException) {
                        throw SupplierHelper.toRuntimeException((Throwable)throwable);
                    }
                    CompletableFuture<Object> f = this.callSupplierNewThread(this.asyncToSyncFtSupplier(cfb::execute));
                    try {
                        this.fallbackCalled.set(true);
                        return f.get();
                    }
                    catch (Throwable t) {
                        throw SupplierHelper.toRuntimeException((Throwable)t);
                    }
                }
                try {
                    this.fallbackCalled.set(true);
                    return this.callSupplier(cfb::execute);
                }
                catch (Throwable t) {
                    throw SupplierHelper.toRuntimeException((Throwable)t);
                }
            })).applyOn(ThrowableMapper.mapTypes(this.introspector.getFallback().applyOn()))).skipOn(ThrowableMapper.mapTypes(this.introspector.getFallback().skipOn())));
            builder.addFallback(fallback);
        }
        return builder.build();
    }

    private int calls(int configuredMaxRetries) {
        return configuredMaxRetries == -1 ? Integer.MAX_VALUE : configuredMaxRetries + 1;
    }

    private void updateMetricsBefore() {
        this.handlerStartNanos = System.nanoTime();
        if (this.introspector.hasCircuitBreaker()) {
            this.methodState.lock.lock();
            try {
                this.methodState.lastBreakerState = this.methodState.breaker.state();
            }
            finally {
                this.methodState.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetricsAfter(Throwable cause) {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        this.methodState.lock.lock();
        try {
            long executionTime = System.nanoTime() - this.handlerStartNanos;
            if (this.introspector.hasRetry()) {
                long retryCounter = this.methodState.retry.retryCounter();
                boolean wasRetried = retryCounter > 0L;
                Counter retryRetriesTotal = FaultToleranceMetrics.RetryRetriesTotal.get(this.introspector.getMethodNameTag());
                if (wasRetried) {
                    retryRetriesTotal.inc(retryCounter);
                }
                if (cause == null) {
                    FaultToleranceMetrics.RetryCallsTotal.get(this.introspector.getMethodNameTag(), wasRetried ? FaultToleranceMetrics.RetryRetried.TRUE.get() : FaultToleranceMetrics.RetryRetried.FALSE.get(), FaultToleranceMetrics.RetryResult.VALUE_RETURNED.get()).inc();
                } else if (cause instanceof RetryTimeoutException) {
                    FaultToleranceMetrics.RetryCallsTotal.get(this.introspector.getMethodNameTag(), wasRetried ? FaultToleranceMetrics.RetryRetried.TRUE.get() : FaultToleranceMetrics.RetryRetried.FALSE.get(), FaultToleranceMetrics.RetryResult.MAX_DURATION_REACHED.get()).inc();
                } else {
                    int maxRetries = this.introspector.getRetry().maxRetries();
                    if (maxRetries == -1) {
                        maxRetries = Integer.MAX_VALUE;
                    }
                    if (retryCounter == (long)maxRetries) {
                        FaultToleranceMetrics.RetryCallsTotal.get(this.introspector.getMethodNameTag(), wasRetried ? FaultToleranceMetrics.RetryRetried.TRUE.get() : FaultToleranceMetrics.RetryRetried.FALSE.get(), FaultToleranceMetrics.RetryResult.MAX_RETRIES_REACHED.get()).inc();
                    } else if (retryCounter < (long)maxRetries) {
                        FaultToleranceMetrics.RetryCallsTotal.get(this.introspector.getMethodNameTag(), wasRetried ? FaultToleranceMetrics.RetryRetried.TRUE.get() : FaultToleranceMetrics.RetryRetried.FALSE.get(), FaultToleranceMetrics.RetryResult.EXCEPTION_NOT_RETRYABLE.get()).inc();
                    }
                }
            }
            if (this.introspector.hasTimeout()) {
                if (cause instanceof TimeoutException) {
                    FaultToleranceMetrics.TimeoutCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.TimeoutTimedOut.TRUE.get()).inc();
                } else {
                    FaultToleranceMetrics.TimeoutCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.TimeoutTimedOut.FALSE.get()).inc();
                }
                FaultToleranceMetrics.TimeoutExecutionDuration.get(this.introspector.getMethodNameTag()).update(executionTime);
            }
            if (this.introspector.hasCircuitBreaker()) {
                Objects.requireNonNull(this.methodState.breaker);
                if (this.methodState.lastBreakerState == CircuitBreaker.State.OPEN) {
                    FaultToleranceMetrics.CircuitBreakerCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN.get()).inc();
                } else if (this.methodState.breaker.state() == CircuitBreaker.State.OPEN) {
                    FaultToleranceMetrics.CircuitBreakerOpenedTotal.get(this.introspector.getMethodNameTag()).inc();
                }
                if (cause == null) {
                    FaultToleranceMetrics.CircuitBreakerCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerResult.SUCCESS.get()).inc();
                } else if (!(cause instanceof CircuitBreakerOpenException)) {
                    boolean skipOnThrowable = Arrays.stream(this.introspector.getCircuitBreaker().skipOn()).anyMatch(c -> c.isAssignableFrom(cause.getClass()));
                    boolean failOnThrowable = Arrays.stream(this.introspector.getCircuitBreaker().failOn()).anyMatch(c -> c.isAssignableFrom(cause.getClass()));
                    if (skipOnThrowable || !failOnThrowable) {
                        FaultToleranceMetrics.CircuitBreakerCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerResult.SUCCESS.get()).inc();
                    } else {
                        FaultToleranceMetrics.CircuitBreakerCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerResult.FAILURE.get()).inc();
                    }
                }
                switch (this.methodState.lastBreakerState) {
                    case OPEN: {
                        this.methodState.breakerTimerOpen += System.nanoTime() - this.methodState.startNanos;
                        break;
                    }
                    case CLOSED: {
                        this.methodState.breakerTimerClosed += System.nanoTime() - this.methodState.startNanos;
                        break;
                    }
                    case HALF_OPEN: {
                        this.methodState.breakerTimerHalfOpen += System.nanoTime() - this.methodState.startNanos;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown breaker state " + String.valueOf(this.methodState.lastBreakerState));
                    }
                }
                this.methodState.lastBreakerState = this.methodState.breaker.state();
                this.methodState.startNanos = System.nanoTime();
            }
            if (this.introspector.hasBulkhead()) {
                Objects.requireNonNull(this.methodState.bulkhead);
                Bulkhead.Stats stats = this.methodState.bulkhead.stats();
                Counter bulkheadAccepted = FaultToleranceMetrics.BulkheadCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.BulkheadResult.ACCEPTED.get());
                if (stats.callsAccepted() > bulkheadAccepted.getCount()) {
                    bulkheadAccepted.inc(stats.callsAccepted() - bulkheadAccepted.getCount());
                }
                Counter bulkheadRejected = FaultToleranceMetrics.BulkheadCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.BulkheadResult.REJECTED.get());
                if (stats.callsRejected() > bulkheadRejected.getCount()) {
                    bulkheadRejected.inc(stats.callsRejected() - bulkheadRejected.getCount());
                }
                if (!(cause instanceof BulkheadException)) {
                    long waitingTime = this.invocationStartNanos - this.handlerStartNanos;
                    FaultToleranceMetrics.BulkheadRunningDuration.get(this.introspector.getMethodNameTag()).update(executionTime - waitingTime);
                    if (this.introspector.isAsynchronous()) {
                        FaultToleranceMetrics.BulkheadWaitingDuration.get(this.introspector.getMethodNameTag()).update(waitingTime);
                    }
                }
            }
            if (cause == null) {
                FaultToleranceMetrics.InvocationsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.InvocationResult.VALUE_RETURNED.get(), this.introspector.getFallbackTag(this.fallbackCalled.get())).inc();
            } else {
                FaultToleranceMetrics.InvocationsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.InvocationResult.EXCEPTION_THROWN.get(), this.introspector.getFallbackTag(this.fallbackCalled.get())).inc();
            }
        }
        finally {
            this.methodState.lock.unlock();
        }
    }

    private static class MethodStateKey {
        private final ClassLoader classLoader;
        private final Class<?> methodClass;
        private final Method method;

        MethodStateKey(ClassLoader classLoader, Class<?> methodClass, Method method) {
            this.classLoader = classLoader;
            this.methodClass = methodClass;
            this.method = method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodStateKey that = (MethodStateKey)o;
            return this.classLoader.equals(that.classLoader) && this.methodClass.equals(that.methodClass) && this.method.equals(that.method);
        }

        public int hashCode() {
            return Objects.hash(this.classLoader, this.methodClass, this.method);
        }
    }

    private static class MethodStateCache {
        private final ReentrantLock lock = new ReentrantLock();
        private final Map<MethodStateKey, MethodState> cache = new HashMap<MethodStateKey, MethodState>();

        private MethodStateCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MethodState computeIfAbsent(MethodStateKey key, Function<MethodStateKey, MethodState> function) {
            this.lock.lock();
            try {
                MethodState methodState = this.cache.get(key);
                if (methodState != null) {
                    MethodState methodState2 = methodState;
                    return methodState2;
                }
                MethodState newMethodState = function.apply(key);
                Objects.requireNonNull(newMethodState);
                this.cache.put(key, newMethodState);
                MethodState methodState3 = newMethodState;
                return methodState3;
            }
            finally {
                this.lock.unlock();
            }
        }

        void clear() {
            this.cache.clear();
        }
    }

    private static class MethodState {
        private final ReentrantLock lock = new ReentrantLock();
        private Retry retry;
        private Bulkhead bulkhead;
        private CircuitBreaker breaker;
        private Timeout timeout;
        private CircuitBreaker.State lastBreakerState;
        private long breakerTimerOpen;
        private long breakerTimerClosed;
        private long breakerTimerHalfOpen;
        private long startNanos;

        private MethodState() {
        }
    }
}

