/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.JavaMethodFinder;
import io.helidon.microprofile.faulttolerance.MethodIntrospector;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.Unmanaged;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;

class FallbackHelper {
    private final InvocationContext context;
    private final Throwable throwable;
    private final ExecutionContext executionContext = new ExecutionContext(){

        public Method getMethod() {
            return FallbackHelper.this.context.getMethod();
        }

        public Object[] getParameters() {
            return FallbackHelper.this.context.getParameters();
        }

        public Throwable getFailure() {
            return FallbackHelper.this.throwable;
        }
    };
    private Class<? extends FallbackHandler<?>> handlerClass;
    private Method fallbackMethod;

    FallbackHelper(InvocationContext context, MethodIntrospector introspector, Throwable throwable) {
        this.context = context;
        this.throwable = throwable;
        Fallback fallback = introspector.getFallback();
        if (fallback.value() != Fallback.DEFAULT.class) {
            this.handlerClass = fallback.value();
        } else if (!fallback.fallbackMethod().isEmpty()) {
            Object instance = context.getTarget();
            try {
                this.fallbackMethod = JavaMethodFinder.findMethod(instance.getClass(), introspector.getFallback().fallbackMethod(), context.getMethod().getGenericParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e);
            }
        } else {
            this.handlerClass = Fallback.DEFAULT.class;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        Object result;
        block9: {
            assert (this.handlerClass != null || this.fallbackMethod != null);
            try {
                if (this.handlerClass != null) {
                    Instance instance = CDI.current().select(this.handlerClass, new Annotation[0]);
                    if (instance.isResolvable()) {
                        FallbackHandler handler = (FallbackHandler)instance.get();
                        result = handler.handle(this.executionContext);
                        break block9;
                    }
                    Unmanaged unmanaged = new Unmanaged(CDI.current().getBeanManager(), this.handlerClass);
                    Unmanaged.UnmanagedInstance unmanagedInstance = unmanaged.newInstance();
                    FallbackHandler handler = (FallbackHandler)unmanagedInstance.produce().inject().postConstruct().get();
                    try {
                        result = handler.handle(this.executionContext);
                        break block9;
                    }
                    finally {
                        unmanagedInstance.preDestroy().dispose();
                    }
                }
                result = this.fallbackMethod.invoke(this.context.getTarget(), this.context.getParameters());
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                throw t instanceof Exception ? (Exception)t : new RuntimeException(t);
            }
        }
        return result;
    }
}

