/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.health;

import io.helidon.health.HealthCheckResponse;
import io.helidon.health.HealthCheckType;
import io.helidon.microprofile.health.MpHealthCheck;
import java.util.Locale;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

class MpCheckWrapper
implements MpHealthCheck {
    private final String name;
    private final String path;
    private final HealthCheckType type;
    private final HealthCheck delegate;

    MpCheckWrapper(String name, String path, HealthCheckType type, HealthCheck delegate) {
        this.name = name;
        this.path = path;
        this.type = type;
        this.delegate = delegate;
    }

    static MpCheckWrapper create(HealthCheckType type, HealthCheck delegate) {
        String name;
        try {
            name = delegate.call().getName();
        }
        catch (Throwable e) {
            name = delegate.getClass().getSimpleName().toLowerCase(Locale.ROOT);
        }
        return new MpCheckWrapper(name, name, type, delegate);
    }

    public HealthCheckType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String path() {
        return this.path;
    }

    public io.helidon.health.HealthCheckResponse call() {
        HealthCheckResponse response = this.delegate.call();
        return ((HealthCheckResponse.Builder)io.helidon.health.HealthCheckResponse.builder().status(response.getStatus() == HealthCheckResponse.Status.UP).update(it -> response.getData().ifPresent(details -> details.forEach((arg_0, arg_1) -> ((HealthCheckResponse.Builder)it).detail(arg_0, arg_1))))).build();
    }

    @Override
    public Class<?> checkClass() {
        return this.delegate.getClass();
    }
}

