/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.metrics.api.HistogramSnapshot;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.Timer;
import io.helidon.metrics.providers.micrometer.MDistributionStatisticsConfig;
import io.helidon.metrics.providers.micrometer.MHistogramSnapshot;
import io.helidon.metrics.providers.micrometer.MMeter;
import io.helidon.metrics.providers.micrometer.MMeterRegistry;
import io.helidon.metrics.providers.micrometer.Util;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;

class MTimer
extends MMeter<io.micrometer.core.instrument.Timer>
implements Timer {
    private MTimer(Meter.Id id, io.micrometer.core.instrument.Timer delegate, Builder builder) {
        super(id, delegate, builder);
    }

    private MTimer(Meter.Id id, io.micrometer.core.instrument.Timer delegate) {
        super(id, delegate);
    }

    private MTimer(Meter.Id id, io.micrometer.core.instrument.Timer delegate, Optional<String> scope) {
        super(id, delegate, scope);
    }

    static MTimer create(Meter.Id id, io.micrometer.core.instrument.Timer timer) {
        return new MTimer(id, timer);
    }

    static Builder builder(String name) {
        return new Builder(name);
    }

    static Builder builderFrom(Timer.Builder tBuilder) {
        Builder builder = MTimer.builder(tBuilder.name());
        return builder.from(tBuilder);
    }

    static MTimer create(Meter.Id id, io.micrometer.core.instrument.Timer delegate, Optional<String> scope) {
        return new MTimer(id, delegate, scope);
    }

    static Sample start() {
        return Sample.create(io.micrometer.core.instrument.Timer.start());
    }

    static Sample start(io.helidon.metrics.api.MeterRegistry meterRegistry) {
        if (meterRegistry instanceof MMeterRegistry) {
            MMeterRegistry mMeterRegistry = (MMeterRegistry)meterRegistry;
            return Sample.create(io.micrometer.core.instrument.Timer.start((MeterRegistry)mMeterRegistry.delegate()));
        }
        throw new IllegalArgumentException("Expected meter registry type " + MMeterRegistry.class.getName() + " but was " + meterRegistry.getClass().getName());
    }

    static Sample start(final io.helidon.metrics.api.Clock clock) {
        return Sample.create(io.micrometer.core.instrument.Timer.start((Clock)new Clock(){

            public long wallTime() {
                return clock.wallTime();
            }

            public long monotonicTime() {
                return clock.monotonicTime();
            }
        }));
    }

    public HistogramSnapshot snapshot() {
        return MHistogramSnapshot.create(((io.micrometer.core.instrument.Timer)this.delegate()).takeSnapshot());
    }

    public void record(long amount, TimeUnit unit) {
        ((io.micrometer.core.instrument.Timer)this.delegate()).record(amount, unit);
    }

    public void record(Duration duration) {
        ((io.micrometer.core.instrument.Timer)this.delegate()).record(duration);
    }

    public <T> T record(Supplier<T> f) {
        return (T)((io.micrometer.core.instrument.Timer)this.delegate()).record(f);
    }

    public <T> T record(Callable<T> f) throws Exception {
        return (T)((io.micrometer.core.instrument.Timer)this.delegate()).recordCallable(f);
    }

    public void record(Runnable f) {
        ((io.micrometer.core.instrument.Timer)this.delegate()).record(f);
    }

    public Runnable wrap(Runnable f) {
        return ((io.micrometer.core.instrument.Timer)this.delegate()).wrap(f);
    }

    public <T> Callable<T> wrap(Callable<T> f) {
        return ((io.micrometer.core.instrument.Timer)this.delegate()).wrap(f);
    }

    public <T> Supplier<T> wrap(Supplier<T> f) {
        return ((io.micrometer.core.instrument.Timer)this.delegate()).wrap(f);
    }

    public long count() {
        return ((io.micrometer.core.instrument.Timer)this.delegate()).count();
    }

    public double totalTime(TimeUnit unit) {
        return ((io.micrometer.core.instrument.Timer)this.delegate()).totalTime(unit);
    }

    public double mean(TimeUnit unit) {
        return ((io.micrometer.core.instrument.Timer)this.delegate()).mean(unit);
    }

    public double max(TimeUnit unit) {
        return ((io.micrometer.core.instrument.Timer)this.delegate()).max(unit);
    }

    public String toString() {
        TimeUnit baseTimeUnit = ((io.micrometer.core.instrument.Timer)this.delegate()).baseTimeUnit();
        return this.stringJoiner().add("count=" + ((io.micrometer.core.instrument.Timer)this.delegate()).count()).add("totalTime=" + String.valueOf(Duration.of((long)((io.micrometer.core.instrument.Timer)this.delegate()).totalTime(baseTimeUnit), baseTimeUnit.toChronoUnit()))).toString();
    }

    static class Builder
    extends MMeter.Builder<Timer.Builder, io.micrometer.core.instrument.Timer, Builder, MTimer>
    implements Timer.Builder {
        private double[] percentiles;
        private Duration[] buckets;
        private Duration min;
        private Duration max;
        private Boolean publishPercentileHistogram;

        private Builder(String name) {
            super(name, io.micrometer.core.instrument.Timer.builder((String)name));
            this.percentiles(MDistributionStatisticsConfig.Builder.DEFAULT_PERCENTILES);
        }

        public Builder percentiles(double ... percentiles) {
            this.percentiles = percentiles;
            ((Timer.Builder)this.delegate()).publishPercentiles(percentiles);
            return (Builder)this.identity();
        }

        public Builder buckets(Duration ... buckets) {
            this.buckets = buckets;
            ((Timer.Builder)this.delegate()).serviceLevelObjectives(buckets);
            return (Builder)this.identity();
        }

        public Builder minimumExpectedValue(Duration min) {
            this.min = min;
            ((Timer.Builder)this.delegate()).minimumExpectedValue(min);
            return (Builder)this.identity();
        }

        public Builder maximumExpectedValue(Duration max) {
            this.max = max;
            ((Timer.Builder)this.delegate()).maximumExpectedValue(max);
            return (Builder)this.identity();
        }

        @Override
        protected Builder delegateTags(Iterable<Tag> tags) {
            ((Timer.Builder)this.delegate()).tags(tags);
            return (Builder)this.identity();
        }

        @Override
        protected Builder delegateTag(String key, String value) {
            ((Timer.Builder)this.delegate()).tag(key, value);
            return (Builder)this.identity();
        }

        @Override
        protected Builder delegateDescription(String description) {
            ((Timer.Builder)this.delegate()).description(description);
            return (Builder)this.identity();
        }

        @Override
        protected Builder delegateBaseUnit(String baseUnit) {
            return (Builder)this.identity();
        }

        public Builder publishPercentileHistogram(boolean value) {
            ((Timer.Builder)this.delegate()).publishPercentileHistogram(Boolean.valueOf(value));
            return (Builder)this.identity();
        }

        public Iterable<Double> percentiles() {
            return Util.iterable(this.percentiles);
        }

        public Iterable<Duration> buckets() {
            return List.of(this.buckets);
        }

        public Optional<Duration> minimumExpectedValue() {
            return Optional.ofNullable(this.min);
        }

        public Optional<Duration> maximumExpectedValue() {
            return Optional.ofNullable(this.max);
        }

        public Optional<Boolean> publishPercentileHistogram() {
            return Optional.ofNullable(this.publishPercentileHistogram);
        }

        @Override
        protected MTimer build(Meter.Id id, io.micrometer.core.instrument.Timer meter) {
            return new MTimer(id, meter, this);
        }

        @Override
        protected Class<? extends Meter> meterType() {
            return Timer.class;
        }

        Builder from(Timer.Builder other) {
            this.percentiles = Builder.iterToArray(other.percentiles());
            this.buckets = StreamSupport.stream(other.buckets().spliterator(), false).toList().toArray(new Duration[0]);
            other.maximumExpectedValue().ifPresent(this::maximumExpectedValue);
            other.minimumExpectedValue().ifPresent(this::minimumExpectedValue);
            return (Builder)super.from((Meter.Builder<?, ?>)other);
        }

        private static double[] iterToArray(Iterable<Double> iter) {
            List<Double> doubles = StreamSupport.stream(iter.spliterator(), false).toList();
            double[] d = new double[doubles.size()];
            for (int i = 0; i < doubles.size(); ++i) {
                d[i] = doubles.get(i);
            }
            return d;
        }
    }

    static class Sample
    implements Timer.Sample {
        private final Timer.Sample delegate;

        private Sample(Timer.Sample delegate) {
            this.delegate = delegate;
        }

        static Sample create(Timer.Sample delegate) {
            return new Sample(delegate);
        }

        public long stop(Timer timer) {
            if (timer instanceof MTimer) {
                MTimer mTimer = (MTimer)timer;
                return this.delegate.stop((io.micrometer.core.instrument.Timer)mTimer.delegate());
            }
            throw new IllegalArgumentException("Expected timer type " + MTimer.class.getName() + " but was " + timer.getClass().getName());
        }
    }
}

